%% Simulate the distribution of the estimator for a vector x.
%% This is just P_v x where v is a random gaussian vector. 

x = abs(normrnd(0, 1, [2,1]));
x = x/norm(x);

Y = [];
for i=1:100,
    Pi = normrnd(0,1,[2,1]);
    yt = Pi*(Pi'*Pi)^(-1)*Pi'*x;
    Y(:,i) = yt;
end;

figure();
plot([0 x(1,1)], [0 x(2,1)],'LineWidth', 2);
xlim([-0.5 1]);
ylim([-0.5 1]);
hold on;
scatter(Y(1,:), Y(2,:), 5);
plot([0 0], [-2 2], 'black', 'LineWidth', 1);
plot([-2 2], [0 0], 'black', 'LineWidth', 1);
