%% Rates of convergence figures for compressive SL algorithm. 
%% Plots error and rescaled error as a function of problem
%% dimension d. 

ds = 10:5:50;
ns = [5000, 10000, 20000];
r = 5;
k1 = 1;
k2 = 0;
m = 5;

es = zeros(size(ns,2), size(ds,2));
vs = zeros(size(ns,2), size(ds,2));
for i=1:size(ns,2),
    [e,v] = d_experiment(ds, ns(i), r, k1, k2, m);
    es(i,:) = e;
    vs(i,:) = v;
end;

f = figure();
errorbar(ds, es(1,:), vs(1,:), 'blue');
hold on;
l1 = plot(ds, es(1,:), 'bo', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'b');
errorbar(ds, es(2,:), vs(2,:), 'red');
l2 = plot(ds, es(2,:), 'rs', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'r');
errorbar(ds, es(3,:), vs(3,:), 'green');
l3 = plot(ds, es(3,:), 'gd', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'g');


h = xlabel('Dimension (d)');
set(h, 'FontSize', 20);
h = ylabel('Error');
set(h, 'FontSize', 20);
set(gca, 'Fontsize', 20);
xlim([ds(1), ds(end)]);

legend([l1 l2 l3], sprintf('n=%d', ns(1)), sprintf('n=%d', ns(2)), sprintf('n=%d', ns(3)), 2);
saveas(f, './figs/d_fig.fig', 'fig');
saveas(f, './figs/d_fig.eps', 'epsc');