function [errs, vs] = d_experiment(ds, N, r, k1, k2, m, varargin),
%% Record error as a function of problem dimension d. 
%% Generates a dxN matrix (either low_rank or aligned) of
%% "approximate" rank r and runs the compressive algorithm.

%% Parameters:
%% ds,N -- problem dimension (ds should be a vector of problem dimensions)
%% r -- rank (or approximate rank)
%% k1 -- range parameter on the singular values in the directions
%% of interest.
%% k2 -- gap parameter between upper and lower ranks
%% m -- number of measurements to make per column
iters = 20;

errs = [];
vs = [];
for i=1:size(ds,2),
    suberrs = [];
    for j=1:iters;
        if k2 == 0,
            M = low_rank_matrix(ds(i),N,r,k1);
        else,
            M = sep_matrix_additive(ds(i),N,r,k1,k2);
        end;

        [u,s,v] = eigs(M*M',r);
        
        Pi = compressed_sl(M, r, m);
        suberrs(j) = norm(Pi - u*u', 2);
    end;
    errs(i) = mean(suberrs);
    vs(i) = var(suberrs);
    fprintf('d = %d, err = %0.3f\n', ds(i), errs(i));
end;