%% Rates of convergence figures for compressive SL algorithm. 
%% Plots error and rescaled error as a function of # of column N. 

n = 20000;
step = 20;
do_exact = 0;
if do_exact == 1;
e1 = asymp_exp(10, n, 3, 1, 0, 2, 'decor', 1, 'plot', 0);
e2 = asymp_exp(20, n, 3, 1, 0, 2, 'decor', 1, 'plot', 0);
e3 = asymp_exp(10, n, 6, 1, 0, 2, 'decor', 1, 'plot', 0);
e4 = asymp_exp(20, n, 6, 1, 0, 2, 'decor', 1, 'plot', 0);


f = figure();
x = step:step:n;
plot(x, e1, 'blue');
hold on;
l1 = plot(x(1:100:end), e1(1:100:end), 'bo', 'MarkerSize', 8);
plot(x, e2, 'green');
l2 = plot(x(1:100:end), e2(1:100:end), 'go', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'g');
plot(x, e3, 'red');
l3 = plot(x(1:100:end), e3(1:100:end), 'rd', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'r');
plot(x, e4, 'black');
l4 = plot(x(1:100:end), e4(1:100:end), 'ks', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'k');

h = xlabel('# of Samples (n)');
set(h, 'FontSize', 20);
h = ylabel('Error');
set(h, 'FontSize', 20);
set(gca, 'Fontsize', 20);

legend([l1 l2 l3 l4],'d=10, k=3', 'd=20, k=3', 'd=10, k=6', 'd=20, k=6');
saveas(f, './figs/conv.fig', 'fig');
saveas(f, './figs/conv.eps', 'epsc');

f = figure();
plot(x, sqrt(x).*e1, 'blue');
hold on;
l1 = plot(x(1:100:end), sqrt(x(1:100:end)).*e1(1:100:end), 'bo', 'MarkerSize', 8);
plot(x, sqrt(x).*e2, 'green');
l2 = plot(x(1:100:end), sqrt(x(1:100:end)).*e2(1:100:end), 'go', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'g');
plot(x, sqrt(x).*e3, 'red');
l3 = plot(x(1:100:end), sqrt(x(1:100:end)).*e3(1:100:end), 'rd', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'r');
plot(x, sqrt(x).*e4, 'black');
l4 = plot(x(1:100:end), sqrt(x(1:100:end)).*e4(1:100:end), 'ks', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'k');

h = xlabel('# of Samples (n)');
set(h, 'FontSize', 20);
h = ylabel('sqrt(n) * Error');
set(h, 'FontSize', 20);
set(gca, 'Fontsize', 20);

legend([l1 l2 l3 l4], 'd=10, k=3', 'd=20, k=3', 'd=10, k=6', 'd=20, k=6', 2);
saveas(f, './figs/conv_rescaled.fig', 'fig');
saveas(f, './figs/conv_rescaled.eps', 'epsc');
end;

e1a = asymp_exp(10, n, 3, 1, 0.75, 2, 'decor', 1, 'plot', 0);
e2a = asymp_exp(20, n, 3, 1, 0.75, 2, 'decor', 1, 'plot', 0);
e3a = asymp_exp(10, n, 6, 1, 0.75, 2, 'decor', 1, 'plot', 0);
e4a = asymp_exp(20, n, 6, 1, 0.75, 2, 'decor', 1, 'plot', 0);

f = figure();
plot(x, e1a, 'blue');
hold on;
l1 = plot(x(1:100:end), e1a(1:100:end), 'bo', 'MarkerSize', 8);
plot(x, e2a, 'green');
l2 = plot(x(1:100:end), e2a(1:100:end), 'go', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'g');
plot(x, e3a, 'red');
l3 = plot(x(1:100:end), e3a(1:100:end), 'rd', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'r');
plot(x, e4a, 'black');
l4 = plot(x(1:100:end), e4a(1:100:end), 'ks', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'k');

h = xlabel('# of Samples (n)');
set(h, 'FontSize', 20);
h = ylabel('Error');
set(h, 'FontSize', 20);
set(gca, 'Fontsize', 20);

legend([l1 l2 l3 l4], 'd=10, k=3', 'd=20, k=3', 'd=10, k=6', 'd=20, k=6');
saveas(f, './figs/conv_approx.fig', 'fig');
saveas(f, './figs/conv_approx.eps', 'epsc');

f = figure();
plot(x, sqrt(x).*e1a, 'blue');
hold on;
l1 = plot(x(1:100:end), sqrt(x(1:100:end)).*e1a(1:100:end), 'bo', 'MarkerSize', 8);
plot(x, sqrt(x).*e2a, 'green');
l2 = plot(x(1:100:end), sqrt(x(1:100:end)).*e2a(1:100:end), 'go', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'g');
plot(x, sqrt(x).*e3a, 'red');
l3 = plot(x(1:100:end), sqrt(x(1:100:end)).*e3a(1:100:end), 'rd', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'r');
plot(x, sqrt(x).*e4a, 'black');
l4 = plot(x(1:100:end), sqrt(x(1:100:end)).*e4a(1:100:end), 'ks', 'MarkerSize', 8, 'MarkerFaceColor', ...
          'k');

h = xlabel('# of Samples (n)');
set(h, 'FontSize', 20);
h = ylabel('sqrt(n) * Error');
set(h, 'FontSize', 20);
set(gca, 'Fontsize', 20);

legend([l1 l2 l3 l4], 'd=10, k=3', 'd=20, k=3', 'd=10, k=6', 'd=20, k=6', 2);
saveas(f, './figs/conv_approx_rescaled.fig', 'fig');
saveas(f, './figs/conv_approx_rescaled.eps', 'epsc');