function [Pi, Chat] = compressed_sl(M, r, m),
%% compressed subspace learning algorithm. Input matrix M, target
%% rank r and m = # of compressed measurements per column.
  d = size(M,1);
  N = size(M,2);
  Chat = zeros(d,d);
  for t=1:N,
      At = normrnd(0, 1, d, m);
      Pt = At*(At'*At)^(-1)*At';
      Chat = Chat + Pt*M(:,t)*(Pt*M(:,t))';
  end;
  [u,s,v] = eigs(Chat, r);
  Pi = u*u';
