%% Compare our subspace learning algorithm with the algorithm of
%% Halko Martinsson and Tropp.

d = 20;
n = 10000;
k = 2;
m1 = 2;
m2 = 10;
iters = 20;
step = 50;

e_other_m1 = zeros(1, n/step);
e_other_m2 = zeros(1, n/step);
e_ours_m1 = zeros(1, n/step);
e_ours_m2 = zeros(1, n/step);
for i=1:iters,
    M = low_rank_matrix(d,n,k,1);
    [u,s] = eigs(M*M', k);

    Chat_m1 = zeros(d,d);
    Chat_m2 = zeros(d,d);
    for j=1:n,
        %% Our algorithm
        At = normrnd(0,1, d, m1);
        Pt = At*(At'*At)^(-1)*At';

        Chat_m1 = Chat_m1 + Pt*M(:,j)*(Pt*M(:,j))';
        
        At = normrnd(0,1, d, m2);
        Pt = At*(At'*At)^(-1)*At';

        Chat_m2 = Chat_m2 + Pt*M(:,j)*(Pt*M(:,j))';

        if mod(j,step) == 0,
            %% Not our algorithm
            At = normrnd(0,1,d,m1);
            Pt = At*(At'*At)^(-1)*At';
            
            Mhat = Pt*M(:,1:j);
            Chat_o = Mhat*Mhat';
            [u_o,s_o] = eigs(Chat_o, k);
            e_o = norm(u*u' - u_o*u_o',2);
            e_other_m1(1, j/step) = e_other_m1(1, j/step) + e_o;

            At = normrnd(0,1,d,m2);
            Pt = At*(At'*At)^(-1)*At';
            
            Mhat = Pt*M(:,1:j);
            Chat_o = Mhat*Mhat';
            [u_o,s_o] = eigs(Chat_o, k);
            e_o = norm(u*u' - u_o*u_o',2);
            e_other_m2(1, j/step) = e_other_m2(1, j/step) + e_o;


            [up,sp] = eigs(Chat_m1, k);
            e_u = norm(u*u' - up*up',2);
            e_ours_m1(1, j/step) = e_ours_m1(1, j/step) + e_u;

            [up,sp] = eigs(Chat_m2, k);
            e_u = norm(u*u' - up*up',2);
            e_ours_m2(1, j/step) = e_ours_m2(1, j/step) + e_u;
        
            fprintf('n=%d, theirs = %0.3f ours = %0.3f\n', j, e_o, e_u);
        end;
    end;
end;
e_other_m1 = e_other_m1/iters;
e_other_m2 = e_other_m2/iters;
e_ours_m1 = e_ours_m1/iters;
e_ours_m2 = e_ours_m2/iters;

f = figure();
xvec = step:step:n;
plot(xvec, e_ours_m1, 'b');
hold on;
l1 = plot(xvec(1:10:end), e_ours_m1(1:10:end), 'bo', 'MarkerSize', 8);
plot(xvec, e_ours_m2, 'g');
l2 = plot(xvec(1:10:end), e_ours_m2(1:10:end), 'go', 'MarkerSize', ...
          8, 'MarkerFaceColor', 'g');
plot(xvec, e_other_m1, 'r');
l3 = plot(xvec(1:10:end), e_other_m1(1:10:end), 'rd', 'MarkerSize', ...
          8, 'MarkerFaceColor', 'r');
plot(xvec, e_other_m2, 'k');
l4 = plot(xvec(1:10:end), e_other_m2(1:10:end), 'ks', 'MarkerSize', ...
          8, 'MarkerFaceColor', 'k');
ylim([0,1.1]);

h = xlabel('# of Samples (n)');
set(h, 'FontSize', 20);
h = ylabel('Error');
set(h, 'FontSize', 20);
set(gca, 'Fontsize', 20);

legend([l1 l2 l3 l4], 'CSL m=2', 'CSL m =10', 'HMT m=2', 'HMT m=10', 3);
