function [M] = aligned_matrix(d,N,r,gap),
%% Generate a dxN matrix of random gaussian vectors with diagonal
%% covariance matrix. The top r coordinates of the covariance are 1
%% and the remaining coordinates are 1-gap
  Sigma = diag([repmat(1, [1 r]) repmat(1 - gap, [1 d-r])]);
  
  M = mvnrnd(repmat(0, [d, 1]), Sigma, N);
  M = M';
