import numpy as np
import os

import util

import gmm

def max_score():
    return 1.5

def timeout():
    return 60

def test():
    figures_directory = 'figures'
    os.makedirs(figures_directory, exist_ok=True)

    print('Testing PCA on MNIST zeros and ones dataset...')

    X = gmm.load_data()

    Z = gmm.pca(X, 2)

    filename = '{}/pca_MNIST_after'.format(figures_directory)
    util.plot_gmm(Z, [], [], show_figure=False, save_filename=filename)

    expected_Z = {}
    expected_Z[(0, 0)] = -3.7631
    expected_Z[(0, 1)] = -1.6549
    expected_Z[(3, 0)] = 3.3869
    expected_Z[(3, 1)] = -3.2275

    for i, j in [(0, 0), (0, 1), (3, 0), (3, 1)]:
        assert abs(Z[i, j] - expected_Z[(i, j)]) < 1e-2, 'Incorrect value in Z[{}, {}]. Expected {}, found {}'.format(i, j, expected_Z[(i, j)], Z[i, j])
     
    test_score = max_score()
    test_output = 'PASS\n'

    return test_score, test_output

if __name__ == "__main__":
    test()

