import numpy as np
import os

import util

import gmm

def max_score():
    return 1.5

def timeout():
    return 60

def test():
    figures_directory = 'figures'
    os.makedirs(figures_directory, exist_ok=True)

    print('Testing PCA on simple 2-D dataset...')

    X = np.array([
            [1, 1], [3, 1], [11, 11], [13,11],
            [3, 3], [1, 3], [13, 13], [11,13]], dtype=np.float32)

    filename = '{}/pca_toy1_before'.format(figures_directory)
    util.plot_gmm(X, [], [], show_figure=False, save_filename=filename)

    Z = gmm.pca(X, 2)

    filename = '{}/pca_toy1_after'.format(figures_directory)
    util.plot_gmm(Z, [], [], show_figure=False, save_filename=filename)

    expected_Z = {}
    expected_Z[(0, 0)] = -8.4853
    expected_Z[(0, 1)] = 0.0000
    expected_Z[(3, 0)] = 7.0711
    expected_Z[(3, 1)] = 1.4142

    for i, j in [(0, 0), (0, 1), (3, 0), (3, 1)]:
        assert abs(Z[i, j] - expected_Z[(i, j)]) < 1e-2, 'Incorrect value in Z[{}, {}]. Expected {}, found {}'.format(i, j, expected_Z[(i, j)], Z[i, j])
     
    test_score = max_score()
    test_output = 'PASS\n'

    return test_score, test_output

if __name__ == "__main__":
    test()

