import numpy as np

import kmeans

def max_score():
    return 1.5

def timeout():
    return 60

def test():

    print('Testing on just first 10 points of MNIST data...')

    X = kmeans.load_data()
    X = X[:10]

    K = 10
    print('K: ', K)
    print()

    C, z = kmeans.kmeans(X, K)

    loss = kmeans.kmeans_loss(X, C, z)
    print('Loss: ', loss)
    print()

    expected_loss = 0

    assert abs(loss - expected_loss) < 1e-3, 'Incorrect loss found. Expected {}, found {}'.format(expected_loss, loss)
     
    test_score = max_score()
    test_output = 'PASS\n'

    return test_score, test_output

if __name__ == "__main__":
    test()

