import numpy as np

import kmeans

def max_score():
    return 1.5

def timeout():
    return 60

def test():

    print('Testing on simple 2-D dataset...')

    X = np.array([
            [1, 1], [3, 1], [1, 3], [3,3],
            [11, 1], [1, 11], [11, 11], [13,13]], dtype=np.float32)

    K = 4
    print('K: ', K)
    print()

    print('X:')
    print(X)

    C, z = kmeans.kmeans(X, K)

    print('C:')
    print(C)
    print('z:')
    print(z)
    print()

    loss = kmeans.kmeans_loss(X, C, z)
    print('Loss: ', loss)
    print()

    expected_loss = 1.5

    assert abs(loss - expected_loss) < 1e-3, 'Incorrect loss found. Expected {}, found {}'.format(expected_loss, loss)
     
    test_score = max_score()
    test_output = 'PASS\n'

    return test_score, test_output

if __name__ == "__main__":
    test()

