import numpy as np

import util

import kmeans

def max_score():
    return 4

def timeout():
    return 300

def test():

    print('Testing on full MNIST data...')

    X = kmeans.load_data()

    K = 2
    print('K: ', K)
    print()

    C, z = kmeans.kmeans(X, K)

    # Save images of centers
    util.save_mnist_kmeans_centers(C)

    loss = kmeans.kmeans_loss(X, C, z)
    print('Loss: ', loss)
    print()

    expected_loss = 3211609.0554

    assert abs(loss - expected_loss) < 1, 'Incorrect loss found. Expected {}, found {}'.format(expected_loss, loss)
     
    test_score = max_score()
    test_output = 'PASS\n'

    return test_score, test_output

if __name__ == "__main__":
    test()

