import numpy as np
import matplotlib.pyplot as plt
import os

import util

import kernel_regression

def max_score():
    return 6

def timeout():
    return 300

def test():

    figures_directory = 'figures'

    os.makedirs(figures_directory, exist_ok=True)

    expected_mse_train_values = {}
    expected_mse_val_values = {}

    expected_mse_train_values[(1, 0.01)] = 0.0150
    expected_mse_val_values[(1, 0.01)] = 21.2263
    expected_mse_train_values[(1, 0.1)] = 0.0150
    expected_mse_val_values[(1, 0.1)] = 95.7318
    expected_mse_train_values[(1, 1)] = 0.0150
    expected_mse_val_values[(1, 1)] = 107.7821
    expected_mse_train_values[(2, 0.01)] = 0.0076
    expected_mse_val_values[(2, 0.01)] = 8.2881
    expected_mse_train_values[(2, 0.1)] = 0.0146
    expected_mse_val_values[(2, 0.1)] = 80.1111
    expected_mse_train_values[(2, 1)] = 0.0147
    expected_mse_val_values[(2, 1)] = 107.7760
    expected_mse_train_values[(10, 0.01)] = 0.4200
    expected_mse_val_values[(10, 0.01)] = 11.5976
    expected_mse_train_values[(10, 0.1)] = 0.0046
    expected_mse_val_values[(10, 0.1)] = 39.8140
    expected_mse_train_values[(10, 1)] = 0.0091
    expected_mse_val_values[(10, 1)] = 99.3436
    expected_mse_train_values[(50, 0.01)] = 1.2054
    expected_mse_val_values[(50, 0.01)] = 5.0705
    expected_mse_train_values[(50, 0.1)] = 0.0065
    expected_mse_val_values[(50, 0.1)] = 1.2793
    expected_mse_train_values[(50, 1)] = 0.0081
    expected_mse_val_values[(50, 1)] = 51.8014
    expected_mse_train_values[(200, 0.01)] = 1.5676
    expected_mse_val_values[(200, 0.01)] = 2.6871
    expected_mse_train_values[(200, 0.1)] = 0.0028
    expected_mse_val_values[(200, 0.1)] = 0.0117
    expected_mse_train_values[(200, 1)] = 0.0044
    expected_mse_val_values[(200, 1)] = 2.6656

    X_train, y_train, X_val, y_val = kernel_regression.load_data()

    for N in [1, 2, 10, 50, 200]:
        for gamma in [0.01, 0.1, 1]:
            print('Testing RBF kernel for N={} gamma={}'.format(N, gamma))

            kernel_function = lambda x, z: kernel_regression.rbf_kernel(x, z, gamma=gamma)

            h = lambda X: kernel_regression.predict_kernel_regression(X, X_train[:N], y_train[:N], kernel_function)

            # Compute and check training error
            mse_train = kernel_regression.mse(y_train[:N], h(X_train[:N]))

            print('\tmse_train:  {:.4f}'.format(mse_train))
            expected_mse_train = expected_mse_train_values[(N, gamma)]
            assert abs(mse_train - expected_mse_train) < 0.01 , 'Incorrect training MSE value found for RBF kernel N={}, gamma={}. Expected {}, found {}'.format(N, gamma, expected_mse_train, mse_train)

            # Compute and check validation error
            mse_val = kernel_regression.mse(y_val, h(X_val))

            print('\tmse_val:    {:.4f}'.format(mse_val))
            expected_mse_val = expected_mse_val_values[(N, gamma)]
            assert abs(mse_val - expected_mse_val) < 0.01 , 'Incorrect validation MSE value found for RBF kernel N={}, gamma={}. Expected {}, found {}'.format(N, gamma, expected_mse_val, mse_val)

            # Plot training data and predicted surface

            filename = '{}/regression_rbf_N_{}_gamma_{:0.2f}.png'.format(figures_directory, N, gamma)
            filename = filename.replace('.', '_', 1)
            title = 'RBF kernel, gamma = {}, N = {}'.format(gamma, N)

            points = np.hstack((X_train[:N], y_train[:N]))

            util.plot_surface(h, points, title=title,
                    new_figure=True, show_figure=False, save_filename=filename)
            plt.close()

    test_score = max_score()
    test_output = 'PASS\n'

    return test_score, test_output

if __name__ == "__main__":
    test()
