import numpy as np
import matplotlib.pyplot as plt
import os

import util

import kernel_regression

def max_score():
    return 5

def timeout():
    return 300

def test():

    figures_directory = 'figures'

    os.makedirs(figures_directory, exist_ok=True)

    expected_mse_train_values = {}
    expected_mse_val_values = {}

    expected_mse_train_values[(1, 2)] = 0.0000
    expected_mse_val_values[(1, 2)] = 71.8406
    expected_mse_train_values[(1, 3)] = 0.0000
    expected_mse_val_values[(1, 3)] = 274.3511
    expected_mse_train_values[(2, 2)] = 0.0000
    expected_mse_val_values[(2, 2)] = 67.0046
    expected_mse_train_values[(2, 3)] = 0.0000
    expected_mse_val_values[(2, 3)] = 236.1011
    expected_mse_train_values[(10, 2)] = 1.1175
    expected_mse_val_values[(10, 2)] = 7.4861
    expected_mse_train_values[(10, 3)] = 0.0004
    expected_mse_val_values[(10, 3)] = 1093.8565
    expected_mse_train_values[(50, 2)] = 1.5402
    expected_mse_val_values[(50, 2)] = 3.8204
    expected_mse_train_values[(50, 3)] = 1.4284
    expected_mse_val_values[(50, 3)] = 4.0443
    expected_mse_train_values[(200, 2)] = 1.8141
    expected_mse_val_values[(200, 2)] = 3.2442
    expected_mse_train_values[(200, 3)] = 1.7268
    expected_mse_val_values[(200, 3)] = 2.9832

    X_train, y_train, X_val, y_val = kernel_regression.load_data()

    for N in [1, 2, 10, 50, 200]:
        for d in [2, 3]:
            print('Testing polynomial kernel for N={} d={}'.format(N, d))

            kernel_function = lambda x, z: kernel_regression.polynomial_kernel(x, z, d=d)

            h = lambda X: kernel_regression.predict_kernel_regression(X, X_train[:N], y_train[:N], kernel_function)

            # Compute and check training error
            mse_train = kernel_regression.mse(y_train[:N], h(X_train[:N]))

            print('\tmse_train:  {:.4f}'.format(mse_train))
            expected_mse_train = expected_mse_train_values[(N, d)]
            assert abs(mse_train - expected_mse_train) < 0.01 , 'Incorrect training MSE value found for polynomial kernel N={}, d={}. Expected {}, found {}'.format(N, d, expected_mse_train, mse_train)

            # Compute and check validation error
            mse_val = kernel_regression.mse(y_val, h(X_val))

            print('\tmse_val:    {:.4f}'.format(mse_val))
            expected_mse_val = expected_mse_val_values[(N, d)]
            assert abs(mse_val - expected_mse_val) < 0.01 , 'Incorrect validation MSE value found for polynomial kernel N={}, d={}. Expected {}, found {}'.format(N, d, expected_mse_val, mse_val)

            # Plot training data and predicted surface

            filename = '{}/regression_polynomial_N_{}_d_{}.png'.format(figures_directory, N, d)
            title = 'Polynomial kernel, d = {}, N = {}'.format(d, N)

            points = np.hstack((X_train[:N], y_train[:N]))

            util.plot_surface(h, points, title=title,
                    new_figure=True, show_figure=False, save_filename=filename)
            plt.close()

    test_score = max_score()
    test_output = 'PASS\n'

    return test_score, test_output

if __name__ == "__main__":
    test()
