import numpy as np
import matplotlib.pyplot as plt
import os

import util

import kernel_regression

def max_score():
    return 2

def timeout():
    return 60

def test():

    figures_directory = 'figures'

    os.makedirs(figures_directory, exist_ok=True)

    expected_output_values = {}

    expected_output_values[(2, (0, 0), (0, 0))] = 1.0000
    expected_output_values[(2, (0, 0), (0, -0.2))] = 1.0000
    expected_output_values[(2, (0, 0), (-0.5, -0.5))] = 1.0000
    expected_output_values[(2, (0, 0), (-0.1, 0.3))] = 1.0000
    expected_output_values[(2, (1, 1), (1, 1))] = 9.0000
    expected_output_values[(2, (1, 1), (1, 0.8))] = 7.8400
    expected_output_values[(2, (1, 1), (0.5, 0.5))] = 4.0000
    expected_output_values[(2, (1, 1), (0.9, 1.3))] = 10.2400
    expected_output_values[(2, (0.2, -0.3), (0.2, -0.3))] = 1.2769
    expected_output_values[(2, (0.2, -0.3), (0.2, -0.5))] = 1.4161
    expected_output_values[(2, (0.2, -0.3), (-0.3, -0.8))] = 1.3924
    expected_output_values[(2, (0.2, -0.3), (0.1, 0.0))] = 1.0404
    expected_output_values[(3, (0, 0), (0, 0))] = 1.0000
    expected_output_values[(3, (0, 0), (0, -0.2))] = 1.0000
    expected_output_values[(3, (0, 0), (-0.5, -0.5))] = 1.0000
    expected_output_values[(3, (0, 0), (-0.1, 0.3))] = 1.0000
    expected_output_values[(3, (1, 1), (1, 1))] = 27.0000
    expected_output_values[(3, (1, 1), (1, 0.8))] = 21.9520
    expected_output_values[(3, (1, 1), (0.5, 0.5))] = 8.0000
    expected_output_values[(3, (1, 1), (0.9, 1.3))] = 32.7680
    expected_output_values[(3, (0.2, -0.3), (0.2, -0.3))] = 1.4429
    expected_output_values[(3, (0.2, -0.3), (0.2, -0.5))] = 1.6852
    expected_output_values[(3, (0.2, -0.3), (-0.3, -0.8))] = 1.6430
    expected_output_values[(3, (0.2, -0.3), (0.1, 0.0))] = 1.0612

    x = np.zeros((2, 1))
    z = np.zeros((2, 1))
    for d in [2, 3]:
        for z_tuple in [(0, 0), (1, 1), (0.2, -0.3)]:
            z[0, 0] = z_tuple[0]
            z[1, 0] = z_tuple[1]

            x_tuples = [ (z_tuple[0] + 0, z_tuple[1] + 0),
                    (z_tuple[0] + 0, z_tuple[1] - 0.2),
                    (z_tuple[0] -0.5, z_tuple[1] - 0.5),
                    (z_tuple[0] -0.1, z_tuple[1] + 0.3) ]

            for x_tuple in x_tuples:
                x[0, 0] = x_tuple[0]
                x[1, 0] = x_tuple[1]

                actual_output = kernel_regression.polynomial_kernel(x, z, d=d)

                if isinstance(actual_output, np.ndarray):
                    if len(actual_output.shape) == 1:
                        actual_output = actual_output[0]
                    else:
                        actual_output = actual_output[0, 0]

                expected_output = expected_output_values[(d, z_tuple, x_tuple)]
                assert abs(actual_output - expected_output) < 0.001 , 'Incorrect kernel value found for d={}, x={}, z={}. Expected {}, found {}'.format(d, x_tuple, z_tuple, expected_output, actual_output)
     
    test_score = max_score()
    test_output = 'PASS\n'

    # Plot surface of kernel at a specific point z

    d=2

    k = lambda X: polynomial_kernel_all(X, z, d)

    filename = '{}/kernel_polynomial_d_{}.png'.format(figures_directory, d)
    title = 'Polynomial kernel, d = {}, z = ({}, {})'.format(d, z[0, 0], z[1, 0])

    point = np.hstack((z.T, np.zeros((1,1))))

    util.plot_surface(k, point, x_min=-10, x_max=10, z_min=-10, z_max=10,
            title=title, new_figure=True, show_figure=False, save_filename=filename)
    plt.close()

    return test_score, test_output

def polynomial_kernel_all(X, z, d):
    N, M = X.shape

    y = np.zeros((N, 1))
    for n in range(N):
        x_n = np.reshape(X[n], (M, 1))
        
        y[n] = kernel_regression.polynomial_kernel(x_n, z, d=d)

    return y

if __name__ == "__main__":
    test()
