#!/bin/bash

export filename_base=hw4

cp ${filename_base}.tex ${filename_base}_sol.tex
sed -i 's/yoursolution/oursolution/' ${filename_base}_sol.tex

cp ${filename_base}.tex ${filename_base}_blank.tex
sed -i 's/\\def \\showSolutions/% \\def \\showSolutions/' ${filename_base}_blank.tex

make

find . -name desktop.ini -type f -delete

# Zip up tex for students
mkdir ${filename_base}_tex
cp ${filename_base}.tex ${filename_base}_tex/
cp class.sty ${filename_base}_tex/
cp yoursolution.tex ${filename_base}_tex/
cp README_student.txt ${filename_base}_tex/README.txt
# Customize based on tex file names
cp q*.tex ${filename_base}_tex/
cp programming.tex ${filename_base}_tex/

# Customize if you have solutions in your figures directory
mkdir ${filename_base}_tex/figures
#cp figures/* ${filename_base}_tex/figures/

zip -r ${filename_base}_tex.zip ${filename_base}_tex

make clean
rm -f ${filename_base}_sol.tex
rm -f ${filename_base}_blank.tex
rm -r ${filename_base}_tex

