let N = 300;
let w = 57;
let row = 0;

//brush
let h = 0;

function setup() {
  createCanvas(windowWidth, windowHeight);
  frameRate(30);
  background(0);
}

function windowResized() {
  resizeCanvas(windowWidth, windowHeight);
  background(0);
}

function draw() {
  if (mouseIsPressed) {
    h = (h + 1) % 100;
    colorMode(HSB, 100);
    blendMode(LIGHTEST);
    for (let i = 0; i < 4; i++) {
      strokeWeight(map(i, 0, 3, 40, 5));
      stroke(h, 100, map(i, 0, 3, 10, 100));
      line(mouseX, mouseY, pmouseX, pmouseY);
    }
  }
  blendMode(BLEND);

  noStroke();
  fill(0);
  rect(0, 0, width, height * 0.2);
  rect(0, 0, width * 0.1, height);
  rect(width * 0.9, 0, width * 0.1, height);
  rect(0, height * 0.9, width, height * 0.1);

  let rowYCoord = map(row, 0, N - 1, height * 0.2, height * 0.9);

  colorMode(RGB, 100);
  noStroke();
  fill(100);
  ellipse(width * 0.05, rowYCoord, 10, 10);

  let colors = [];
  loadPixels();
  let d = pixelDensity();
  let y = floor(rowYCoord);
  for (let i = 0; i < w; i++) {
    let x = floor(map(i, 0, w - 1, width * 0.1, width * 0.9));
    //4 * ((y * d + j) * width * d + (x * d + i));

    let p = 4 * ((y * d) * width * d + (x * d));
    let r = pixels[p];
    let g = pixels[p + 1];
    let b = pixels[p + 2];
    colors.push({
      r: r,
      g: g,
      b: b
    });
  }
  //updatePixels();
  for (let i = 0; i < w; i++) {
    let x = map(i, 0, w - 1, width * 0.1, width * 0.9);
    let c = colors[i];
    noStroke();
    fill(c.r, c.g, c.b);
    rect(x, height * 0.05, width * 0.8 / w, height * 0.1);
  }


  row = (row + 1) % N;
}