/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakLongHashMap<K> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry<K>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private volatile int modCount;
    private static final Object NULL_KEY = new Object();

    public WeakLongHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.table = new Entry[capacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public WeakLongHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakLongHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    private void expungeStaleEntries() {
        Entry e;
        block0: while ((e = (Entry)this.queue.poll()) != null) {
            Entry prev;
            int h = e.hash;
            int i = WeakLongHashMap.indexFor(h, this.table.length);
            Entry p = prev = this.table[i];
            while (p != null) {
                Entry next = p.next;
                if (p == e) {
                    if (prev == e) {
                        this.table[i] = next;
                    } else {
                        prev.next = next;
                    }
                    e.next = null;
                    e.value = 0L;
                    --this.size;
                    continue block0;
                }
                prev = p;
                p = next;
            }
        }
    }

    private Entry<K>[] getTable() {
        return this.table;
    }

    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public long get(Object key) {
        int h = System.identityHashCode(key);
        Entry e = this.table[h & this.table.length - 1];
        while (e != null) {
            if (e.hash == h && key == e.get()) {
                return e.value;
            }
            e = e.next;
        }
        return 0L;
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    Entry<K> getEntry(Object key) {
        Object k = WeakLongHashMap.maskNull(key);
        int h = System.identityHashCode(k);
        Entry<K>[] tab = this.getTable();
        int index = WeakLongHashMap.indexFor(h, tab.length);
        Entry e = tab[index];
        while (e != null && (e.hash != h || k != e.get())) {
            e = e.next;
        }
        return e;
    }

    public long put(K key, long value) {
        Object k = WeakLongHashMap.maskNull(key);
        int h = System.identityHashCode(k);
        Entry<K>[] tab = this.getTable();
        int i = WeakLongHashMap.indexFor(h, tab.length);
        Entry<K> e = tab[i];
        while (e != null) {
            if (h == ((Entry)e).hash && k == e.get()) {
                long oldValue = ((Entry)e).value;
                if (value != oldValue) {
                    ((Entry)e).value = value;
                }
                return oldValue;
            }
            e = ((Entry)e).next;
        }
        ++this.modCount;
        e = tab[i];
        tab[i] = new Entry<Object>(k, value, this.queue, h, e);
        if (++this.size >= this.threshold) {
            this.resize(tab.length * 2);
        }
        return 0L;
    }

    void resize(int newCapacity) {
        Entry<K>[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(oldTable, newTable);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable);
            this.table = oldTable;
        }
    }

    private void transfer(Entry<K>[] src, Entry<K>[] dest) {
        int j = 0;
        while (j < src.length) {
            Entry e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next = e.next;
                Object key = e.get();
                if (key == null) {
                    e.next = null;
                    e.value = 0L;
                    --this.size;
                } else {
                    int i = WeakLongHashMap.indexFor(e.hash, dest.length);
                    e.next = (Entry)dest[i];
                    dest[i] = e;
                }
                e = next;
            }
            ++j;
        }
    }

    public long remove(Object key) {
        Entry prev;
        Object k = WeakLongHashMap.maskNull(key);
        int h = System.identityHashCode(k);
        Entry<K>[] tab = this.getTable();
        int i = WeakLongHashMap.indexFor(h, tab.length);
        Entry e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && k == e.get()) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return 0L;
    }

    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Entry<K>[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K>
    extends WeakReference<K> {
        private long value;
        private final int hash;
        private Entry<K> next;

        Entry(K key, long value, ReferenceQueue<K> queue, int hash, Entry<K> next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        public K getKey() {
            Object key = this.get();
            return key == NULL_KEY ? null : (K)key;
        }

        public long getValue() {
            return this.value;
        }

        public long setValue(long newValue) {
            long oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public boolean equals(Object o) {
            long v2;
            long v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return k1 == (k2 = e.getKey()) && ((v1 = this.getValue()) == (v2 = ((Long)e.getValue()).longValue()) || v1 != 0L && v1 == v2);
        }

        public int hashCode() {
            K k = this.getKey();
            Long v = this.getValue();
            return (k == null ? 0 : System.identityHashCode(k)) ^ (v == null ? 0 : ((Object)v).hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

