/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.util;

import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.util.Saveable;
import gnu.trove.TIntIntHashMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class Util {
    private static final int OUTPUT_STREAM_BUFFER_SIZE = 65536;

    public static void save(Saveable saveable, File file) throws IOException {
        DataOutputStream out = Util.getWriterFor(file);
        saveable.write(out);
        out.close();
    }

    public static void load(Saveable saveable, File file) throws IOException {
        DataInputStream in = Util.getReaderFor(file);
        saveable.read(in);
        in.close();
    }

    public static DataOutputStream getWriterFor(File file) throws FileNotFoundException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 65536));
    }

    public static DataInputStream getReaderFor(File file) throws IOException {
        DataInputStream data;
        if (file.length() > Integer.MAX_VALUE) {
            data = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        } else {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file), 256);
            byte[] bytes = new byte[(int)file.length()];
            ((InputStream)stream).read(bytes, 0, bytes.length);
            ((InputStream)stream).close();
            data = new DataInputStream(new ByteArrayInputStream(bytes));
        }
        return data;
    }

    public static String fillOrTruncateString(String string, int length) {
        if (string.length() > length) {
            string = String.valueOf(string.substring(0, length - 3)) + "...";
        } else if (string.length() < length) {
            int numberOfSpaces = length - string.length();
            int i = 0;
            while (i < numberOfSpaces) {
                string = String.valueOf(string) + " ";
                ++i;
            }
        }
        return string;
    }

    public static String fillString(char c, int length) {
        String s = "";
        int i = 0;
        while (i < length) {
            s = String.valueOf(s) + c;
            ++i;
        }
        return s;
    }

    public static String elide(String string, int limit) {
        if (string == null) {
            return null;
        }
        if (limit <= 0) {
            return string;
        }
        if (string.length() < limit) {
            return string;
        }
        return String.valueOf(string.substring(0, limit - 3)) + "...";
    }

    public static String getSimpleNameFromFullyQualifiedInternalClassName(String classname) {
        int indexOfLast = classname.lastIndexOf("/");
        if (indexOfLast < 0) {
            return classname;
        }
        return classname.substring(indexOfLast + 1);
    }

    public static void drawArrowhead(Graphics2D g, int fromX, int fromY, int toX, int toY) {
        double angle = Math.atan2(fromY - toY, fromX - toX);
        double arrowheadWidth = 8.0;
        int arrowEdgeX = (int)((double)toX + Math.cos(angle) * arrowheadWidth);
        int arrowEdgeY = (int)((double)toY + Math.sin(angle) * arrowheadWidth);
        int arrowClockX = (int)((double)arrowEdgeX + Math.cos(angle + 0.7853981633974483) * arrowheadWidth);
        int arrowClockY = (int)((double)arrowEdgeY + Math.sin(angle + 0.7853981633974483) * arrowheadWidth);
        int arrowCounterX = (int)((double)arrowEdgeX + Math.cos(angle - 0.7853981633974483) * arrowheadWidth);
        int arrowCounterY = (int)((double)arrowEdgeY + Math.sin(angle - 0.7853981633974483) * arrowheadWidth);
        Polygon arrowhead = new Polygon();
        arrowhead.addPoint(arrowClockX, arrowClockY);
        arrowhead.addPoint(arrowCounterX, arrowCounterY);
        arrowhead.addPoint(toX, toY);
        g.fill(arrowhead);
    }

    public static Polygon getArrowhead(int fromX, int fromY, int toX, int toY, int controlXOffset, int controlYOffset) {
        int controlX = (toX + fromX) / 2 + controlXOffset;
        int controlY = (toY + fromY) / 2 + controlYOffset;
        double angle = Math.atan2(controlY - toY, controlX - toX);
        double arrowheadWidth = 8.0;
        int arrowEdgeX = (int)((double)toX + Math.cos(angle) * arrowheadWidth);
        int arrowEdgeY = (int)((double)toY + Math.sin(angle) * arrowheadWidth);
        int arrowClockX = (int)((double)arrowEdgeX + Math.cos(angle + 0.7853981633974483) * arrowheadWidth);
        int arrowClockY = (int)((double)arrowEdgeY + Math.sin(angle + 0.7853981633974483) * arrowheadWidth);
        int arrowCounterX = (int)((double)arrowEdgeX + Math.cos(angle - 0.7853981633974483) * arrowheadWidth);
        int arrowCounterY = (int)((double)arrowEdgeY + Math.sin(angle - 0.7853981633974483) * arrowheadWidth);
        Polygon arrowhead = new Polygon();
        arrowhead.addPoint(arrowClockX, arrowClockY);
        arrowhead.addPoint(arrowCounterX, arrowCounterY);
        arrowhead.addPoint(toX, toY);
        return arrowhead;
    }

    public static QuadCurve2D getCurve(int fromX, int fromY, int toX, int toY, int controlXOffset, int controlYOffset, boolean drawArrowhead) {
        int controlX = (toX + fromX) / 2 + controlXOffset;
        int controlY = (toY + fromY) / 2 + controlYOffset;
        double angle = Math.atan2(controlY - toY, controlX - toX);
        double arrowheadWidth = 8.0;
        int arrowEdgeX = (int)((double)toX + Math.cos(angle) * arrowheadWidth);
        int arrowEdgeY = (int)((double)toY + Math.sin(angle) * arrowheadWidth);
        int arrowClockX = (int)((double)arrowEdgeX + Math.cos(angle + 0.7853981633974483) * arrowheadWidth);
        int arrowClockY = (int)((double)arrowEdgeY + Math.sin(angle + 0.7853981633974483) * arrowheadWidth);
        int arrowCounterX = (int)((double)arrowEdgeX + Math.cos(angle - 0.7853981633974483) * arrowheadWidth);
        int arrowCounterY = (int)((double)arrowEdgeY + Math.sin(angle - 0.7853981633974483) * arrowheadWidth);
        Polygon arrowhead = new Polygon();
        arrowhead.addPoint(arrowClockX, arrowClockY);
        arrowhead.addPoint(arrowCounterX, arrowCounterY);
        arrowhead.addPoint(toX, toY);
        toX = arrowEdgeX;
        toY = arrowEdgeY;
        QuadCurve2D.Float curve = new QuadCurve2D.Float(fromX, fromY, controlX, controlY, toX, toY);
        return curve;
    }

    public static void drawQuadraticCurveArrow(Graphics2D g, int fromX, int fromY, int toX, int toY, int controlXOffset, int controlYOffset, boolean drawArrowhead, Stroke neck) {
        int controlX = (toX + fromX) / 2 + controlXOffset;
        int controlY = (toY + fromY) / 2 + controlYOffset;
        double angle = Math.atan2(controlY - toY, controlX - toX);
        double arrowheadWidth = 8.0;
        int arrowEdgeX = (int)((double)toX + Math.cos(angle) * arrowheadWidth);
        int arrowEdgeY = (int)((double)toY + Math.sin(angle) * arrowheadWidth);
        int arrowClockX = (int)((double)arrowEdgeX + Math.cos(angle + 0.7853981633974483) * arrowheadWidth);
        int arrowClockY = (int)((double)arrowEdgeY + Math.sin(angle + 0.7853981633974483) * arrowheadWidth);
        int arrowCounterX = (int)((double)arrowEdgeX + Math.cos(angle - 0.7853981633974483) * arrowheadWidth);
        int arrowCounterY = (int)((double)arrowEdgeY + Math.sin(angle - 0.7853981633974483) * arrowheadWidth);
        Polygon arrowhead = new Polygon();
        arrowhead.addPoint(arrowClockX, arrowClockY);
        arrowhead.addPoint(arrowCounterX, arrowCounterY);
        arrowhead.addPoint(toX, toY);
        toX = arrowEdgeX;
        toY = arrowEdgeY;
        g.setStroke(neck);
        QuadCurve2D.Float curve = new QuadCurve2D.Float(fromX, fromY, controlX, controlY, toX, toY);
        g.draw(curve);
        if (!drawArrowhead) {
            return;
        }
        g.fill(arrowhead);
    }

    public static void drawCrosshatch(Graphics2D g, Color color, int left, int right, int top, int height, int spacing, int verticalOffset) {
        g = (Graphics2D)g.create();
        g.clipRect(left + 1, top + 1, right - left - 1, height - 1);
        g.setColor(color);
        int x = left - height + 1 - verticalOffset;
        int bottom = top + height;
        int count = 0;
        while (x < right) {
            g.drawLine(x, bottom - 1, x + height, top + 1);
            x += spacing;
            ++count;
        }
    }

    public static void deleteFolder(File folder) throws IOException {
        if (!folder.exists()) {
            throw new IOException(folder + " doesn't exist.");
        }
        if (!folder.isDirectory()) {
            throw new IOException(folder + " is not a folder.");
        }
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileOrFolder = fileArray[n2];
            if (fileOrFolder.isDirectory()) {
                Util.deleteFolder(fileOrFolder);
                fileOrFolder.delete();
            } else {
                fileOrFolder.delete();
            }
            ++n2;
        }
        folder.delete();
    }

    public static void copyFile(File source, File dest) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (!dest.exists()) {
            dest.getParentFile().mkdirs();
            dest.createNewFile();
        }
        FileChannel srcChannel = new FileInputStream(source).getChannel();
        FileChannel dstChannel = new FileOutputStream(dest).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
    }

    public static long getSizeOfFolder(File folder) {
        File[] files;
        if (!folder.exists() || !folder.isDirectory()) {
            throw new RuntimeException(folder + " does not exist or is not a folder");
        }
        long size = 0L;
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File fileOrFolder = fileArray[n2];
            if (fileOrFolder.isFile()) {
                size += fileOrFolder.length();
            } else if (fileOrFolder.isDirectory()) {
                size += Util.getSizeOfFolder(fileOrFolder);
            }
            ++n2;
        }
        return size;
    }

    public static void copyFolder(File source, File dest, ProgressListener progressListener) throws IOException {
        long size = Util.getSizeOfFolder(source);
        Util.copyFolder(source, dest, progressListener, size, 0L);
    }

    private static long copyFolder(File source, File dest, ProgressListener progressListener, long size, long copied) throws IOException {
        File[] files;
        if (!source.isDirectory() || !source.exists()) {
            throw new RuntimeException(source + " is not a folder");
        }
        if (!dest.isDirectory() || !dest.exists()) {
            throw new RuntimeException(dest + " is not a folder");
        }
        File[] fileArray = files = source.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File fileOrFolder = fileArray[n2];
            if (progressListener != null) {
                progressListener.notice("Copying " + fileOrFolder.getName());
            }
            if (fileOrFolder.isFile()) {
                Util.copyFile(fileOrFolder, new File(dest, fileOrFolder.getName()));
                progressListener.progress((double)(copied += fileOrFolder.length()) / (double)size);
            } else if (fileOrFolder.isDirectory()) {
                File newFolder = new File(dest, fileOrFolder.getName());
                newFolder.mkdir();
                copied = Util.copyFolder(fileOrFolder, newFolder, progressListener, size, copied);
            }
            ++n2;
        }
        return copied;
    }

    public static int getFolderSizeInBytes(File folder) {
        int size = 0;
        if (!folder.isDirectory() || !folder.exists()) {
            throw new RuntimeException(folder + " is not a folder.");
        }
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileOrFolder = fileArray[n2];
            size = fileOrFolder.isDirectory() ? (size += Util.getFolderSizeInBytes(fileOrFolder)) : (int)((long)size + fileOrFolder.length());
            ++n2;
        }
        return size;
    }

    public static String getDateString() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("EST"));
        int day = calendar.get(7);
        String dayString = Util.getDayOfWeekString(day);
        int month = calendar.get(2);
        String monthString = Util.getMonthString(month);
        int date = calendar.get(5);
        int year = calendar.get(1);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        String dateString = (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + " " + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + " " + (second < 10 ? "0" + second : Integer.valueOf(second)) + " " + "EST " + dayString + " " + monthString + " " + date + " " + year;
        return dateString;
    }

    public static String getDayOfWeekString(int dayOfWeek) {
        switch (dayOfWeek) {
            case 1: {
                return "Sunday";
            }
            case 2: {
                return "Monday";
            }
            case 3: {
                return "Tuesday";
            }
            case 4: {
                return "Wednesday";
            }
            case 5: {
                return "Thursday";
            }
            case 6: {
                return "Friday";
            }
            case 7: {
                return "Saturday";
            }
        }
        return "invalid day of week";
    }

    public static String getMonthString(int month) {
        switch (month) {
            case 0: {
                return "January";
            }
            case 1: {
                return "February";
            }
            case 2: {
                return "March";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "June";
            }
            case 6: {
                return "July";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "October";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "December";
            }
        }
        return "invalid month";
    }

    public static void drawCallout(Graphics2D g, ImageIcon icon, String label, int x, int y) {
        g = (Graphics2D)g.create();
        g.setStroke(new BasicStroke(1.0f));
        g.setFont(UI.getSmallFont());
        Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(label, g);
        int padding = 3;
        int iconWidth = icon == null ? 0 : icon.getIconWidth();
        int iconHeight = icon == null ? 0 : icon.getIconHeight();
        int maxContentHeight = (int)Math.max((double)iconHeight, stringBounds.getHeight());
        int calloutHeight = maxContentHeight + padding * 2 - 1;
        int calloutWidth = (int)((double)iconWidth + stringBounds.getWidth() + (double)(padding * 3));
        int iconX = x + (icon == null ? 0 : padding);
        int iconY = y + padding;
        int stringX = iconX + iconWidth + padding;
        int stringBaseline = y + (calloutHeight - padding - (calloutHeight - g.getFontMetrics().getHeight()) / 2);
        g.setColor(UI.getPanelDarkColor());
        g.fillRoundRect(x, y, calloutWidth, calloutHeight, UI.getRoundedness(), UI.getRoundedness());
        g.setColor(UI.getControlBorderColor());
        g.drawRoundRect(x, y, calloutWidth, calloutHeight, UI.getRoundedness(), UI.getRoundedness());
        if (icon != null) {
            icon.paintIcon(null, g, iconX, iconY);
        }
        g.setColor(UI.getPanelTextColor());
        g.drawString(label, stringX, stringBaseline);
    }

    public static Rectangle2D getStringBounds(Graphics2D g, Font font, String s) {
        return g.getFontMetrics(font).getStringBounds(s, g);
    }

    public static int findStringSplitIndex(String s) {
        int middle;
        int left = middle = s.length() / 2;
        int right = middle;
        while (left >= 0) {
            if (s.charAt(left) == ' ') break;
            --left;
        }
        while (right < s.length()) {
            if (s.charAt(right) == ' ') break;
            ++right;
        }
        return right - middle < middle - left ? right : left;
    }

    public static Point2D getIntersectionOfSegmentAndBox(double centerX, double centerY, double x1, double y1, double x2, double y2, double outsideX, double outsideY) {
        Line centerOutside = new Line(centerX, centerY, outsideX, outsideY);
        Line leftEdge = new Line(x1, y1, x1, y2);
        Line topEdge = new Line(x1, y1, x2, y1);
        Line rightEdge = new Line(x2, y1, x2, y2);
        Line bottomEdge = new Line(x1, y2, x2, y2);
        Point2D left = leftEdge.getIntersectionOnSegment(centerOutside);
        Point2D top = topEdge.getIntersectionOnSegment(centerOutside);
        Point2D right = rightEdge.getIntersectionOnSegment(centerOutside);
        Point2D bottom = bottomEdge.getIntersectionOnSegment(centerOutside);
        double leftDistance = left == null ? Double.MAX_VALUE : Util.distance(left.getX(), left.getY(), outsideX, outsideY);
        double topDistance = top == null ? Double.MAX_VALUE : Util.distance(top.getX(), top.getY(), outsideX, outsideY);
        double rightDistance = right == null ? Double.MAX_VALUE : Util.distance(right.getX(), right.getY(), outsideX, outsideY);
        double bottomDistance = bottom == null ? Double.MAX_VALUE : Util.distance(bottom.getX(), bottom.getY(), outsideX, outsideY);
        double shortestDistance = Math.min(Math.min(Math.min(leftDistance, topDistance), rightDistance), bottomDistance);
        Point2D shortest = shortestDistance == leftDistance ? left : (shortestDistance == topDistance ? top : (shortestDistance == rightDistance ? right : bottom));
        return shortest;
    }

    public static Line2D getLineBetweenRectangleEdges(double left1, double right1, double top1, double bottom1, double left2, double right2, double top2, double bottom2) {
        double centerX1 = (left1 + right1) / 2.0;
        double centerY1 = (top1 + bottom1) / 2.0;
        double centerX2 = (left2 + right2) / 2.0;
        double centerY2 = (top2 + bottom2) / 2.0;
        Point2D one = Util.getIntersectionOfSegmentAndBox(centerX1, centerY1, left1, top1, right1, bottom1, centerX2, centerY2);
        Point2D two = Util.getIntersectionOfSegmentAndBox(centerX2, centerY2, left2, top2, right2, bottom2, centerX1, centerY1);
        return new Line2D.Double(one == null ? new Point2D.Double(centerX1, centerY1) : one, two == null ? new Point2D.Double(centerX2, centerY2) : two);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static String integerToASCII(int number) {
        char[] ascii = new char[]{(char)(((number & 0xF0000000) >>> 28) + 97), (char)(((number & 0xF000000) >>> 24) + 97), (char)(((number & 0xF00000) >>> 20) + 97), (char)(((number & 0xF0000) >>> 16) + 97), (char)(((number & 0xF000) >>> 12) + 97), (char)(((number & 0xF00) >>> 8) + 97), (char)(((number & 0xF0) >>> 4) + 97), (char)(((number & 0xF) >>> 0) + 97)};
        int i = 0;
        while (i < 8) {
            System.err.println(ascii[i] - 97);
            ++i;
        }
        return new String(ascii);
    }

    public static int ASCIIToInteger(String ascii) {
        long number = ascii.charAt(0) - 97 << 28 | ascii.charAt(1) - 97 << 24 | ascii.charAt(2) - 97 << 20 | ascii.charAt(3) - 97 << 16 | ascii.charAt(4) - 97 << 12 | ascii.charAt(5) - 97 << 8 | ascii.charAt(6) - 97 << 4 | ascii.charAt(7) - 97;
        return (int)number;
    }

    public static String commas(long value) {
        return NumberFormat.getNumberInstance().format(value);
    }

    public static void writeIntIntMap(DataOutputStream stream, TIntIntHashMap map) throws IOException {
        stream.writeInt(map.size());
        int[] nArray = map.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int key = nArray[n2];
            stream.writeInt(key);
            stream.writeInt(map.get(key));
            ++n2;
        }
    }

    public static void readIntIntMap(DataInputStream stream, TIntIntHashMap map) throws IOException {
        int size = stream.readInt();
        map.ensureCapacity(size);
        int i = 0;
        while (i < size) {
            map.put(stream.readInt(), stream.readInt());
            ++i;
        }
    }

    public static String format(Object value, boolean html) {
        String valueString = "" + value;
        if (value instanceof Color) {
            Color color = (Color)value;
            String red = Integer.toHexString(color.getRed());
            if (color.getRed() < 10) {
                red = "0" + red;
            }
            String green = Integer.toHexString(color.getGreen());
            if (color.getGreen() < 10) {
                green = "0" + green;
            }
            String blue = Integer.toHexString(color.getBlue());
            if (color.getBlue() < 10) {
                blue = "0" + blue;
            }
            valueString = html ? "<font color=#" + red + green + blue + ">&#9608</font>" : "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        } else if (value instanceof String) {
            valueString = "\"" + valueString + "\"";
        } else {
            if (value instanceof Font) {
                Font fontface = (Font)value;
                return String.valueOf(fontface.getFamily()) + " " + fontface.getSize() + " pt";
            }
            if (value instanceof Rectangle) {
                Rectangle rect = (Rectangle)value;
                valueString = "[(" + rect.getX() + ", " + rect.getY() + "), (" + rect.getWidth() + ", " + rect.getHeight() + ")]";
            } else if (value instanceof BasicStroke) {
                BasicStroke stroke = (BasicStroke)value;
                valueString = String.valueOf(stroke.getLineWidth()) + " pixel stroke";
            }
        }
        return valueString;
    }

    public static void openURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                int count = 0;
                while (count < browsers.length && browser == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                        browser = browsers[count];
                    }
                    ++count;
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Couldn't open " + url + " in your browser." + ":\n" + e.getLocalizedMessage());
        }
    }

    private static class Line {
        public final double x1;
        public final double y1;
        public final double x2;
        public final double y2;
        public final double slope;
        public final double intercept;

        public Line(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.slope = (y2 - y1) / (x2 - x1);
            this.intercept = y1 - this.slope * x1;
        }

        public Point2D getIntersectionOnSegment(Line line) {
            if (this.slope == line.slope) {
                return null;
            }
            if (Double.isInfinite(this.slope) || Double.isNaN(this.slope)) {
                double x = this.x1;
                double y = this.x1 * line.slope + line.intercept;
                if ((this.y1 - y) * (y - this.y2) >= 0.0) {
                    return new Point2D.Double(x, y);
                }
                return null;
            }
            if (Double.isInfinite(line.slope) || Double.isNaN(line.slope)) {
                double x = line.x1;
                double y = line.x1 * this.slope + this.intercept;
                if ((line.y1 - y) * (y - line.y2) >= 0.0) {
                    return new Point2D.Double(x, y);
                }
                return null;
            }
            double x = -(this.intercept - line.intercept) / (this.slope - line.slope);
            double y = this.intercept + this.slope * x;
            if ((this.x1 - x) * (x - this.x2) >= 0.0) {
                return new Point2D.Double(x, y);
            }
            return null;
        }
    }

    public static interface ProgressListener {
        public void progress(double var1);

        public void notice(String var1);
    }
}

