/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.views;

import edu.cmu.hcii.whyline.ui.views.ViewContainer;
import edu.cmu.hcii.whyline.ui.views.VisibleProperty;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View {
    private boolean notifyContainerOfSizeChanges = false;
    private double preferredWidth;
    private double preferredHeight;
    private final VisibleProperty left = new VisibleProperty(0.0);
    private final VisibleProperty top = new VisibleProperty(0.0);
    private final VisibleProperty width = new VisibleProperty(0.0);
    private final VisibleProperty height = new VisibleProperty(0.0);
    private final VisibleProperty percentToScaleChildren = new VisibleProperty(1.0);
    private final VisibleProperty percentToFadeChildren = new VisibleProperty(1.0);
    private AffineTransform localTransform;
    private AffineTransform visibleTransform;
    private boolean clipsChildren = false;
    private ViewContainer container = null;
    private View parent;
    private final ArrayList<View> children = new ArrayList(0);
    private static Vector<AnimationInfo> animationInfo = new Vector();
    private static final Timer animationTimer = new Timer(true);
    private static ArrayList<ViewContainer> roots;

    static {
        animationTimer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Vector vector = animationInfo;
                synchronized (vector) {
                    if (animationInfo.size() > 0) {
                        Iterator infoIterator = animationInfo.iterator();
                        while (infoIterator.hasNext()) {
                            AnimationInfo info = (AnimationInfo)infoIterator.next();
                            if (!info.update()) continue;
                            infoIterator.remove();
                        }
                    }
                }
            }
        }, 0L, 30L);
        roots = new ArrayList();
    }

    public static void addRoot(ViewContainer c) {
        roots.add(c);
    }

    public static void removeRoot(ViewContainer c) {
        roots.remove(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate(int duration, boolean alsoAnimateChildren) {
        Vector<AnimationInfo> vector = animationInfo;
        synchronized (vector) {
            animationInfo.add(new AnimationInfo(this, duration, alsoAnimateChildren));
            this.repaint();
        }
    }

    public View(int left, int top, int width, int height) {
        this.visibleTransform = new AffineTransform();
        this.localTransform = new AffineTransform();
        this.left.set(left);
        this.top.set(top);
        this.width.set(width);
        this.height.set(height);
    }

    public View() {
        this(0, 0, 5, 5);
    }

    public final double getLocalLeft() {
        return this.left.get();
    }

    public final double getVisibleLocalLeft() {
        return this.left.getVisible();
    }

    public final double getGlobalLeft() {
        if (this.getParent() == null) {
            return this.getLocalLeft();
        }
        return (int)this.getParent().localToGlobal(new Point2D.Double(this.getLocalLeft(), this.getLocalTop())).getX();
    }

    public final double getVisibleGlobalLeft() {
        if (this.getParent() == null) {
            return this.getVisibleLocalLeft();
        }
        return (int)this.getParent().localToGlobal(new Point2D.Double(this.getVisibleLocalLeft(), this.getVisibleLocalTop())).getX();
    }

    public final double getLocalRight() {
        return (int)(this.left.get() + this.getLocalWidth());
    }

    public final double getVisibleLocalRight() {
        return (int)(this.left.getVisible() + this.getVisibleLocalWidth());
    }

    public final double getGlobalRight() {
        if (this.getParent() == null) {
            return this.getLocalRight();
        }
        return (int)this.getParent().localToGlobal(new Point2D.Double(this.getLocalRight(), this.getLocalBottom())).getX();
    }

    public final double getVisibleGlobalRight() {
        if (this.getParent() == null) {
            return this.getVisibleLocalRight();
        }
        return (int)this.getParent().localToGlobal(new Point2D.Double(this.getVisibleLocalRight(), this.getVisibleLocalBottom())).getX();
    }

    public final double getLocalTop() {
        return (int)this.top.get();
    }

    public final double getLocalHorizontalCenter() {
        return this.getLocalLeft() + this.getLocalWidth() / 2.0;
    }

    public final double getLocalVerticalCenter() {
        return this.getLocalTop() + this.getLocalHeight() / 2.0;
    }

    public final double getVisibleLocalTop() {
        return (int)this.top.getVisible();
    }

    public final double getGlobalTop() {
        if (this.getParent() == null) {
            return this.getLocalTop();
        }
        return (int)this.getParent().localToGlobal(new Point2D.Double(this.getLocalLeft(), this.getLocalTop())).getY();
    }

    public final double getVisibleGlobalTop() {
        if (this.getParent() == null) {
            return this.getVisibleLocalTop();
        }
        return (int)this.getParent().localToGlobal(new Point2D.Double(this.getVisibleLocalLeft(), this.getVisibleLocalTop())).getY();
    }

    public final double getLocalBottom() {
        return (int)(this.top.get() + this.getLocalHeight());
    }

    public final double getVisibleLocalBottom() {
        return (int)(this.top.getVisible() + this.getVisibleLocalHeight());
    }

    public final double getGlobalBottom() {
        if (this.getParent() == null) {
            return this.getLocalBottom();
        }
        return (int)this.getParent().localToGlobal(new Point2D.Double(this.getLocalRight(), this.getLocalBottom())).getY();
    }

    public final double getVisibleGlobalBottom() {
        if (this.getParent() == null) {
            return this.getVisibleLocalBottom();
        }
        return (int)this.getParent().localToGlobal(new Point2D.Double(this.getVisibleLocalRight(), this.getVisibleLocalBottom())).getY();
    }

    public final double getLocalWidth() {
        return (int)this.width.get();
    }

    public final double getVisibleLocalWidth() {
        return (int)this.width.getVisible();
    }

    public final double getGlobalWidth() {
        return this.getGlobalRight() - this.getGlobalLeft();
    }

    public final double getVisibleGlobalWidth() {
        return this.getVisibleGlobalRight() - this.getVisibleGlobalLeft();
    }

    public final double getLocalHeight() {
        return (int)this.height.get();
    }

    public final double getVisibleLocalHeight() {
        return (int)this.height.getVisible();
    }

    public final double getGlobalHeight() {
        return this.getGlobalBottom() - this.getGlobalTop();
    }

    public final double getVisibleGlobalHeight() {
        return this.getVisibleGlobalBottom() - this.getVisibleGlobalTop();
    }

    public final double getPercentToScaleChildren() {
        return this.percentToScaleChildren.get();
    }

    public final double getVisiblePercentToScaleChildren() {
        return this.percentToScaleChildren.getVisible();
    }

    public final double getPercentToFadeChildren() {
        return this.percentToFadeChildren.get();
    }

    public final double getVisiblePercentToFadeChildren() {
        return this.percentToFadeChildren.getVisible();
    }

    public final View getParent() {
        return this.parent;
    }

    private final void setParent(View parent) {
        this.parent = parent;
        this.container = parent == null ? null : parent.container;
    }

    public final synchronized View getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public final int getDepth() {
        return this.parent == null ? 0 : 1 + this.parent.getDepth();
    }

    public final ViewContainer getContainer() {
        if (this.container == null) {
            View root = this.getRoot();
            for (ViewContainer container : roots) {
                if (container.getView() != root) continue;
                this.container = container;
            }
        }
        return this.container;
    }

    public final boolean clippingBoundariesContain(double localX, double localY) {
        return localX >= this.getLocalLeft() && localY >= this.getLocalTop() && localX < this.getLocalRight() + 1.0 && localY < this.getLocalBottom() + 1.0;
    }

    public final Rectangle getLocalBoundaries() {
        return new Rectangle((int)this.getLocalLeft(), (int)this.getLocalTop(), (int)this.getLocalWidth(), (int)this.getLocalHeight());
    }

    public final Rectangle getGlobalBoundaries() {
        return new Rectangle((int)this.getGlobalLeft(), (int)this.getGlobalTop(), (int)this.getGlobalWidth(), (int)this.getGlobalHeight());
    }

    public final Rectangle getVisibleGlobalBoundaries() {
        return new Rectangle((int)this.getVisibleGlobalLeft(), (int)this.getVisibleGlobalTop(), (int)this.getVisibleGlobalWidth(), (int)this.getVisibleGlobalHeight());
    }

    public final Rectangle2D getBoundariesRelativeTo(View view) {
        Point2D topLeft = new Point2D.Double(this.getGlobalLeft(), this.getGlobalTop());
        Point2D bottomRight = new Point2D.Double(this.getGlobalRight(), this.getGlobalBottom());
        if (view.getParent() != null) {
            topLeft = view.getParent().globalToLocal(topLeft);
            bottomRight = view.getParent().globalToLocal(bottomRight);
        }
        return new Rectangle2D.Double(topLeft.getX(), topLeft.getY(), bottomRight.getX() - topLeft.getX(), bottomRight.getY() - topLeft.getY());
    }

    public final Rectangle2D getVisibleBoundariesRelativeTo(View view) {
        Point2D topLeft = new Point2D.Double(this.getVisibleGlobalLeft(), this.getVisibleGlobalTop());
        Point2D bottomRight = new Point2D.Double(this.getVisibleGlobalRight(), this.getVisibleGlobalBottom());
        if (view.getParent() != null) {
            topLeft = view.getParent().globalToLocal(topLeft);
            bottomRight = view.getParent().globalToLocal(bottomRight);
        }
        return new Rectangle2D.Double(topLeft.getX(), topLeft.getY(), bottomRight.getX() - topLeft.getX(), bottomRight.getY() - topLeft.getY());
    }

    public final void addChild(View view) {
        assert (view.getParent() == null) : view + " is already a child of " + view.getParent();
        this.children.add(view);
        view.setParent(this);
    }

    public final void addChildBeforeChildAtIndex(View view, int index) {
        assert (view.getParent() == null) : "Can't add child that's already added.";
        this.children.add(index, view);
        view.setParent(this);
    }

    public final void bringToFront() {
        if (this.parent == null) {
            return;
        }
        View temp = this.parent;
        temp.removeChild(this);
        temp.addChild(this);
        this.repaint();
    }

    public final void sendToBack() {
        if (this.parent == null) {
            return;
        }
        this.parent.children.remove(this);
        this.parent.children.add(0, this);
        this.repaint();
    }

    public final boolean hasChild(View view) {
        return this.children.contains(view);
    }

    public final View getChildAtIndex(int index) {
        if (index < 0 || index >= this.children.size()) {
            return null;
        }
        return this.children.get(index);
    }

    public final View getChildBefore() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getChildAtIndex(this.parent.children.indexOf(this) - 1);
    }

    public final View getChildAfter() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getChildAtIndex(this.parent.children.indexOf(this) + 1);
    }

    public final View getFirstChild() {
        return this.children.isEmpty() ? null : this.children.get(0);
    }

    public final View getLastChild() {
        return this.children.isEmpty() ? null : this.children.get(this.children.size() - 1);
    }

    public final Iterable<View> getChildren() {
        return this.children;
    }

    public final int getNumberOfChildren() {
        return this.children.size();
    }

    public final void removeChild(View child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
            child.setParent(null);
        }
    }

    public final void removeChildren() {
        while (this.children.size() > 0) {
            this.removeChild(this.getFirstChild());
        }
    }

    public void trim() {
        this.children.trimToSize();
    }

    public final void setLocalLeft(double newLeft, boolean animate) {
        if (animate) {
            this.left.animate(newLeft);
        } else {
            this.left.set(newLeft);
        }
        this.invalidateTransform();
    }

    public final void setLocalTop(double newTop, boolean animate) {
        if (animate) {
            this.top.animate(newTop);
        } else {
            this.top.set(newTop);
        }
        this.invalidateTransform();
    }

    public final void setLocalWidth(double newWidth, boolean animate) {
        boolean changed;
        boolean bl = changed = animate ? this.width.animate(newWidth) : this.width.set(newWidth);
        if (changed) {
            this.invalidateTransform();
            this.notifyContainerOfSizeChange();
        }
    }

    public final void setLocalHeight(double newHeight, boolean animate) {
        boolean changed;
        boolean bl = changed = animate ? this.height.animate(newHeight) : this.height.set(newHeight);
        if (changed) {
            this.invalidateTransform();
            this.notifyContainerOfSizeChange();
        }
    }

    public final void setPercentToScaleChildren(double newScale) {
        if (newScale == 0.0) {
            newScale = 0.01;
        }
        this.percentToScaleChildren.set(newScale);
        this.invalidateTransform();
    }

    public void setNotifyContainerOfSizeChanges(boolean yes) {
        this.notifyContainerOfSizeChanges = yes;
    }

    private void notifyContainerOfSizeChange() {
        ViewContainer container;
        if (this.notifyContainerOfSizeChanges && this.parent == null && (container = this.getContainer()) != null) {
            container.rootViewChangedSize();
        }
    }

    public final void setPreferredSize(double width, double height) {
        this.preferredWidth = width;
        this.preferredHeight = height;
        this.notifyContainerOfSizeChange();
    }

    public final double getPreferredWidth() {
        return this.preferredWidth;
    }

    public final double getPreferredHeight() {
        return this.preferredHeight;
    }

    public final void animatePercentToScaleChildren(double newScale) {
        if (newScale == 0.0) {
            newScale = 0.01;
        }
        this.percentToScaleChildren.animate(newScale);
        this.invalidateTransform();
    }

    public final void setPercentToFadeChildren(double newTransparency) {
        this.percentToFadeChildren.set(newTransparency);
    }

    private void invalidateTransform() {
        if (!this.localTransform.isIdentity()) {
            this.localTransform.setToIdentity();
        }
    }

    public AffineTransform getInverseOfLocalTransform() {
        try {
            return this.getLocalTransform().createInverse();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    private AffineTransform getLocalTransform() {
        if (this.localTransform.isIdentity()) {
            this.localTransform.translate(this.getLocalLeft(), this.getLocalTop());
            double visibleScale = this.percentToScaleChildren.get();
            if (visibleScale != 1.0) {
                this.localTransform.scale(visibleScale, visibleScale);
            }
        }
        return this.localTransform;
    }

    public final Point2D localToGlobal(Point2D point) {
        this.getLocalTransform().transform(point, point);
        if (this.parent == null) {
            return point;
        }
        return this.parent.localToGlobal(point);
    }

    public final Point2D globalToLocal(Point2D point) {
        if (this.parent == null) {
            this.getInverseOfLocalTransform().transform(point, point);
            return point;
        }
        this.parent.globalToLocal(point);
        this.getInverseOfLocalTransform().transform(point, point);
        return point;
    }

    public final Point2D localToLocal(View view, Point2D point) {
        return this.getParent().globalToLocal(view.getParent().localToGlobal(point));
    }

    public final double globalLeftToLocal(double left) {
        return this.globalToLocal(new Point2D.Double(left, 0.0)).getX();
    }

    public final double globalTopToLocal(double top) {
        return this.globalToLocal(new Point2D.Double(0.0, top)).getY();
    }

    public void setClipsChildren(boolean clipsChildren) {
        this.clipsChildren = clipsChildren;
        this.repaint();
    }

    public boolean clipsChildren() {
        return this.clipsChildren;
    }

    public final void paint(Graphics2D g) {
        Graphics2D og = (Graphics2D)g.create();
        AlphaComposite oldComposite = (AlphaComposite)g.getComposite();
        og.setComposite(AlphaComposite.getInstance(3, (float)this.getVisiblePercentToFadeChildren() * oldComposite.getAlpha()));
        if (this.clipsChildren) {
            og.clipRect((int)this.getVisibleLocalLeft(), (int)this.getVisibleLocalTop(), (int)this.getVisibleLocalWidth() + 2, (int)this.getVisibleLocalHeight() + 2);
        }
        og.translate(this.getVisibleLocalLeft(), this.getVisibleLocalTop());
        double visibleScale = this.percentToScaleChildren.getVisible();
        if (visibleScale != 1.0) {
            og.scale(visibleScale, visibleScale);
        }
        this.paintChildren(og);
    }

    public void paintChildren(Graphics2D g) {
        Rectangle clip = g.getClipBounds();
        for (View view : this.children) {
            if (!clip.intersects((int)view.getLocalLeft(), (int)view.getLocalTop(), (int)view.getLocalWidth(), (int)view.getLocalHeight())) continue;
            view.paintBelowChildren(g);
            view.paint(g);
            view.paintAboveChildren(g);
        }
    }

    public void paintBelowChildren(Graphics2D g) {
    }

    public void paintAboveChildren(Graphics2D g) {
    }

    public void drawBoundaries(Color color, Graphics2D g) {
        g.setColor(color);
        int left = (int)this.getVisibleLocalLeft();
        int top = (int)this.getVisibleLocalTop();
        int width = (int)this.getVisibleLocalWidth();
        int height = (int)this.getVisibleLocalHeight();
        g.drawRect(left, top, width - 1, height - 1);
    }

    public void fillBoundaries(Color color, Graphics2D g) {
        g.setColor(color);
        int left = (int)this.getVisibleLocalLeft();
        int top = (int)this.getVisibleLocalTop();
        int width = (int)this.getVisibleLocalWidth();
        int height = (int)this.getVisibleLocalHeight();
        g.fillRect(left, top, width + 1, height + 1);
    }

    public void drawRoundBoundaries(Color color, Graphics2D g, int roundWidth, int roundHeight) {
        g.setColor(color);
        int left = (int)this.getVisibleLocalLeft();
        int top = (int)this.getVisibleLocalTop();
        int width = (int)this.getVisibleLocalWidth();
        int height = (int)this.getVisibleLocalHeight();
        g.drawRoundRect(left, top, width, height, roundWidth, roundHeight);
    }

    public void fillRoundBoundaries(Color color, Graphics2D g, int roundWidth, int roundHeight) {
        g.setColor(color);
        int left = (int)this.getVisibleLocalLeft();
        int top = (int)this.getVisibleLocalTop();
        int width = (int)this.getVisibleLocalWidth();
        int height = (int)this.getVisibleLocalHeight();
        g.fillRoundRect(left, top, width, height, roundWidth, roundHeight);
    }

    private void animatePositions(double percentComplete, boolean animateChildren) {
        this.left.update(percentComplete);
        this.top.update(percentComplete);
        this.width.update(percentComplete);
        this.height.update(percentComplete);
        this.top.update(percentComplete);
        this.percentToScaleChildren.update(percentComplete);
        this.percentToFadeChildren.update(percentComplete);
        this.invalidateTransform();
        if (animateChildren) {
            int i = 0;
            while (i < this.children.size()) {
                this.children.get(i).animatePositions(percentComplete, animateChildren);
                ++i;
            }
        }
    }

    public void handleContainerResize() {
    }

    public boolean handleMouseMove(int localX, int localY) {
        return false;
    }

    public boolean handleMouseDrag(int localX, int localY, int mouseButton) {
        return false;
    }

    public boolean handleMouseClick(int localX, int localY, int mouseButton) {
        return false;
    }

    public boolean handleMouseDoubleClick(int localX, int localY, int mouseButton) {
        return false;
    }

    public boolean handleMouseUp(int localX, int localY, int mouseButton) {
        return false;
    }

    public boolean handleMouseDown(int localX, int localY, int mouseButton) {
        return false;
    }

    public boolean handleWheelMove(int units) {
        return false;
    }

    public void handleMouseEnter() {
    }

    public void handleMouseExit() {
    }

    public void handleMouseNoLongerDirectlyOver(int x, int y) {
    }

    public void handleMouseDirectlyOver(int x, int y) {
    }

    public boolean handleKeyPressed(KeyEvent keyCode) {
        return false;
    }

    public boolean handleKeyReleased(KeyEvent keyCode) {
        return false;
    }

    public boolean handleKeyTyped(KeyEvent keyCode) {
        return false;
    }

    public final void collectViewsUnderMouseFromBottomToTop(ArrayList<View> viewsUnderMouse, int localX, int localY, Rectangle2D clip) {
        Rectangle localBoundaries = this.getLocalBoundaries();
        if (clip.intersects(localBoundaries)) {
            if (this.clipsChildren) {
                clip = clip.createIntersection(localBoundaries);
            }
            if (clip.contains(localX, localY) && localBoundaries.contains((double)localX, (double)localY)) {
                viewsUnderMouse.add(0, this);
            }
            try {
                Point2D topLeft = this.getLocalTransform().inverseTransform(new Point2D.Double(clip.getMinX(), clip.getMinY()), null);
                Point2D bottomRight = this.getLocalTransform().inverseTransform(new Point2D.Double(clip.getMaxX(), clip.getMaxY()), null);
                clip = new Rectangle2D.Double(topLeft.getX(), topLeft.getY(), bottomRight.getX() - topLeft.getX() + 1.0, bottomRight.getY() - topLeft.getY() + 1.0);
                Point2D mouse = this.getLocalTransform().inverseTransform(new Point2D.Double(localX, localY), null);
                localX = (int)mouse.getX();
                localY = (int)mouse.getY();
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
            int i = 0;
            while (i < this.children.size()) {
                this.children.get(i).collectViewsUnderMouseFromBottomToTop(viewsUnderMouse, localX, localY, clip);
                ++i;
            }
        }
    }

    public final boolean containsOrChildrenContains(View view) {
        for (View child : this.children) {
            if (child == view) {
                return true;
            }
            if (!child.containsOrChildrenContains(view)) continue;
            return true;
        }
        return false;
    }

    public final void repaint() {
        ViewContainer container = this.getContainer();
        if (container != null) {
            container.repaint();
        }
    }

    public final double getLeftmostChildsLeft() {
        double minX = 0.0;
        for (View child : this.children) {
            if (!(child.getLocalLeft() < minX)) continue;
            minX = child.getLocalLeft();
        }
        return minX;
    }

    public final double getRightmostChildsRight() {
        double maxX = 0.0;
        for (View child : this.children) {
            if (!(child.getLocalRight() > maxX)) continue;
            maxX = child.getLocalRight();
        }
        return maxX;
    }

    public final double getBottommostChildsBottom() {
        double maxY = 0.0;
        for (View child : this.children) {
            if (!(child.getLocalBottom() > maxY)) continue;
            maxY = child.getLocalBottom();
        }
        return maxY;
    }

    private class AnimationInfo {
        private ViewContainer root;
        private final View view;
        private long startTime;
        private final int duration;
        private long elapsedTime;
        private final boolean animateChildren;

        public AnimationInfo(View view2, int ms, boolean animateChildren) {
            this.view = view2;
            this.startTime = System.currentTimeMillis();
            this.duration = ms;
            this.animateChildren = animateChildren;
            this.root = view2.getContainer();
        }

        public boolean update() {
            long current = System.currentTimeMillis();
            this.elapsedTime = current - this.startTime;
            final double percent = Math.min((double)((float)this.elapsedTime / (float)this.duration), 1.0);
            if (this.root != null) {
                this.root.invokeRunnableLater(new Runnable(){

                    public void run() {
                        AnimationInfo.this.view.animatePositions(percent, AnimationInfo.this.animateChildren);
                        AnimationInfo.this.view.repaint();
                    }
                });
            }
            this.view.repaint();
            return this.elapsedTime > (long)this.duration;
        }
    }
}

