/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.views;

import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.views.ScrollableView;
import edu.cmu.hcii.whyline.ui.views.View;
import java.awt.Graphics2D;

public class ScrollBarView
extends View {
    private final ScrollableView scrollable;
    private final Bar bar;
    private final boolean vertical;

    public ScrollBarView(ScrollableView scrollable, boolean vertical) {
        this.scrollable = scrollable;
        this.vertical = vertical;
        this.bar = new Bar();
        this.addChild(this.bar);
        if (vertical) {
            this.setLocalWidth(12.0, false);
        } else {
            this.setLocalHeight(12.0, false);
        }
    }

    public void paintBelowChildren(Graphics2D g) {
        this.fillRoundBoundaries(UI.getControlCenterColor(), g, UI.getRoundedness(), UI.getRoundedness());
        this.drawRoundBoundaries(UI.getControlFrontColor(), g, UI.getRoundedness(), UI.getRoundedness());
    }

    public void layout(boolean animate) {
        this.bar.layout(animate);
    }

    public boolean handleMouseDown(int localX, int localY, int mouseButton) {
        if (this.vertical) {
            double newY = ((double)localY - this.getLocalTop()) / this.getLocalHeight() * (double)this.scrollable.getVerticalSize() - (double)(this.scrollable.getVerticalVisible() / 2);
            this.scrollable.setVerticalPosition((int)this.boundVerticalBarPosition(newY));
        } else {
            double newX = ((double)localX - this.getLocalLeft()) / this.getLocalWidth() * (double)this.scrollable.getHorizontalSize() - (double)(this.scrollable.getHorizontalVisible() / 2);
            this.scrollable.setHorizontalPosition((int)this.boundHorizontalBarPosition(newX));
        }
        this.layout(false);
        return true;
    }

    private double boundVerticalBarPosition(double proposal) {
        return Math.max(0.0, Math.min((double)(this.scrollable.getVerticalSize() - this.scrollable.getVerticalVisible()), proposal));
    }

    private double boundHorizontalBarPosition(double proposal) {
        return Math.max(0.0, Math.min((double)(this.scrollable.getHorizontalSize() - this.scrollable.getHorizontalVisible()), proposal));
    }

    private class Bar
    extends View {
        public Bar() {
            if (ScrollBarView.this.vertical) {
                this.setLocalWidth(9.0, false);
                this.setLocalLeft(2.0, false);
            } else {
                this.setLocalHeight(9.0, false);
                this.setLocalTop(2.0, false);
            }
            this.layout(false);
        }

        public void layout(boolean animate) {
            if (ScrollBarView.this.vertical) {
                double percentVisible = this.getPercent(ScrollBarView.this.scrollable.getVerticalVisible(), ScrollBarView.this.scrollable.getVerticalSize());
                double positionVisible = this.getPercent(ScrollBarView.this.scrollable.getVerticalPosition(), ScrollBarView.this.scrollable.getVerticalSize());
                double newHeight = Math.max(12.0, ScrollBarView.this.getLocalHeight() * percentVisible);
                this.setLocalHeight(newHeight, animate);
                this.setLocalTop(ScrollBarView.this.getLocalHeight() * positionVisible, animate);
            } else {
                double percentVisible = this.getPercent(ScrollBarView.this.scrollable.getHorizontalVisible(), ScrollBarView.this.scrollable.getHorizontalSize());
                double positionVisible = this.getPercent(ScrollBarView.this.scrollable.getHorizontalPosition(), ScrollBarView.this.scrollable.getHorizontalSize());
                double newWidth = Math.max(12.0, ScrollBarView.this.getLocalWidth() * percentVisible);
                this.setLocalWidth(newWidth, animate);
                this.setLocalLeft(ScrollBarView.this.getLocalWidth() * positionVisible, animate);
            }
            if (animate) {
                this.animate(UI.getDuration(), false);
            }
        }

        private double getPercent(double visible, double total) {
            return Math.min(1.0, Math.max(0.0, visible / total));
        }

        public boolean handleMouseDrag(int localX, int localY, int mouseButton) {
            if (ScrollBarView.this.vertical) {
                double newPosition = localY - this.getContainer().getMouseFocusY();
                double newPercent = newPosition / ScrollBarView.this.getLocalHeight();
                double newWindowPosition = newPercent * (double)ScrollBarView.this.scrollable.getVerticalSize();
                double boundedPosition = ScrollBarView.this.boundVerticalBarPosition(newWindowPosition);
                ScrollBarView.this.scrollable.setVerticalPosition((int)boundedPosition);
            } else {
                double newPosition = localX - this.getContainer().getMouseFocusX();
                double newPercent = newPosition / ScrollBarView.this.getLocalWidth();
                double newWindowPosition = newPercent * (double)ScrollBarView.this.scrollable.getHorizontalSize();
                double boundedPosition = ScrollBarView.this.boundHorizontalBarPosition(newWindowPosition);
                ScrollBarView.this.scrollable.setHorizontalPosition((int)boundedPosition);
            }
            this.layout(false);
            return true;
        }

        public boolean handleMouseUp(int localX, int localY, int mouseButton) {
            this.getContainer().releaseMouseFocus();
            return true;
        }

        public boolean handleMouseDown(int localX, int localY, int mouseButton) {
            this.getContainer().focusMouseOn(this);
            return true;
        }

        public void paintBelowChildren(Graphics2D g) {
            int x1 = (int)this.getVisibleLocalLeft();
            int y1 = (int)this.getVisibleLocalTop();
            int width = (int)this.getVisibleLocalWidth();
            int height = (int)this.getVisibleLocalHeight();
            g = (Graphics2D)g.create();
            g.setColor(UI.getControlFrontColor());
            g.fillRoundRect(x1, y1, width, height, UI.getRoundedness(), UI.getRoundedness());
        }
    }
}

