/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.source;

import edu.cmu.hcii.whyline.qa.SourceFileMenuFactory;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylinePopup;
import edu.cmu.hcii.whyline.ui.io.BreakpointDebugger;
import edu.cmu.hcii.whyline.ui.source.LineView;
import edu.cmu.hcii.whyline.ui.views.View;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.GlyphVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenView
extends View
implements Comparable<TokenView> {
    private final LineView lineView;
    private final Token token;
    private final GlyphVector glyphs;

    public TokenView(LineView lineView, Token token, GlyphVector glyphs) {
        this.token = token;
        this.lineView = lineView;
        this.glyphs = glyphs;
    }

    public void setEmphasized(Color color) {
        this.lineView.getFileView().emphasizeToken(this, color);
    }

    public Color getEmphasizedColor() {
        return this.lineView.getFileView().getEmphasizedTokenColor(this);
    }

    public LineView getLineView() {
        return this.lineView;
    }

    public Token getToken() {
        return this.token;
    }

    public FileInterface getFile() {
        return this.token.getLine().getFile();
    }

    public JavaSourceFile getJavaFile() {
        return (JavaSourceFile)this.getFile();
    }

    public WhylineUI getWhylineUI() {
        return this.lineView.getFileView().getWhylineUI();
    }

    @Override
    public void paintBelowChildren(Graphics2D g) {
        BreakpointDebugger debugger;
        if (this.getWhylineUI().getMode() == WhylineUI.Mode.BREAKPOINT && (debugger = this.getWhylineUI().getBreakpointDebugger()).hasPrint(this.token)) {
            int left = (int)this.getVisibleLocalLeft();
            int top = (int)this.getVisibleLocalTop();
            int width = (int)this.getVisibleLocalWidth();
            int height = (int)this.getVisibleLocalHeight();
            g.setColor(UI.BREAKPOINT_COLOR);
            int padding = 3;
            g.fillRect(left - padding, top - padding, width + padding * 2, height + padding * 2);
        }
        if (this.representsJavaIdentifier() && this.getJavaFile().getInstructionFor(this.token) != null) {
            g.setColor(UI.IDENTIFIER_COLOR);
            int y = (int)(this.getLocalTop() + this.lineView.getAscent() + 1.0);
            g.setStroke(UI.INTERACTIVE_UNDERLINE_STROKE);
            g.drawLine((int)this.getLocalLeft(), y, (int)this.getLocalRight() - 1, y);
        }
        if (this.glyphs != null) {
            g.setColor(TokenView.getColor(this.token.getKind()));
            g.drawGlyphVector(this.glyphs, (int)this.getVisibleLocalLeft(), (int)(this.getVisibleLocalTop() + this.lineView.getAscent()));
        }
    }

    @Override
    public void paintAboveChildren(Graphics2D g) {
        if (this.lineView.getFileView().getTokenUnderMouse() == this) {
            int padding = 2;
            g.setStroke(UI.SELECTED_STROKE);
            g.setColor(UI.getHighlightColor());
            g.drawRoundRect((int)this.getVisibleLocalLeft() - padding, (int)this.getVisibleLocalTop() - padding, (int)this.getVisibleLocalWidth() + padding * 2 - 1, (int)this.getVisibleLocalHeight() + padding * 2 - 1, 5, 5);
        }
    }

    @Override
    public boolean handleMouseClick(int x, int y, int button) {
        if (this.lineView.getFileView().getTokenUnderMouse() != this) {
            return false;
        }
        if (!this.representsJavaIdentifier()) {
            return false;
        }
        if (!(this.getFile() instanceof JavaSourceFile)) {
            return false;
        }
        Object action = null;
        WhylinePopup popup = new WhylinePopup("");
        SourceFileMenuFactory.addQuestionsForToken(this.getWhylineUI(), popup, this.token);
        SourceFileMenuFactory.addQuestionsForLine(this.getWhylineUI(), popup, this.getLineView().getLine());
        SourceFileMenuFactory.addQuestionsForMethod(this.getWhylineUI(), popup, this.getLineView().getLine());
        return this.getContainer().showPopup(popup, (int)this.getGlobalLeft() + (int)((double)x - this.getLocalLeft()), (int)this.getGlobalTop() + (int)((double)y - this.getLocalTop()));
    }

    public boolean representsJavaIdentifier() {
        return (this.token.kind == 76 || this.token.kind == 56) && this.getFile() instanceof JavaSourceFile;
    }

    @Override
    public int compareTo(TokenView tokenView) {
        return this.token.compareTo(tokenView.token);
    }

    public String toString() {
        return this.token.toString();
    }

    public static Color getColor(int kind) {
        switch (kind) {
            case 8: 
            case 10: {
                return UI.COMMENT_COLOR;
            }
            case 14: 
            case 16: 
            case 19: 
            case 25: 
            case 32: 
            case 39: 
            case 41: 
            case 50: {
                return UI.KEYWORD_COLOR;
            }
            case 29: 
            case 44: 
            case 60: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 74: 
            case 75: {
                return UI.LITERAL_COLOR;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: {
                return UI.OPERATOR_COLOR;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return UI.DELIMITER_COLOR;
            }
            case 76: {
                return UI.IDENTIFIER_COLOR;
            }
        }
        return UI.KEYWORD_COLOR;
    }
}

