/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.source;

import edu.cmu.hcii.whyline.analysis.SearchResultsInterface;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.LineNumber;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.source.FileView;
import edu.cmu.hcii.whyline.ui.source.FilesView;
import edu.cmu.hcii.whyline.ui.source.LineView;
import edu.cmu.hcii.whyline.ui.source.TokenView;
import edu.cmu.hcii.whyline.ui.views.ScrollBarView;
import edu.cmu.hcii.whyline.ui.views.ScrollableView;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.ui.views.ViewContainer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWindow
extends View
implements Comparable<FileWindow>,
ScrollableView {
    private final FilesView filesView;
    private final FileInterface file;
    private final FileView fileView;
    private final Window window;
    private final ScrollBarView vertical;
    private final ScrollBarView horizontal;
    private final GlyphVector filename;
    private final Rectangle2D filenameBounds;
    private final int filenameDescent;
    private final double headerHeight;

    public FileWindow(FilesView filesView, ViewContainer container, FileInterface file) {
        this.filesView = filesView;
        this.file = file;
        Graphics2D g = (Graphics2D)filesView.getWhylineUI().getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font font = UI.getMediumFont().deriveFont(1);
        this.filename = font.createGlyphVector(g.getFontRenderContext(), file.getShortFileName());
        this.filenameBounds = this.filename.getLogicalBounds();
        this.filenameDescent = g.getFontMetrics(font).getDescent();
        this.vertical = new ScrollBarView(this, true);
        this.horizontal = new ScrollBarView(this, false);
        this.fileView = new FileView(filesView.getWhylineUI(), file);
        this.window = new Window(this.fileView);
        this.headerHeight = this.fileView.getLineHeight() + UI.getBorderPadding() * 2;
        this.fileView.setLocalLeft(0.0, false);
        this.fileView.setLocalTop(0.0, false);
        this.setClipsChildren(true);
        this.addChild(this.window);
        this.addChild(this.vertical);
        this.addChild(this.horizontal);
    }

    @Override
    public int getVerticalVisible() {
        return this.window == null ? 0 : (int)this.window.getLocalHeight();
    }

    @Override
    public int getVerticalPosition() {
        return this.window == null ? 0 : -((int)this.fileView.getLocalTop());
    }

    @Override
    public int getVerticalSize() {
        return this.window == null ? 0 : (int)this.fileView.getLocalHeight();
    }

    @Override
    public int getHorizontalVisible() {
        return this.window == null ? 0 : (int)this.window.getLocalWidth();
    }

    @Override
    public int getHorizontalPosition() {
        return this.window == null ? 0 : -((int)this.fileView.getLocalLeft());
    }

    @Override
    public int getHorizontalSize() {
        return this.window == null ? 0 : (int)this.fileView.getLocalWidth();
    }

    @Override
    public void setHorizontalPosition(int x) {
        this.fileView.setLocalLeft(-x, false);
        this.repaint();
    }

    @Override
    public void setVerticalPosition(int y) {
        this.fileView.setLocalTop(-y, false);
        this.repaint();
    }

    public FileView getFileView() {
        return this.fileView;
    }

    public void layout(double left, double top, double width, double height, boolean animate) {
        this.setLocalLeft(left, animate);
        this.setLocalTop(top, animate);
        this.setLocalWidth(width, animate);
        this.setLocalHeight(height, animate);
        if (this.window != null) {
            this.window.setLocalLeft(0.0, animate);
            this.window.setLocalTop(this.headerHeight, animate);
            this.window.setLocalWidth(this.getLocalWidth() - this.vertical.getLocalWidth(), animate);
            this.window.setLocalHeight(this.getLocalHeight() - this.headerHeight - this.horizontal.getLocalHeight(), animate);
            this.horizontal.setLocalLeft(0.0, true);
            this.horizontal.setLocalTop(this.window.getLocalBottom(), animate);
            this.horizontal.setLocalWidth(this.window.getLocalWidth(), animate);
            this.vertical.setLocalLeft(this.window.getLocalRight(), animate);
            this.vertical.setLocalTop(this.headerHeight, animate);
            this.vertical.setLocalHeight(this.window.getLocalHeight(), animate);
            this.horizontal.layout(animate);
            this.vertical.layout(animate);
        }
        if (animate) {
            this.animate(UI.getDuration(), false);
            this.window.animate(UI.getDuration(), false);
            this.horizontal.animate(UI.getDuration(), true);
            this.vertical.animate(UI.getDuration(), true);
        }
    }

    public void scrollToToken(TokenView view) {
        LineView lineView = view.getLineView();
        this.scrollToBoundary(lineView.getLocalTop(), lineView.getLocalBottom(), view.getLocalLeft(), view.getLocalRight());
    }

    public void scrollToLine(LineNumber lineNumber) {
        LineView line = this.fileView.getLine(lineNumber);
        if (line != null) {
            this.scrollToBoundary(line.getLocalTop(), line.getLocalBottom(), 0.0, 0.0);
        }
    }

    public void scrollToBoundary(double top, double bottom, double left, double right) {
        if (this.window == null) {
            return;
        }
        double verticalPosition = (top + bottom) / 2.0;
        double fileOffset = verticalPosition - this.window.getLocalHeight() / 2.0;
        fileOffset = Math.min(this.fileView.getLocalHeight() - this.window.getLocalHeight(), fileOffset);
        fileOffset = Math.max(0.0, fileOffset);
        this.fileView.setLocalTop(-fileOffset, true);
        this.fileView.animate(UI.getDuration(), false);
        this.vertical.layout(true);
        double horizontalPosition = (left + right) / 2.0;
        fileOffset = horizontalPosition - this.window.getLocalWidth() / 2.0;
        fileOffset = Math.min(this.fileView.getLocalWidth() - this.window.getLocalWidth(), fileOffset);
        fileOffset = Math.max(0.0, fileOffset);
        this.fileView.setLocalLeft(-fileOffset, true);
        this.fileView.animate(UI.getDuration(), false);
        this.horizontal.layout(true);
    }

    @Override
    public void paintBelowChildren(Graphics2D g) {
        g.setColor(UI.getFileColor());
        g.fillRoundRect((int)this.getVisibleLocalLeft(), (int)(this.getVisibleLocalTop() + this.headerHeight), (int)this.getVisibleLocalWidth(), (int)(this.getVisibleLocalHeight() - this.headerHeight), UI.getRoundedness(), UI.getRoundedness());
    }

    @Override
    public void paintAboveChildren(Graphics2D g) {
        g.setColor(UI.getControlBorderColor());
        g.drawRoundRect((int)this.getVisibleLocalLeft(), (int)(this.getVisibleLocalTop() + this.headerHeight), (int)this.getVisibleLocalWidth(), (int)(this.getVisibleLocalHeight() - this.headerHeight), UI.getRoundedness(), UI.getRoundedness());
        if (this.window == null || this.fileView == null) {
            return;
        }
        this.drawMarginHighlights(g);
        this.drawFileName(g);
    }

    private void drawMarginHighlights(Graphics2D g) {
        HashMap<LineView, HashSet<Object>> lines = new HashMap<LineView, HashSet<Object>>();
        for (TokenView t : this.fileView.getEmphasizedTokens()) {
            Color colorToAdd = this.fileView.getEmphasizedTokenColor(t);
            HashSet<Object> colors = (HashSet<Object>)lines.get(t.getLineView());
            if (colors == null) {
                colors = new HashSet<Object>();
                lines.put(t.getLineView(), colors);
            }
            colors.add(colorToAdd);
        }
        SearchResultsInterface results = this.filesView.getWhylineUI().getLinesUI().getSelectedResults();
        if (results != null) {
            for (Token t : results.getResults()) {
                LineView line = this.fileView.getViewOf(t.getLine());
                if (line == null) continue;
                HashSet<Color> colors = (HashSet<Color>)lines.get(line);
                if (colors == null) {
                    colors = new HashSet<Color>();
                    lines.put(line, colors);
                }
                colors.add(UI.getHighlightColor());
            }
        }
        int right = (int)(this.vertical.getLocalLeft() + this.getLocalLeft());
        int size = (int)this.vertical.getLocalWidth();
        for (LineView line : lines.keySet()) {
            double y = this.getVerticalPositionOfLine(line);
            Set colors = (Set)lines.get(line);
            int r = right;
            for (Color color : colors) {
                g.setColor(color);
                g.fillRect(r, (int)y, size / colors.size(), size / 2);
                g.setColor(Color.black);
                g.drawRect(r, (int)y, size / colors.size(), size / 2);
                r += size / colors.size();
            }
        }
    }

    private void drawFileName(Graphics2D g) {
        g = (Graphics2D)g.create();
        int x = (int)(this.getLocalLeft() + this.window.getLocalRight() - this.filenameBounds.getWidth()) - 2;
        int y = (int)(this.getLocalTop() + (double)this.filenameDescent) - 1;
        g.clipRect(x - UI.getPanelPadding(), y - UI.getPanelPadding(), (int)this.filenameBounds.getWidth() + UI.getPanelPadding() * 2, (int)this.filenameBounds.getHeight() + UI.getPanelPadding() * 2 - this.filenameDescent - 1);
        g.setColor(UI.getPanelDarkColor());
        g.fillRoundRect(x - UI.getPanelPadding(), y, (int)this.filenameBounds.getWidth() + UI.getPanelPadding() + UI.getRoundedness(), (int)this.filenameBounds.getHeight() + UI.getPanelPadding() * 2, UI.getRoundedness(), UI.getRoundedness());
        g.setColor(UI.getControlBorderColor());
        g.drawRoundRect(x - UI.getPanelPadding(), y, (int)this.filenameBounds.getWidth() + UI.getPanelPadding() + UI.getRoundedness(), (int)this.filenameBounds.getHeight() + UI.getPanelPadding() * 2, UI.getRoundedness(), UI.getRoundedness());
        g.setColor(UI.getPanelTextColor());
        g.drawGlyphVector(this.filename, x, (float)((double)y + this.filenameBounds.getHeight()));
    }

    private double getVerticalPositionOfLine(LineView line) {
        double percent = line.getLocalTop() / this.fileView.getLocalHeight();
        return percent * this.getLocalHeight() + this.getLocalTop();
    }

    @Override
    public void handleMouseExit() {
        this.setClipsChildren(true);
    }

    @Override
    public int compareTo(FileWindow o) {
        return this.file.getFileName().compareTo(o.file.getFileName());
    }

    public String toString() {
        return "Window of " + this.fileView.getFile().getFileName();
    }

    public double getHeaderHeight() {
        return this.headerHeight;
    }

    public double getScrollBarMargin() {
        return this.vertical.getLocalWidth();
    }

    private class Window
    extends View {
        public Window(FileView view) {
            this.setClipsChildren(true);
            this.addChild(view);
        }

        public boolean handleWheelMove(int units) {
            double newPosition = -FileWindow.this.fileView.getLocalTop() + (double)(FileWindow.this.fileView.getLineHeight() * units);
            double boundedPosition = Math.max(0.0, Math.min((double)(FileWindow.this.getVerticalSize() - FileWindow.this.getVerticalVisible()), newPosition));
            FileWindow.this.fileView.setLocalTop(-boundedPosition, false);
            FileWindow.this.vertical.layout(false);
            this.repaint();
            return true;
        }
    }
}

