/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.AnswerChangeListener;
import edu.cmu.hcii.whyline.qa.BranchBlock;
import edu.cmu.hcii.whyline.qa.ExceptionBlock;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.ExplanationBlock;
import edu.cmu.hcii.whyline.qa.InvocationBlock;
import edu.cmu.hcii.whyline.qa.LoopBlock;
import edu.cmu.hcii.whyline.qa.StartMethodBlock;
import edu.cmu.hcii.whyline.qa.ThreadBlock;
import edu.cmu.hcii.whyline.qa.UnexecutedInstruction;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.arrows.CausalArrowView;
import edu.cmu.hcii.whyline.ui.arrows.VisualizationArrow;
import edu.cmu.hcii.whyline.ui.qa.ArgumentEventView;
import edu.cmu.hcii.whyline.ui.qa.BranchBlockView;
import edu.cmu.hcii.whyline.ui.qa.DefinitionEventView;
import edu.cmu.hcii.whyline.ui.qa.EventBlockView;
import edu.cmu.hcii.whyline.ui.qa.EventView;
import edu.cmu.hcii.whyline.ui.qa.ExceptionBlockView;
import edu.cmu.hcii.whyline.ui.qa.GenericEventView;
import edu.cmu.hcii.whyline.ui.qa.InvocationBlockView;
import edu.cmu.hcii.whyline.ui.qa.LoopBlockView;
import edu.cmu.hcii.whyline.ui.qa.StartMethodBlockView;
import edu.cmu.hcii.whyline.ui.qa.ThreadBlockView;
import edu.cmu.hcii.whyline.ui.qa.UnexecutedInstructionView;
import edu.cmu.hcii.whyline.ui.qa.ValueProducedView;
import edu.cmu.hcii.whyline.ui.qa.VisualizationUI;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.ui.views.ViewContainer;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Visualization
extends View
implements AnswerChangeListener {
    private final Answer answer;
    public final GlyphVector LEFT_PAREN;
    public final GlyphVector RIGHT_PAREN;
    public final GlyphVector OPEN_BRACE;
    public final GlyphVector CLOSING_BRACE;
    public final double PAREN_AND_BRACE_WIDTH;
    public final double PAREN_WIDTH;
    public final double PAREN_HEIGHT;
    public final double PAREN_DESCENT;
    public final double PAREN_ASCENT;
    private final UnexecutedInstructionsView unexecutedInstructionsView;
    private final Map<UnexecutedInstruction, UnexecutedInstructionView> unexecutedViews = new Hashtable<UnexecutedInstruction, UnexecutedInstructionView>();
    private final ArrayList<ArrayList<UnexecutedInstructionView>> unexecutedGrid = new ArrayList();
    private final TIntIntHashMap rowsByThreadIDs = new TIntIntHashMap();
    private int nextRow = 0;
    private final WhylineUI whylineUI;
    private final VisualizationUI visualizationUI;
    private final Trace trace;
    private boolean isMetaDown = false;
    private final ArrayList<VisualizationArrow> arrows = new ArrayList();
    private EventView lastArrowSelectionComputed = null;
    private boolean lastArrowMetaState = false;
    private boolean threadsVisible = false;
    private boolean initializedToLastEvent = false;
    private double paddingBetweenThreads = 0.0;
    private ArrayList<ThreadBlockView> threadViewsByRow = new ArrayList();
    private TIntObjectHashMap<EventView> viewsByEvent = new TIntObjectHashMap(100);
    private Hashtable<Explanation, EventView> viewsByExplanation = new Hashtable(100);
    private Hashtable<ExplanationBlock, EventBlockView<?>> viewsByBlock = new Hashtable(100);
    private SortedSet<EventView> viewSequence = new TreeSet<EventView>();

    public Visualization(WhylineUI ui, VisualizationUI vui, Answer answer) {
        this.whylineUI = ui;
        this.visualizationUI = vui;
        this.answer = answer;
        this.trace = ui.getTrace();
        Graphics2D g = (Graphics2D)this.visualizationUI.getSituationUI().getWhylineUI().getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font delimiterFont = new Font("Arial Narrow", 0, 28);
        this.LEFT_PAREN = delimiterFont.createGlyphVector(g.getFontRenderContext(), "(");
        this.RIGHT_PAREN = delimiterFont.createGlyphVector(g.getFontRenderContext(), "){");
        this.OPEN_BRACE = delimiterFont.createGlyphVector(g.getFontRenderContext(), "{");
        this.CLOSING_BRACE = delimiterFont.createGlyphVector(g.getFontRenderContext(), "}");
        this.PAREN_WIDTH = this.LEFT_PAREN.getLogicalBounds().getWidth();
        this.PAREN_AND_BRACE_WIDTH = this.RIGHT_PAREN.getLogicalBounds().getWidth();
        this.PAREN_HEIGHT = this.LEFT_PAREN.getLogicalBounds().getHeight();
        this.PAREN_DESCENT = g.getFontMetrics(delimiterFont).getDescent();
        this.PAREN_ASCENT = g.getFontMetrics(delimiterFont).getAscent();
        this.unexecutedInstructionsView = new UnexecutedInstructionsView();
        this.addChild(this.unexecutedInstructionsView);
        this.layoutThreads(false);
        answer.addChangeListener(this);
        for (ThreadBlock block : answer.getThreadBlocks()) {
            this.threadBlockAdded(block);
        }
        this.initializeCollapsedState();
        this.layoutEvents(true, false);
    }

    public WhylineUI getWhylineUI() {
        return this.whylineUI;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public void setThreadsVisible(boolean threadsVisible) {
        this.threadsVisible = threadsVisible;
        this.layoutEvents(false, true);
    }

    public boolean areThreadsVisible() {
        return this.threadsVisible;
    }

    public VisualizationUI getVisualizationUI() {
        return this.visualizationUI;
    }

    public GlyphVector getLeftParenthesis() {
        return this.LEFT_PAREN;
    }

    public GlyphVector getRightParenthesisAndOpenBrace() {
        return this.RIGHT_PAREN;
    }

    public GlyphVector getOpenBrace() {
        return this.OPEN_BRACE;
    }

    public GlyphVector getClosingBrace() {
        return this.CLOSING_BRACE;
    }

    public int getRowForThread(int threadID) {
        if (this.rowsByThreadIDs.containsKey(threadID)) {
            return this.rowsByThreadIDs.get(threadID);
        }
        int row = this.nextRow++;
        this.rowsByThreadIDs.put(threadID, row);
        return row;
    }

    public int getNumberOfRows() {
        return this.rowsByThreadIDs.size();
    }

    public Answer getAnswer() {
        return this.answer;
    }

    public Explanation getFirstExplanation() {
        return this.viewSequence.isEmpty() ? null : this.viewSequence.first().getExplanation();
    }

    public Explanation getLastExplanation() {
        return this.viewSequence.isEmpty() ? null : this.viewSequence.last().getExplanation();
    }

    public UnexecutedInstructionView getFirstUnexecutedInstructionView() {
        if (this.unexecutedGrid.isEmpty()) {
            return null;
        }
        int index = this.unexecutedGrid.size() - 1;
        while (index >= 0) {
            ArrayList<UnexecutedInstructionView> views = this.unexecutedGrid.get(index);
            if (!views.isEmpty()) {
                return views.get(0);
            }
            --index;
        }
        return null;
    }

    public void scrollToView(View viewToScrollTo) {
        if (viewToScrollTo == null) {
            return;
        }
        double viewX = viewToScrollTo.getGlobalLeft() - (double)(this.visualizationUI.getViewportWidth() / 2);
        double viewY = viewToScrollTo.getGlobalTop() - (double)(this.visualizationUI.getViewportHeight() / 2);
        viewX = Math.min(Math.max(0.0, viewX), this.getLocalWidth() - (double)this.visualizationUI.getViewportWidth());
        viewY = Math.min(Math.max(0.0, viewY), this.getLocalHeight() - (double)this.visualizationUI.getViewportHeight());
        this.visualizationUI.setViewPosition((int)viewX, (int)viewY);
    }

    public void selectAndScrollToView(View newSelection, boolean scroll, String ui) {
        if (newSelection == null) {
            return;
        }
        this.answer.getQuestion().getAsker().processing(true);
        if (scroll) {
            this.scrollToView(newSelection);
        }
        if (newSelection instanceof EventView) {
            EventBlockView<?> blockView = ((EventView)newSelection).getBlockView();
            if (blockView != null) {
                blockView.uncollapseAncestors();
            }
            if (newSelection instanceof EventView) {
                ((EventView)newSelection).setHidden(false);
            }
            Explanation explanation = ((EventView)newSelection).getExplanation();
            this.whylineUI.selectExplanation(explanation, true, ui);
            this.answer.getTerminalDataDependencies(explanation);
            this.answer.broadcastChanges();
            this.layoutEvents(scroll, true);
        } else if (newSelection instanceof UnexecutedInstructionView) {
            ((UnexecutedInstructionView)newSelection).getUnexecutedInstruction().explain();
            ((UnexecutedInstructionView)newSelection).update();
            this.unexecutedInstructionsView.layout();
            this.whylineUI.selectUnexecutedInstruction(((UnexecutedInstructionView)newSelection).getUnexecutedInstruction(), true, ui);
        }
        this.answer.getQuestion().getAsker().processing(false);
        this.visualizationUI.moveMouseAgain();
    }

    private void initializeCollapsedState() {
        int latestEventID = this.answer.getLatestEventID();
        if (latestEventID >= 0) {
            for (EventView view : this.viewSequence) {
                view.initializeVisibility();
            }
        }
    }

    public void initializeToLastEvent() {
        EventView selection;
        if (this.initializedToLastEvent) {
            return;
        }
        this.initializedToLastEvent = true;
        if (this.unexecutedInstructionsView.getNumberOfChildren() > 0) {
            this.visualizationUI.setSelection(this.unexecutedInstructionsView.getFirstChild(), true, "init");
        } else if (this.viewSequence.size() > 0 && (selection = this.viewSequence.last()) != null) {
            this.visualizationUI.setSelection(selection, true, "init");
        }
    }

    @Override
    public void handleContainerResize() {
        this.layoutEvents(false, false);
    }

    private void layoutThreads(boolean animate) {
        double totalThreadHeight = 0.0;
        double maxThreadHeight = 0.0;
        int row = 0;
        while (row < this.threadViewsByRow.size()) {
            ThreadBlockView threadView = this.threadViewsByRow.get(row);
            threadView.determineHeight(animate);
            totalThreadHeight += threadView.getLocalHeight();
            maxThreadHeight = Math.max(maxThreadHeight, threadView.getLocalHeight());
            ++row;
        }
        if (this.areThreadsVisible()) {
            if (totalThreadHeight < (double)this.visualizationUI.getViewportHeight()) {
                this.paddingBetweenThreads = ((double)this.visualizationUI.getViewportHeight() - totalThreadHeight) / (double)(this.threadViewsByRow.size() + 1);
                double previousThreadBottom = 0.0;
                int row2 = 0;
                while (row2 < this.threadViewsByRow.size()) {
                    ThreadBlockView threadView = this.threadViewsByRow.get(row2);
                    double newTop = previousThreadBottom + this.paddingBetweenThreads;
                    threadView.setLocalTop(newTop, animate);
                    previousThreadBottom = threadView.getLocalBottom();
                    ++row2;
                }
            }
        } else {
            int offset = 0;
            if (maxThreadHeight < (double)this.visualizationUI.getViewportHeight()) {
                offset = (int)(((double)this.visualizationUI.getViewportHeight() - maxThreadHeight) / 3.0) * 2;
            }
            int row3 = 0;
            while (row3 < this.threadViewsByRow.size()) {
                ThreadBlockView threadView = this.threadViewsByRow.get(row3);
                double newTop = (double)offset + (maxThreadHeight - threadView.getLocalHeight()) / 2.0;
                threadView.setLocalTop(newTop, animate);
                ++row3;
            }
        }
        double newNotExecutedTop = 0.0;
        newNotExecutedTop = this.unexecutedInstructionsView.getLocalHeight() < (double)this.visualizationUI.getViewportHeight() ? 2.0 * ((double)this.visualizationUI.getViewportHeight() - this.unexecutedInstructionsView.getLocalHeight()) / 3.0 : 0.0;
        this.unexecutedInstructionsView.setLocalTop(newNotExecutedTop, animate);
        if (animate) {
            this.animate(UI.getDuration(), false);
        }
    }

    @Override
    public void threadBlockAdded(ThreadBlock top) {
        int row = this.getRowForThread(top.getThreadID());
        ThreadBlockView topView = new ThreadBlockView(this, top, row);
        this.addChild(topView);
        this.threadViewsByRow.add(topView);
        this.layoutThreads(false);
    }

    public List<ThreadBlockView> getThreadViews() {
        return Collections.unmodifiableList(this.threadViewsByRow);
    }

    public ThreadBlockView getThreadViewOnRow(int row) {
        return this.threadViewsByRow.get(row);
    }

    public int getNumberOfThreadRows() {
        return this.threadViewsByRow.size();
    }

    public EventView getSelectedEventView() {
        return this.visualizationUI.getSelection() instanceof EventView ? (EventView)this.visualizationUI.getSelection() : null;
    }

    public UnexecutedInstructionView getSelectedUnexecutedInstructionView() {
        return this.visualizationUI.getSelection() instanceof UnexecutedInstructionView ? (UnexecutedInstructionView)this.visualizationUI.getSelection() : null;
    }

    private Point getOnscreenLocationOf(View view) {
        return new Point((int)(view.getGlobalLeft() + view.getGlobalWidth() / 2.0 - (double)this.visualizationUI.getViewportX()), (int)(view.getGlobalTop() + view.getGlobalHeight() / 2.0 - (double)this.visualizationUI.getViewportY()));
    }

    @Override
    public void eventBlocksChanged(Set<ExplanationBlock> blocksChanged) {
        assert (EventQueue.isDispatchThread());
        EventView selection = this.getSelectedEventView();
        double windowOffsetXOfThisBeforeClick = 0.0;
        double windowOffsetYOfThisBeforeClick = 0.0;
        if (selection != null) {
            windowOffsetXOfThisBeforeClick = selection.getGlobalLeft() - (double)this.getVisualizationUI().getViewportX();
            windowOffsetYOfThisBeforeClick = selection.getGlobalTop() - (double)this.getVisualizationUI().getViewportY();
        }
        for (ExplanationBlock block : blocksChanged) {
            EventBlockView<?> view = this.getViewOfBlock(block);
            if (view == null) continue;
            view.synchronizeWithModel();
        }
        for (EventView view : this.viewSequence) {
            view.initializeVisibility();
        }
        this.layoutEvents(true, false);
        if (selection != null) {
            double newViewportX = selection.getGlobalLeft() - windowOffsetXOfThisBeforeClick;
            double newViewportY = selection.getGlobalTop() - windowOffsetYOfThisBeforeClick;
            this.getVisualizationUI().setViewPosition((int)newViewportX, (int)newViewportY);
        }
    }

    public EventView getEventViewBefore(EventView view) {
        SortedSet<EventView> eventsBefore = this.viewSequence.headSet(view);
        if (eventsBefore.isEmpty()) {
            return null;
        }
        EventView last = eventsBefore.last();
        if (last instanceof ThreadBlockView) {
            return this.getEventViewBefore(last);
        }
        return last;
    }

    public EventView getUncollapsedEventViewBefore(EventView view) {
        EventView before = this.getEventViewBefore(view);
        while (before != null && (before.ancestorIsCollapsed() || before.isHidden())) {
            before = this.getEventViewBefore(before);
        }
        return before;
    }

    public EventView getEventViewAfter(EventView view) {
        SortedSet<EventView> eventsAfter = this.viewSequence.tailSet(view);
        EventView eventAfter = eventsAfter.first();
        if (eventAfter == view) {
            EventView next;
            Iterator i = eventsAfter.iterator();
            i.next();
            EventView eventView = next = i.hasNext() ? (EventView)i.next() : null;
            if (next instanceof ThreadBlockView) {
                return this.getEventViewAfter(next);
            }
            return next;
        }
        return eventAfter;
    }

    public EventView getUncollapsedEventViewAfter(EventView view) {
        EventView after = this.getEventViewAfter(view);
        while (after != null && (after.ancestorIsCollapsed() || after.isHidden())) {
            after = this.getEventViewAfter(after);
        }
        return after;
    }

    public EventView getViewOfExplanation(Explanation event) {
        return this.viewsByExplanation.get(event);
    }

    public EventView getViewOfEvent(int eventID) {
        return this.viewsByEvent.get(eventID);
    }

    public EventBlockView<?> getViewOfBlock(ExplanationBlock block) {
        return this.viewsByBlock.get(block);
    }

    public EventView createViewFor(Explanation explanation) {
        EventKind kind = this.trace.getKind(explanation.getEventID());
        EventView child = explanation instanceof InvocationBlock ? new InvocationBlockView(this, (InvocationBlock)explanation) : (explanation instanceof LoopBlock ? new LoopBlockView(this, (LoopBlock)explanation) : (explanation instanceof BranchBlock ? new BranchBlockView(this, (BranchBlock)explanation) : (explanation instanceof StartMethodBlock ? new StartMethodBlockView(this, (StartMethodBlock)explanation) : (explanation instanceof ExceptionBlock ? new ExceptionBlockView(this, (ExceptionBlock)explanation) : (kind.isValueProduced ? new ValueProducedView(this, explanation) : (kind.isArgument ? new ArgumentEventView(this, explanation) : (kind.isDefinition ? new DefinitionEventView(this, explanation) : new GenericEventView(this, explanation))))))));
        return child;
    }

    public void associateExplanationWithView(Explanation explanation, EventView view) {
        this.viewsByExplanation.put(explanation, view);
        this.viewsByEvent.put(explanation.getEventID(), view);
        assert (!this.viewSequence.contains(view)) : "The view sequence already contains something equivalent to " + view;
        this.viewSequence.add(view);
    }

    public void associateBlockWithView(ExplanationBlock explanation, EventBlockView<?> view) {
        this.viewsByBlock.put(explanation, view);
    }

    public int getNumberOfArrows() {
        return this.arrows.size();
    }

    private void updateArrows() {
        EventView selection = this.getSelectedEventView();
        boolean changeArrows = selection != this.lastArrowSelectionComputed || this.isMetaDown != this.lastArrowMetaState;
        this.lastArrowSelectionComputed = selection;
        this.lastArrowMetaState = this.isMetaDown;
        if (changeArrows) {
            for (VisualizationArrow arrow : this.arrows) {
                this.removeChild(arrow);
            }
            this.arrows.clear();
            if (selection != null) {
                SortedMap<Explanation, Explanation> causes = this.getAnswer().getTerminalDataDependencies(selection.getExplanation());
                ExplanationBlock controlDependency = selection.getExplanation().getBlock();
                if (controlDependency != null && this.getViewOfExplanation(controlDependency) != null) {
                    this.arrows.add(new VisualizationArrow(this, null, (Explanation)controlDependency, selection.getExplanation(), 0, CausalArrowView.Relationship.CONTROL));
                }
                if (causes != null) {
                    int dependencyNumber = 1;
                    Iterator<Explanation> iterator = causes.keySet().iterator();
                    while (iterator.hasNext()) {
                        Explanation source;
                        Explanation cause;
                        Explanation original = cause = iterator.next();
                        if (!this.isMetaDown && (source = this.getVisibleSourceOfExplanation(cause)) != null) {
                            cause = source;
                        }
                        if (cause == null || this.getViewOfExplanation(cause) == null) continue;
                        this.arrows.add(new VisualizationArrow(this, original, cause, selection.getExplanation(), dependencyNumber++, CausalArrowView.Relationship.DATA));
                    }
                }
                for (VisualizationArrow arrow : this.arrows) {
                    this.addChild(arrow);
                }
            }
        }
        for (VisualizationArrow arrow : this.arrows) {
            arrow.bringToFront();
            arrow.layout();
        }
        this.repaint();
    }

    public void layoutEvents(boolean scroll, boolean animate) {
        Point onscreenLocation = this.visualizationUI.getSelection() == null ? null : this.getOnscreenLocationOf((View)this.visualizationUI.getSelection());
        this.layoutThreads(animate);
        double nextGlobalPosition = 10.0;
        boolean lastViewWasCollapsed = false;
        boolean lastViewHidden = false;
        EventBlockView<?> lastView = null;
        for (EventBlockView<?> eventBlockView : this.viewSequence) {
            EventBlockView<?> blockParent;
            EventBlockView<?> parent = eventBlockView.getBlockView();
            boolean isHidden = eventBlockView.isHidden();
            boolean ancestorIsCollapsed = eventBlockView.ancestorIsCollapsed();
            EventBlockView<?> eldestCollapsedAncestor = ancestorIsCollapsed ? eventBlockView.getEldestCollapsedAncestor() : null;
            boolean needsSpaceAfterCollapsedView = lastViewWasCollapsed && !ancestorIsCollapsed && !isHidden;
            boolean needsSpaceForUnexplainedEvents = !ancestorIsCollapsed && eventBlockView.needsToBeExplained() && !isHidden;
            boolean appearsAfterHiddenView = lastViewHidden && !ancestorIsCollapsed && !isHidden;
            boolean appearsAfterVisibleView = !ancestorIsCollapsed && !lastViewHidden && !isHidden;
            eventBlockView.setAppearsAfterHiddenEvent(appearsAfterHiddenView);
            boolean needsSpaceForHiddenEvents = appearsAfterHiddenView;
            if (appearsAfterVisibleView) {
                nextGlobalPosition += 10.0;
            } else if (needsSpaceAfterCollapsedView || needsSpaceForUnexplainedEvents || needsSpaceForHiddenEvents) {
                nextGlobalPosition += 60.0;
            }
            lastViewHidden = eventBlockView.isHidden();
            eventBlockView.setLocalLeft(eventBlockView.getParent().globalLeftToLocal(nextGlobalPosition), animate);
            if (!(eventBlockView instanceof ThreadBlockView)) {
                eventBlockView.setLocalTop(eventBlockView.getAppropriateTop(), animate);
            }
            if (eventBlockView.getNumberOfChildren() == 0) {
                double newWidth = ((EventView)eventBlockView).getWidthBasedOnBlocksCollapsedState();
                eventBlockView.setLocalWidth(newWidth, animate);
            }
            EventBlockView<?> viewWhoseParentToFit = eventBlockView;
            while ((blockParent = viewWhoseParentToFit.getBlockView()) != null) {
                boolean viewIsDoneWithChildren;
                boolean viewIsLastChild = blockParent.getLastChild() == viewWhoseParentToFit;
                boolean bl = viewIsDoneWithChildren = viewWhoseParentToFit.getNumberOfChildren() == 0 || ((EventView)viewWhoseParentToFit.getLastChild()).getEventID() <= eventBlockView.getEventID();
                if (!viewIsLastChild || !viewIsDoneWithChildren) break;
                blockParent.setLocalWidth(blockParent.getWidthBasedOnBlocksCollapsedState(), animate);
                viewWhoseParentToFit = blockParent;
            }
            double lastGlobalPosition = nextGlobalPosition;
            boolean bl = lastViewWasCollapsed = ancestorIsCollapsed || eventBlockView instanceof EventBlockView && ((EventBlockView)eventBlockView).isCollapsed();
            if (ancestorIsCollapsed) {
                nextGlobalPosition = Math.max(lastGlobalPosition, eldestCollapsedAncestor.getGlobalRight());
            } else if (eventBlockView instanceof EventBlockView) {
                nextGlobalPosition = eventBlockView.getGlobalLeft() + ((EventBlockView)eventBlockView).getGlobalOffsetForFirstView();
            } else if (!isHidden) {
                nextGlobalPosition = eventBlockView.getGlobalRight();
            }
            if (eventBlockView instanceof ArgumentEventView && !ancestorIsCollapsed && !eventBlockView.getBlockView().isHidden() && ((ArgumentEventView)((Object)eventBlockView)).isLastVisibleArgument()) {
                nextGlobalPosition += this.PAREN_AND_BRACE_WIDTH;
            }
            if (!(isHidden || parent == null || eventBlockView.getChildAfter() != null || !(parent instanceof InvocationBlockView) && !(parent instanceof StartMethodBlockView) || ancestorIsCollapsed || parent.isHidden())) {
                nextGlobalPosition += this.PAREN_WIDTH + 8.0;
            }
            assert (lastGlobalPosition <= nextGlobalPosition) : "\n\nThe last position was " + lastGlobalPosition + " but the new one is " + nextGlobalPosition + "\n" + "The view we just placed was " + eventBlockView + ", \nwhich had collapsed ancestor" + eldestCollapsedAncestor + " and\n" + "right edge = " + (ancestorIsCollapsed ? Double.valueOf(eldestCollapsedAncestor.getGlobalRight()) : "N/A");
            lastView = eventBlockView;
        }
        double d = 0.0;
        double bottommostThreadViewsBottom = 0.0;
        for (View child : this.getChildren()) {
            if (!(child instanceof ThreadBlockView)) continue;
            if (child.getLocalRight() > d) {
                d = child.getLocalRight();
            }
            if (!(child.getLocalBottom() > bottommostThreadViewsBottom)) continue;
            bottommostThreadViewsBottom = child.getLocalBottom();
        }
        this.unexecutedInstructionsView.setLocalLeft(d + 50.0, false);
        this.unexecutedInstructionsView.setLocalHeight(this.unexecutedInstructionsView.getBottommostChildsBottom(), false);
        this.fitToChildrenAndScaleToViewport();
        this.updateArrows();
        if (animate) {
            this.animate(UI.getDuration(), true);
        }
        if (scroll) {
            this.scrollToView((View)this.visualizationUI.getSelection());
        }
    }

    public void fitToChildrenAndScaleToViewport() {
        double scale = 1.0;
        this.setPercentToScaleChildren(scale);
        this.setPreferredSize(this.getRightmostChildsRight() * this.getPercentToScaleChildren() + 10.0, this.getBottommostChildsBottom() * this.getPercentToScaleChildren());
    }

    public static char getCharacterShortcutForNumber(int number) {
        if (number < 10) {
            return ("" + number).charAt(0);
        }
        return (char)(97 + (number - 10));
    }

    private int getNumberForCharacterShortcut(char shortcut) {
        if (shortcut == '0') {
            return 0;
        }
        if (Character.isDigit(shortcut)) {
            return shortcut - 49 + 1;
        }
        return shortcut + 10 - 97;
    }

    public boolean collapseSelectedBlockView() {
        EventView eventView = this.getSelectedEventView();
        if (eventView != null && eventView instanceof EventBlockView) {
            EventBlockView<?> blockView;
            EventBlockView<?> eventBlockView = blockView = eventView instanceof EventBlockView ? (EventBlockView<?>)eventView : eventView.getBlockView();
            if (blockView != null) {
                InvocationBlock invocationBlock;
                if (blockView instanceof InvocationBlockView && !(invocationBlock = (InvocationBlock)((InvocationBlockView)blockView).getBlock()).invocationWasInstrumented()) {
                    Toolkit.getDefaultToolkit().beep();
                    return true;
                }
                blockView.setCollapsed(!blockView.isCollapsed());
                this.layoutEvents(false, true);
                this.visualizationUI.setSelection(blockView, false, "collapse");
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return true;
        }
        Toolkit.getDefaultToolkit().beep();
        return false;
    }

    private EventView getEventViewJustAfter(int localX) {
        for (EventView view : this.viewSequence) {
            if (!(view.getGlobalLeft() > (double)localX)) continue;
            return view;
        }
        return null;
    }

    private EventView getEventViewJustBeforePosition(int localX) {
        EventView previous = null;
        for (EventView view : this.viewSequence) {
            if (view.getGlobalLeft() > (double)localX) {
                return previous;
            }
            previous = view;
        }
        return null;
    }

    @Override
    public void paintBelowChildren(Graphics2D g) {
        MethodInfo method;
        EventView event;
        int whitespace = 10;
        int leftEdgeOfWindow = this.visualizationUI.getViewportX();
        int rightEdgeOfWindow = leftEdgeOfWindow + this.visualizationUI.getViewportWidth();
        int edgeOfEvents = (int)(this.unexecutedInstructionsView.getLocalLeft() - (double)whitespace);
        int right = Math.min(rightEdgeOfWindow, edgeOfEvents) - whitespace;
        int bottom = (int)(this.getLocalBottom() - (double)UI.getBorderPadding());
        boolean terminationVisible = edgeOfEvents < rightEdgeOfWindow;
        boolean startVisible = leftEdgeOfWindow < 50;
        String startLabel = "start of program";
        if (!startVisible) {
            event = this.getEventViewJustAfter(leftEdgeOfWindow);
            method = event == null ? null : event.getExplanation().getMethod();
            startLabel = event != null ? String.valueOf(method.getJavaName()) + "()" : "";
        }
        method = (event = this.getEventViewJustAfter(rightEdgeOfWindow)) == null ? null : event.getExplanation().getMethod();
        String endLabel = event != null ? String.valueOf(method.getJavaName()) + "()" : "";
        g.setFont(UI.getLargeFont());
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D startLabelBounds = metrics.getStringBounds(startLabel, g);
        Rectangle2D endLabelBounds = metrics.getStringBounds(endLabel, g);
        leftEdgeOfWindow += whitespace;
        right = (int)((double)right - (endLabelBounds.getWidth() + (double)whitespace));
        if ((double)right < (double)leftEdgeOfWindow + startLabelBounds.getWidth() + (double)whitespace) {
            return;
        }
        g.drawString(startLabel, leftEdgeOfWindow, bottom + metrics.getDescent());
        g.drawString(endLabel, right + whitespace, bottom + metrics.getDescent());
        leftEdgeOfWindow = (int)((double)leftEdgeOfWindow + (startLabelBounds.getWidth() + (double)whitespace));
        g.drawLine(leftEdgeOfWindow, bottom, right, bottom);
        Polygon arrowhead = new Polygon();
        arrowhead.addPoint(right - whitespace, bottom + 5);
        arrowhead.addPoint(right - whitespace, bottom - 6);
        arrowhead.addPoint(right + 3, bottom);
        g.setColor(UI.getControlBorderColor());
        g.fill(arrowhead);
    }

    public boolean addNarrativeEntry() {
        EventView eventView = this.getSelectedEventView();
        if (eventView != null) {
            this.whylineUI.getNarrativeUI().addEntry(eventView.getExplanation());
            return true;
        }
        return false;
    }

    public boolean goToDataDependency(char c, boolean toSource) {
        return this.goToDataDependencyNumber(this.getNumberForCharacterShortcut(c), toSource);
    }

    public boolean goToDataDependencyNumber(int number, boolean toSource) {
        EventView viewToShow;
        Explanation source;
        --number;
        EventView eventView = this.getSelectedEventView();
        if (this.getSelectedEventView() == null) {
            return false;
        }
        SortedMap<Explanation, Explanation> dependencies = this.answer.getTerminalDataDependencies(eventView.getExplanation());
        if (dependencies == null || number >= dependencies.size()) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        Iterator<Explanation> dependencyIterator = dependencies.keySet().iterator();
        Explanation desiredEvent = null;
        int i = 0;
        while (i <= number) {
            desiredEvent = dependencyIterator.next();
            ++i;
        }
        if (desiredEvent == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        if (toSource && (source = this.getVisibleSourceOfExplanation(desiredEvent)) != null) {
            desiredEvent = source;
        }
        if ((viewToShow = this.getViewOfExplanation(desiredEvent)) != null) {
            this.visualizationUI.setSelection(viewToShow, true, "data");
        } else {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.whylineUI, "Oops. Couldn't find a view of the selection you chose.", "Oops.", 0);
        }
        return true;
    }

    private Explanation getVisibleSourceOfExplanation(Explanation desiredEvent) {
        this.answer.broadcastChanges();
        Explanation source = this.answer.getSourceOfExplanationsValue(desiredEvent);
        return source != null && this.getViewOfExplanation(source) != null ? source : null;
    }

    @Override
    public boolean handleKeyReleased(KeyEvent event) {
        return this.updateMeta();
    }

    private boolean updateMeta() {
        ViewContainer container = this.getContainer();
        boolean old = this.isMetaDown;
        this.isMetaDown = container.isShiftDown();
        if (old != this.isMetaDown) {
            if (this.getSelectedEventView() != null) {
                this.whylineUI.getFilesView().showExplanation(this.getSelectedEventView().getExplanation());
            }
            this.updateArrows();
        }
        return this.isMetaDown;
    }

    public boolean isMetaDown() {
        return this.isMetaDown;
    }

    public boolean showPreviousOrNextEventInThreadOrMethod(boolean previous, boolean inCall) {
        EventView view = this.getPreviousOrNextEventInThreadOrMethod(previous, inCall);
        if (view != null) {
            this.visualizationUI.setSelection(view, true);
            return true;
        }
        return false;
    }

    public EventView getPreviousOrNextEventInThreadOrMethod(boolean previous, boolean inCall) {
        View selection = (View)this.visualizationUI.getSelection();
        if (selection instanceof EventView) {
            return this.getPreviousOrNextEventInThreadOrMethod((EventView)selection, previous, inCall);
        }
        return null;
    }

    public EventView getPreviousOrNextEventInThreadOrMethod(EventView selection, boolean previous, boolean inCall) {
        int eventID = selection.getEventID();
        int newID = -1;
        while (true) {
            int n = previous ? (inCall ? this.trace.getPreviousEventIDInMethod(eventID) : this.trace.getPreviousEventInThread(eventID)) : (newID = inCall ? this.trace.getNextEventIDInMethod(eventID) : this.trace.getNextEventIDInThread(eventID));
            if (newID >= 0) {
                if (this.trace.getKind(newID) != EventKind.START_METHOD) {
                    Explanation explanation = this.answer.getExplanationFor(newID);
                    this.answer.broadcastChanges();
                    EventView view = this.getViewOfExplanation(explanation);
                    if (view != null) {
                        return view;
                    }
                }
            } else {
                return null;
            }
            eventID = newID;
        }
    }

    public void handleArrowOverChanged() {
        this.repaint();
    }

    public EventView getVisibleEventViewAtAfter(int localX) {
        for (EventView view : this.viewSequence) {
            if (view.isHidden() || !(view.getGlobalLeft() > (double)localX)) continue;
            return view;
        }
        return null;
    }

    @Override
    public boolean handleMouseDown(int x, int y, int button) {
        EventView before;
        EventView view = this.getVisibleEventViewAtAfter(this.visualizationUI.getViewportX() + x);
        if (view != null && (before = this.getPreviousOrNextEventInThreadOrMethod(view, true, false)) != null) {
            this.visualizationUI.setSelection(before, true);
            return true;
        }
        return false;
    }

    public boolean handleMouseMoved(int x, int y) {
        this.whylineUI.setArrowOver(-1);
        return true;
    }

    @Override
    public boolean handleKeyPressed(KeyEvent event) {
        this.updateMeta();
        switch (event.getKeyCode()) {
            case 84: {
                this.whylineUI.getActions().showHideThreads.actionPerformed(null);
                return true;
            }
            case 66: {
                boolean wasNew;
                Line line;
                Instruction inst;
                EventView view = this.getSelectedEventView();
                if (view != null && (inst = this.trace.getInstruction(view.getEventID())) != null && (line = inst.getLine()) != null && (wasNew = this.whylineUI.getPersistentState().addRelevantLine(line))) {
                    return true;
                }
                Toolkit.getDefaultToolkit().beep();
                return true;
            }
            case 27: {
                this.getWhylineUI().getActions().collapseBlock.execute();
                return true;
            }
            case 10: {
                this.getWhylineUI().getActions().addToExplanation.execute();
                return true;
            }
            case 44: {
                if (!this.showPreviousOrNextEventInThreadOrMethod(true, true)) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return true;
            }
            case 46: {
                if (!this.showPreviousOrNextEventInThreadOrMethod(false, true)) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return true;
            }
            case 37: {
                if (this.isMetaDown) {
                    if (!this.showPreviousOrNextEventInThreadOrMethod(true, false)) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    this.getWhylineUI().getActions().goToPreviousEvent.execute();
                }
                return true;
            }
            case 39: {
                if (this.isMetaDown) {
                    if (!this.showPreviousOrNextEventInThreadOrMethod(false, false)) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    this.getWhylineUI().getActions().goToNextEvent.execute();
                }
                return true;
            }
            case 38: {
                this.getWhylineUI().getActions().goToPreviousBlock.execute();
                return true;
            }
            case 40: {
                this.getWhylineUI().getActions().goToNextBlock.execute();
                return true;
            }
        }
        if (Character.isLetterOrDigit(event.getKeyChar())) {
            return this.goToDataDependency(event.getKeyChar(), !this.isMetaDown);
        }
        return false;
    }

    public UnexecutedInstructionView getUnexecutedInstructionView(UnexecutedInstruction inst) {
        return this.unexecutedViews.get(inst);
    }

    public UnexecutedInstructionView getUnexecutedInstructionAt(int row, int column) {
        if (column >= this.unexecutedGrid.size()) {
            return null;
        }
        if (column < 0) {
            return null;
        }
        ArrayList<UnexecutedInstructionView> viewColumn = this.unexecutedGrid.get(column);
        if (row < 0) {
            return null;
        }
        if (viewColumn.size() == 0) {
            return null;
        }
        if (row >= viewColumn.size()) {
            row = viewColumn.size() - 1;
        }
        return viewColumn.get(row);
    }

    private final int compareUnexecutedInstructions(UnexecutedInstruction o1, UnexecutedInstruction o2) {
        Instruction i2;
        Instruction i1 = o1.getInstruction();
        if (i1 == (i2 = o2.getInstruction())) {
            return 0;
        }
        QualifiedClassName thisName = i1.getClassfile().getInternalName();
        QualifiedClassName thatName = i2.getClassfile().getInternalName();
        boolean thisIsFamiliar = this.trace.classIsReferencedInFamiliarSourceFile(thisName);
        boolean thatIsFamiliar = this.trace.classIsReferencedInFamiliarSourceFile(thatName);
        if (thisIsFamiliar && !thatIsFamiliar) {
            return -1;
        }
        if (!thisIsFamiliar && thatIsFamiliar) {
            return 1;
        }
        int diff = o1.getIncoming().size() - o2.getIncoming().size();
        if (diff != 0) {
            return -diff;
        }
        int classNameComparison = thisName.compareTo(thatName);
        if (classNameComparison != 0) {
            return classNameComparison;
        }
        int methodNameComparison = i1.getMethod().getJavaName().compareTo(i2.getMethod().getJavaName());
        if (methodNameComparison != 0) {
            return methodNameComparison;
        }
        return i1.getIndex() - i2.getIndex();
    }

    private class UnexecutedInstructionsView
    extends View {
        public UnexecutedInstructionsView() {
            this.layout();
        }

        private void layout() {
            Visualization.this.unexecutedGrid.clear();
            this.removeChildren();
            UnexecutedInstruction[] unexecuted = Visualization.this.answer.getUnexecutedInstructions();
            if (unexecuted.length == 0) {
                this.setLocalWidth(0.0, false);
                this.setLocalHeight(0.0, false);
                return;
            }
            Comparator<UnexecutedInstruction> comparator = new Comparator<UnexecutedInstruction>(){

                @Override
                public int compare(UnexecutedInstruction o1, UnexecutedInstruction o2) {
                    return Visualization.this.compareUnexecutedInstructions(o1, o2);
                }
            };
            HashSet visited = new HashSet();
            TreeSet<UnexecutedInstruction> instructionsToLayout = new TreeSet<UnexecutedInstruction>(comparator);
            TreeSet<UnexecutedInstruction> instructionsToLayoutNext = new TreeSet<UnexecutedInstruction>(comparator);
            UnexecutedInstruction[] unexecutedInstructionArray = unexecuted;
            int n = unexecuted.length;
            int n2 = 0;
            while (n2 < n) {
                UnexecutedInstruction i = unexecutedInstructionArray[n2];
                instructionsToLayout.add(i);
                ++n2;
            }
            int depth = 0;
            while (instructionsToLayout.size() > 0) {
                ArrayList<UnexecutedInstructionView> column = new ArrayList<UnexecutedInstructionView>();
                Visualization.this.unexecutedGrid.add(column);
                int top = 0;
                for (UnexecutedInstruction inst : instructionsToLayout) {
                    UnexecutedInstructionView view = (UnexecutedInstructionView)Visualization.this.unexecutedViews.get(inst);
                    if (view == null) {
                        view = new UnexecutedInstructionView(Visualization.this, inst);
                        Visualization.this.unexecutedViews.put(inst, view);
                    }
                    if (view.getParent() == null) {
                        view.setGridLocation(column.size(), Visualization.this.unexecutedGrid.size() - 1);
                        this.addChild(view);
                    }
                    view.setLocalTop(top, false);
                    column.add(view);
                    for (UnexecutedInstruction incoming : inst.getIncoming()) {
                        assert (incoming != null);
                        instructionsToLayoutNext.add(incoming);
                    }
                    top += 50 + UnexecutedInstructionView.LABEL_HEIGHT;
                }
                instructionsToLayout.clear();
                TreeSet<UnexecutedInstruction> temp = instructionsToLayout;
                instructionsToLayout = instructionsToLayoutNext;
                instructionsToLayoutNext = temp;
                ++depth;
            }
            for (View child : this.getChildren()) {
                int realDepth = depth - ((UnexecutedInstructionView)child).getColumn();
                child.setLocalLeft((realDepth - 1) * 150, false);
            }
            this.setLocalWidth(this.getRightmostChildsRight(), false);
            this.setLocalHeight(this.getBottommostChildsBottom(), false);
        }

        public void paintBelowChildren(Graphics2D g) {
            for (View child : this.getChildren()) {
                ((UnexecutedInstructionView)child).selectedOrPointedToFromSelection = false;
            }
            UnexecutedInstructionView selection = Visualization.this.getSelectedUnexecutedInstructionView();
            if (selection != null) {
                UnexecutedInstructionView view;
                selection.selectedOrPointedToFromSelection = true;
                for (UnexecutedInstruction in : selection.getUnexecutedInstruction().getIncoming()) {
                    view = Visualization.this.getUnexecutedInstructionView(in);
                    if (view == null) continue;
                    view.selectedOrPointedToFromSelection = true;
                }
                for (UnexecutedInstruction out : selection.getUnexecutedInstruction().getOutgoing()) {
                    view = Visualization.this.getUnexecutedInstructionView(out);
                    if (view == null) continue;
                    view.selectedOrPointedToFromSelection = true;
                }
            }
        }
    }
}

