/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineLabel;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.util.CloseIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuestionTabsUI
extends WhylinePanel {
    private final WhylineUI whylineUI;
    private final QuestionLabel askAnotherLabel;
    private final HashSet<Question<?>> questionsAdded = new HashSet();
    private final LinkedList<QuestionLabel> buttons = new LinkedList();
    private static final CloseIcon closeIcon = new CloseIcon(){

        public boolean isSelected(Component c) {
            return ((QuestionLabel)c).selected;
        }
    };

    public QuestionTabsUI(WhylineUI whylineUI) {
        this.whylineUI = whylineUI;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.askAnotherLabel = new QuestionLabel(null);
        this.buttons.add(this.askAnotherLabel);
        this.add(this.askAnotherLabel);
        this.select(null);
        this.setBorder(new EmptyBorder(0, UI.getBorderPadding(), 0, UI.getBorderPadding()));
    }

    private GradientPaint getGradient(Color color) {
        return new GradientPaint(0.0f, 0.0f, color.darker(), 0.0f, 10.0f, color);
    }

    @Override
    public void paintComponent(Graphics g) {
        GradientPaint gradient = this.getGradient(UI.getPanelDarkColor());
        ((Graphics2D)g).setPaint(gradient);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(UI.getControlBorderColor());
        g.drawLine(0, 0, this.getWidth(), 0);
        super.paintComponent(g);
    }

    public void removeQuestion(Question<?> question) {
        QuestionLabel button = null;
        for (QuestionLabel b : this.buttons) {
            if (b.question != question) continue;
            button = b;
        }
        if (button != null) {
            this.remove(button);
            this.buttons.remove(button);
            this.questionsAdded.remove(question);
        }
        Question questionToSelect = this.getComponentCount() > 1 ? this.buttons.get(1).question : null;
        this.whylineUI.setQuestion(questionToSelect);
        this.validate();
        this.repaint();
    }

    public void addQuestion(Question<?> question) {
        if (!this.questionsAdded.contains(question) && question != null) {
            this.questionsAdded.add(question);
            QuestionLabel button = new QuestionLabel(question);
            this.add(button);
            this.buttons.add(button);
        }
        this.select(question);
    }

    private void select(Question<?> question) {
        Iterator iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            QuestionLabel button;
            button.setSelected((button = (QuestionLabel)iterator.next()).question == question);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QuestionLabel
    extends WhylineLabel {
        private Question<?> question;
        boolean selected;

        public QuestionLabel(Question<?> question) {
            super("");
            this.setFont(UI.getSmallFont().deriveFont(1));
            String label = question == null ? "Ask" : "<html>" + question.getQuestionText();
            this.setText(label);
            if (question != null) {
                this.setIcon(closeIcon);
            }
            this.question = question;
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (QuestionLabel.this.question != null && e.getX() < QuestionLabel.this.getBorder().getBorderInsets((Component)QuestionLabel.this).left + 12) {
                        Object[] options = new String[]{"Yes, close this question.", "Don't close this!"};
                        int answer = JOptionPane.showOptionDialog(QuestionTabsUI.this.whylineUI, "Are you sure you want to close this question?", "Close this question?", 0, 3, null, options, "Don't close this!");
                        if (answer == 0) {
                            QuestionTabsUI.this.whylineUI.removeQuestion(QuestionLabel.this.question);
                        }
                    } else {
                        QuestionTabsUI.this.whylineUI.setQuestion(QuestionLabel.this.question);
                    }
                }
            });
            this.setBorder(new EmptyBorder(UI.getBorderPadding() * 2, UI.getBorderPadding() * 2, UI.getBorderPadding() * 2, UI.getBorderPadding() * 2));
        }

        public void setSelected(boolean b) {
            this.selected = b;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int left = UI.getBorderPadding();
            int top = -UI.getBorderPadding();
            int right = this.getWidth() - UI.getBorderPadding();
            int bottom = this.getHeight() - UI.getBorderPadding() / 2 - 1;
            g.setColor(this.selected ? UI.getPanelLightColor() : UI.getPanelLightColor());
            g.fillRoundRect(left, top, right - left, bottom - top, UI.getRoundedness(), UI.getRoundedness());
            if (!this.selected) {
                g.setColor(UI.getControlBorderColor());
                g.drawLine(left, top + UI.getBorderPadding(), right, top + UI.getBorderPadding());
                ((Graphics2D)g).setPaint(QuestionTabsUI.this.getGradient(UI.getPanelLightColor()));
                g.fillRect(left, top, right - left, 20);
            } else {
                g.setColor(UI.getControlBorderColor());
                g.drawRoundRect(left, top, right - left, bottom - top, UI.getRoundedness(), UI.getRoundedness());
                Shape s = g.getClip();
                g.setClip(null);
                g.setColor(UI.getPanelLightColor());
                g.fillRect(left + 1, -3, right - left - 1, 6);
                g.setClip(s);
            }
            this.setForeground(this.selected ? UI.getControlTextColor() : UI.getControlDisabledColor());
            super.paintComponent(g);
        }
    }
}

