/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineLabel;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.ui.qa.SituationUI;
import edu.cmu.hcii.whyline.ui.views.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnswerUI
extends WhylinePanel {
    private final WhylineUI whylineUI;
    private final Question<?> question;
    private SituationUI currentSituation;
    private final Hashtable<Answer, SituationUI> situationsByAnswers = new Hashtable();
    private final WhylinePanel situationsPanel;
    private final WhylinePanel status;

    public AnswerUI(WhylineUI whylineUI, Question<?> question) {
        this.whylineUI = whylineUI;
        this.question = question;
        this.setLayout(new BorderLayout());
        WhylineLabel answering = new WhylineLabel("<html><center>Answering question...</center>", UI.getLargeFont().deriveFont(24.0f));
        answering.setHorizontalAlignment(0);
        this.status = new WhylinePanel(new BorderLayout());
        this.status.add((Component)answering, "Center");
        this.situationsPanel = new WhylinePanel(new BorderLayout());
        this.add((Component)this.status, "Center");
    }

    public SituationUI getSituationSelected() {
        return this.currentSituation;
    }

    public WhylineUI getWhylineUI() {
        return this.whylineUI;
    }

    public Question<?> getQuestion() {
        return this.question;
    }

    public void showSituation(Answer answer) {
        this.remove(this.status);
        SituationUI situationUI = this.situationsByAnswers.get(answer);
        if (situationUI == null) {
            situationUI = new SituationUI(this, answer);
            this.situationsByAnswers.put(answer, situationUI);
        }
        this.currentSituation = situationUI;
        this.add((Component)this.currentSituation, "Center");
        this.validate();
        this.currentSituation.getVisualizationUI().getVisualization().layoutEvents(true, false);
        this.currentSituation.getVisualizationUI().getVisualization().initializeToLastEvent();
        situationUI.getVisualizationUI().requestFocusInWindow();
        situationUI.getVisualizationUI().setSelection((View)situationUI.getVisualizationUI().getSelection(), true);
    }
}

