/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.launcher;

import edu.cmu.hcii.whyline.Whyline;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.TraceMetaData;
import edu.cmu.hcii.whyline.tracing.AgentOptions;
import edu.cmu.hcii.whyline.tracing.ExecutionConfiguration;
import edu.cmu.hcii.whyline.tracing.ProcessListener;
import edu.cmu.hcii.whyline.tracing.Runner;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineButton;
import edu.cmu.hcii.whyline.ui.components.WhylineCheckBox;
import edu.cmu.hcii.whyline.ui.components.WhylineComboBox;
import edu.cmu.hcii.whyline.ui.components.WhylineControlBorder;
import edu.cmu.hcii.whyline.ui.components.WhylineLabel;
import edu.cmu.hcii.whyline.ui.components.WhylineList;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.ui.components.WhylineScrollPane;
import edu.cmu.hcii.whyline.ui.components.WhylineTextArea;
import edu.cmu.hcii.whyline.ui.components.WhylineTextField;
import edu.cmu.hcii.whyline.ui.components.WhylineTitleLabel;
import edu.cmu.hcii.whyline.ui.components.WhylineWindow;
import edu.cmu.hcii.whyline.ui.launcher.LauncherUIActions;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LauncherUI
extends WhylineWindow {
    private final LauncherUIActions actions = new LauncherUIActions(this);
    private final TextField configurationName;
    private final TextField projectPath;
    private final TextField classPaths;
    private final TextField sourcePaths;
    private final InputField<WhylineComboBox> mainClass;
    private final TextField programArguments;
    private final TextField startMemory;
    private final TextField maxMemory;
    private final WhylineCheckBox printInstrumentationEvents;
    private final WhylineCheckBox printInstrumentationSummary;
    private final WhylineCheckBox printBeforeAfter;
    private WhylineList configurationsList;
    private WhylineList savedTraces;
    private final WhylineButton clearConfigurationsButton;
    private final WhylineButton clearConfigurationButton;
    private final WhylineButton createConfigurationButton;
    private final WhylineButton editConfigurationButton;
    private final WhylineButton whylineIt;
    private final WhylineButton breakpointIt;
    private final WhylineButton sliceIt;
    private final WhylineButton clearCache;
    private final WhylineButton deleteTraceButton;
    private final WhylineButton deleteAllTracesButton;
    private final WhylineButton cancelRunningButton;
    private final PreferencesPanel preferencesPanel;
    private final EditConfigurationPanel fieldsPanel;
    private final WhylinePanel mainPanel;
    private final RunPanel runPanel;
    private final WhylineTextArea selectionDetails;
    private ExecutionConfiguration configurationBeingEdited;
    private File WHYLINE_CONFIG_FILE;
    private final Vector<ExecutionConfiguration> configurations = new Vector();
    private boolean fieldsAreValid = true;
    protected final Vector<WhylineUI> openWindows = new Vector();
    private final Dimension preferredButtonColumnSize = new Dimension(0, 150);
    private final Dimension preferredInfoPanelSize = new Dimension(0, 150);
    private Runner currentExecution = null;
    private boolean updatingItems = false;
    private ConfigurationsPanel configurationsPanel;
    private final WhylinePanel executionsAndDataPanel;

    public LauncherUI() throws InterruptedException, InvocationTargetException {
        this.setDefaultCloseOperation(3);
        this.loadConfigurations();
        String javaHome = System.getProperty("java.home");
        this.configurationName = new TextField(this, "configuration name", ""){

            public String validate(WhylineTextField field) {
                return null;
            }
        };
        this.projectPath = new TextField(this, "project location", ""){

            public String validate(WhylineTextField field) {
                return ExecutionConfiguration.isValidProjectLocation(field.getText());
            }
        };
        this.classPaths = new TextField(this, "paths to classes", ""){

            public String validate(WhylineTextField field) {
                if (field.getText().equals("")) {
                    return null;
                }
                return ExecutionConfiguration.isValidPathList(LauncherUI.this.projectPath.getText(), field.getText());
            }
        };
        this.sourcePaths = new TextField(this, "paths to source", ""){

            public String validate(WhylineTextField field) {
                if (field.getText().equals("")) {
                    return null;
                }
                return ExecutionConfiguration.isValidPathList(LauncherUI.this.projectPath.getText(), field.getText());
            }
        };
        WhylineComboBox combo = new WhylineComboBox();
        combo.setEditable(true);
        this.mainClass = new InputField<WhylineComboBox>(this, "class with main()", combo){

            @Override
            public String validate(WhylineComboBox box) {
                return ExecutionConfiguration.isValidClassWithMain(LauncherUI.this.projectPath.getText(), LauncherUI.this.classPaths.getText(), (String)box.getSelectedItem());
            }
        };
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LauncherUI.this.mainClass.validate(true);
            }
        });
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LauncherUI.this.mainClass.validate(true);
            }
        });
        this.programArguments = new TextField(this, "program arguments", ""){

            public String validate(WhylineTextField field) {
                return null;
            }
        };
        this.startMemory = new TextField(this, "start memory (mb)", "64"){

            public String validate(WhylineTextField field) {
                return ExecutionConfiguration.isValidMemory(field.getText());
            }
        };
        this.maxMemory = new TextField(this, "max memory (mb)", "512"){

            public String validate(WhylineTextField field) {
                return ExecutionConfiguration.isValidMemory(field.getText());
            }
        };
        this.whylineIt = new WhylineButton(new RecordAction(WhylineUI.Mode.WHYLINE, null), "use the whyline to debug");
        this.whylineIt.setFont(UI.getLargeFont());
        this.breakpointIt = new WhylineButton(new RecordAction(WhylineUI.Mode.BREAKPOINT, null), "use the breakpoint debugger to debug");
        this.sliceIt = new WhylineButton(new RecordAction(WhylineUI.Mode.SLICER, null), "use the dynamic slider to debug");
        this.printInstrumentationEvents = new WhylineCheckBox("Print instrumentation events");
        this.printInstrumentationEvents.setAlignmentX(0.0f);
        this.printInstrumentationSummary = new WhylineCheckBox("Print instrumentation summary");
        this.printInstrumentationSummary.setAlignmentX(0.0f);
        this.printBeforeAfter = new WhylineCheckBox("Print methods before and after");
        this.printBeforeAfter.setAlignmentX(0.0f);
        this.createConfigurationButton = new WhylineButton(this.actions.createConfiguration, "create a new launch configuration");
        this.clearConfigurationsButton = new WhylineButton(this.actions.clearConfigurations, "clear the selected launch configuration");
        this.clearConfigurationButton = new WhylineButton(this.actions.removeConfiguration, "remove the selected launch configuration");
        this.editConfigurationButton = new WhylineButton(this.actions.editConfiguration, "edit the selected launch configuration");
        this.clearCache = new WhylineButton(this.actions.clearClassCache, "clear all of the instrumented classes in the global cache");
        this.clearCache.setEnabled(Whyline.getClassCacheFolder().exists());
        this.deleteTraceButton = new WhylineButton(this.actions.deleteSelectedTrace, "delete selected recording");
        this.deleteAllTracesButton = new WhylineButton(this.actions.deleteAllSavedTraces, "delete all recordings");
        this.deleteTraceButton.setEnabled(false);
        this.cancelRunningButton = new WhylineButton(this.actions.cancelRunning, "terminate this program");
        this.fieldsPanel = new EditConfigurationPanel();
        this.configurationsPanel = new ConfigurationsPanel();
        SavedTracesPanel tracesPanel = new SavedTracesPanel();
        this.runPanel = new RunPanel();
        this.selectionDetails = new WhylineTextArea("", 4, 15);
        this.selectionDetails.setBorder(null);
        this.selectionDetails.setEditable(false);
        this.selectionDetails.setOpaque(true);
        this.selectionDetails.setLineWrap(true);
        this.selectionDetails.setFont(UI.getFixedFont());
        this.selectionDetails.setBackground(UI.getControlBackColor());
        this.selectionDetails.setForeground(UI.getControlTextColor());
        WhylineScrollPane executionScroller = new WhylineScrollPane(this.selectionDetails);
        executionScroller.setBorder(new WhylineControlBorder());
        WhylinePanel executionsPanel = new WhylinePanel(new GridLayout(1, 2, UI.getPanelPadding(), UI.getPanelPadding()));
        executionsPanel.add(this.configurationsPanel);
        executionsPanel.add(tracesPanel);
        this.executionsAndDataPanel = new WhylinePanel(new BorderLayout(0, UI.getPanelPadding()));
        this.executionsAndDataPanel.add((Component)executionsPanel, "Center");
        this.executionsAndDataPanel.add((Component)executionScroller, "South");
        this.preferencesPanel = new PreferencesPanel();
        this.mainPanel = new WhylinePanel(new BorderLayout(UI.getPanelPadding(), UI.getPanelPadding() * 2));
        this.mainPanel.add((Component)this.executionsAndDataPanel, "Center");
        WhylinePanel welcomePanel = new WhylinePanel(new BorderLayout(UI.getPanelPadding(), UI.getPanelPadding()));
        welcomePanel.add((Component)new WhylineLabel("<html>Welcome to the <b>Whyline for Java</b>! After preparing a launch configuration or selecting a saved recording, <b>press the button at the bottom</b> to launch or load it."), "Center");
        welcomePanel.add((Component)new WhylineButton(new AbstractAction("preferences"){

            public void actionPerformed(ActionEvent e) {
                LauncherUI.this.showPreferencesPanel();
            }
        }, "Change Whyline preferences"), "East");
        this.mainPanel.add((Component)welcomePanel, "North");
        this.showExecutionPanel(false);
        WhylinePanel content = new WhylinePanel(new BorderLayout()){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g.create();
                double scale = (double)this.getWidth() / (double)UI.WHYLINE_IMAGE.getIconWidth();
                g2.scale(scale, scale);
                g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
                UI.WHYLINE_IMAGE.paintIcon(this, g2, 0, 0);
            }
        };
        content.setOpaque(true);
        this.setContentPane(content);
        this.getContentPane().add(this.mainPanel);
        ((JComponent)this.getContentPane()).setBorder(new EmptyBorder(UI.getPanelPadding() * 2, UI.getPanelPadding() * 2, UI.getPanelPadding() * 2, UI.getPanelPadding() * 2));
        this.setTitle("Whyline Launcher");
        this.setResizable(false);
        this.setPreferredSize(new Dimension(640, 640));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(screenSize.getWidth() - (double)this.getWidth()) / 2, (int)(screenSize.getHeight() - (double)this.getHeight()) / 2);
        this.setVisible(true);
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                if (LauncherUI.this.configurations.size() > 0) {
                    LauncherUI.this.configurationsList.setSelectedIndex(0);
                }
                LauncherUI.this.savedTraces.clearSelection();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                LauncherUI.this.savePersistentStates();
            }
        });
        if (!(this.configurations.size() != 0 || Whyline.getSavedTracesFolder().exists() && Whyline.getSavedTracesFolder().listFiles().length != 0)) {
            JOptionPane.showMessageDialog(this, "<html>Thanks for trying the Whyline for Java! <br><br>There are a few sample recordings you can try on the right,<br>or you can click the <i>create config</i> to record one of your own programs.");
        }
    }

    public Color getBackground() {
        return UI.getPanelLightColor();
    }

    private void savePersistentStates() {
        for (WhylineUI whylineUI : this.openWindows) {
            try {
                whylineUI.getPersistentState().write();
            }
            catch (IOException e) {
                System.err.println("Couldn't save persistent state of " + whylineUI.getTrace().getPath());
                e.printStackTrace();
            }
        }
    }

    public ExecutionConfiguration getConfigurationBeingEdited() {
        return this.configurationBeingEdited;
    }

    public Object getSelectedSavedTrace() {
        return this.savedTraces.getSelectedValue();
    }

    public void addNewConfiguration(File programDirectory) {
        ExecutionConfiguration newConfig = new ExecutionConfiguration(programDirectory.getAbsolutePath(), null, "", "128", "256", "");
        this.configurations.add(0, newConfig);
        this.configurationBeingEdited = newConfig;
        this.updateAndSaveConfigurations();
        this.showConfigurationPanel();
    }

    public void editSelectedConfiguration() {
        this.showConfigurationPanel();
    }

    public void showMainPanel() {
        this.getContentPane().removeAll();
        this.getContentPane().add(this.mainPanel);
        this.getContentPane().validate();
        this.repaint();
    }

    public void showPreferencesPanel() {
        this.getContentPane().removeAll();
        this.getContentPane().add(this.preferencesPanel);
        this.getContentPane().validate();
        this.repaint();
    }

    public void showConfigurationPanel() {
        this.getContentPane().removeAll();
        this.getContentPane().add(this.fieldsPanel);
        this.getContentPane().validate();
        this.repaint();
        if (this.configurationBeingEdited != null) {
            final ExecutionConfiguration config = this.configurationBeingEdited;
            Thread findMains = new Thread("Find mains"){

                public void run() {
                    config.determineClassesWithMain();
                    if (LauncherUI.this.configurationBeingEdited == config) {
                        WhylineComboBox box = (WhylineComboBox)LauncherUI.this.mainClass.getValue();
                        Object selection = box.getSelectedItem();
                        box.removeAllItems();
                        for (String name : config.getClassfilesWithMain()) {
                            box.addItem(name);
                        }
                        box.setSelectedItem(selection);
                    }
                }
            };
            findMains.start();
        }
    }

    public void clearAllConfigurations() {
        this.configurations.clear();
        this.WHYLINE_CONFIG_FILE.delete();
        this.updateAndSaveConfigurations();
    }

    public void removeConfigurationBeingEdited() {
        this.configurations.remove(this.configurationBeingEdited);
        this.clearConfigurationButton.setEnabled(false);
        this.editConfigurationButton.setEnabled(false);
        this.updateAndSaveConfigurations();
    }

    public void clearClassCache() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Util.deleteFolder(Whyline.getClassCacheFolder());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            e.printStackTrace();
        }
        this.clearCache.setEnabled(false);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void deleteSelectedTrace() {
        try {
            Util.deleteFolder(new File(Whyline.getSavedTracesFolder(), "" + this.getSelectedSavedTrace()));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            e.printStackTrace();
        }
        this.updateSavedTraceList();
    }

    public void deleteAllTraces() {
        try {
            Util.deleteFolder(Whyline.getSavedTracesFolder());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            e.printStackTrace();
        }
        this.updateSavedTraceList();
    }

    private void handleNewSavedTraceSelection() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object selection = this.savedTraces.getSelectedValue();
        this.enableAnalysisButton(selection != null);
        if (selection != null) {
            this.deleteTraceButton.setEnabled(true);
            this.clearConfigurationButton.setEnabled(false);
            this.editConfigurationButton.setEnabled(false);
            this.configurationsList.clearSelection();
            this.whylineIt.setText("<html>Load <b>" + selection + "</b>");
            File traceDirectory = new File(Whyline.getSavedTracesFolder(), (String)selection);
            if (traceDirectory.isDirectory()) {
                int maxMemory;
                long wiggleRoom;
                long uiSize;
                long traceSize;
                long day = traceDirectory.lastModified() / 86400000L;
                long today = System.currentTimeMillis() / 86400000L;
                long daysAgo = today - day;
                int size = Util.getFolderSizeInBytes(traceDirectory) / 1024 / 1024;
                TraceMetaData metadata = Trace.getMetaDataFrom(traceDirectory);
                long classfilesByteSize = (long)metadata.getNumberOfClasses() * 80L / 1024L;
                long expectedRetainedSize = classfilesByteSize + (traceSize = 100L) + (uiSize = 100L) + (wiggleRoom = 100L);
                boolean wontFit = expectedRetainedSize > (long)(maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
                this.selectionDetails.setLineWrap(true);
                this.selectionDetails.setText(size + " mb, created " + daysAgo + " days ago" + "\n" + Util.commas(metadata.getNumberOfClasses()) + " classes" + ", " + Util.commas(metadata.getNumberOfEvents()) + " events" + ", " + Util.commas((int)metadata.getNumberOfObjects()) + " objects" + "\n" + "~" + Util.commas(expectedRetainedSize) + " mb required, " + Util.commas(maxMemory) + " available" + (wontFit ? "\n(Need to restart with a higher maximum heap size)" : ""));
                this.selectionDetails.setForeground(wontFit ? UI.ERROR_COLOR : UI.getControlTextColor());
            }
        } else {
            this.selectionDetails.setText("");
            this.selectionDetails.setForeground(UI.getControlTextColor());
            this.editConfigurationButton.setEnabled(false);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void handleNewConfigurationSelection() {
        ExecutionConfiguration selectedConfig = (ExecutionConfiguration)this.configurationsList.getSelectedValue();
        if (selectedConfig != null) {
            this.clearConfigurationButton.setEnabled(true);
            this.deleteTraceButton.setEnabled(false);
            this.editConfigurationButton.setEnabled(true);
            this.configurationBeingEdited = null;
            this.fieldsPanel.configureFieldsWith(selectedConfig);
            this.configurationBeingEdited = selectedConfig;
            this.savedTraces.clearSelection();
            this.fieldsPanel.setVisible(true);
            this.selectionDetails.setLineWrap(true);
            this.validateSelectedConfiguration();
            this.whylineIt.setText("<html>Record <b>" + selectedConfig.getName() + "</b>");
        } else {
            this.fieldsPanel.setVisible(false);
            this.selectionDetails.setForeground(UI.getControlTextColor());
            this.editConfigurationButton.setEnabled(false);
        }
    }

    private void loadConfigurations() {
        block8: {
            this.configurations.clear();
            this.WHYLINE_CONFIG_FILE = new File(Whyline.getHome(), "configurations.xml");
            try {
                if (!this.WHYLINE_CONFIG_FILE.exists()) {
                    this.WHYLINE_CONFIG_FILE.createNewFile();
                    break block8;
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.WHYLINE_CONFIG_FILE)));
                String line = null;
                StringBuilder builder = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    builder.append(String.valueOf(line) + "\n");
                }
                try {
                    DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                    Document doc = docBuilder.parse(this.WHYLINE_CONFIG_FILE);
                    doc.getDocumentElement().normalize();
                    NodeList configs = doc.getElementsByTagName("config");
                    int i = 0;
                    while (i < configs.getLength()) {
                        Node config = configs.item(i);
                        this.configurations.add(new ExecutionConfiguration(config));
                        ++i;
                    }
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void saveConfigurations() {
        this.WHYLINE_CONFIG_FILE.delete();
        try {
            FileWriter writer = new FileWriter(this.WHYLINE_CONFIG_FILE);
            writer.write("<configurations>\n");
            for (ExecutionConfiguration config : this.configurations) {
                config.write(writer);
            }
            writer.write("</configurations>");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateSavedTraceList() {
        if (Whyline.getSavedTracesFolder().exists()) {
            File[] traceDirectories = Whyline.getSavedTracesFolder().listFiles();
            Vector<String> traceNames = new Vector<String>();
            File[] fileArray = traceDirectories;
            int n = traceDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    traceNames.add(file.getName());
                }
                ++n2;
            }
            this.savedTraces.setListData(traceNames);
        } else {
            this.savedTraces.setListData(new String[0]);
        }
    }

    private void analyzeTrace(File traceDirectory, WhylineUI.Mode mode) {
        try {
            this.openWindows.add(new WhylineUI(this, traceDirectory, mode));
            this.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    public void cancelCurrentExecution() {
        if (this.currentExecution != null) {
            this.currentExecution.kill();
        }
    }

    public void close(WhylineUI whylineUI) {
        this.openWindows.remove(whylineUI);
        System.gc();
        this.setVisible(true);
        this.updateSavedTraceList();
    }

    private void handleTextChange() {
        this.validateSelectedConfiguration();
    }

    private void validateSelectedConfiguration() {
        if (this.configurationBeingEdited == null) {
            return;
        }
        this.fieldsAreValid = this.startMemory.isValid() && this.maxMemory.isValid() && this.projectPath.isValid() && this.sourcePaths.isValid() && this.mainClass.isValid();
        this.enableAnalysisButton(this.fieldsAreValid);
        if (this.fieldsAreValid) {
            this.selectionDetails.setText(this.configurationBeingEdited.getJavaCommand(this.getOptionsFromSelectedConfiguration(), true));
            this.selectionDetails.setForeground(UI.getControlTextColor());
        } else {
            this.selectionDetails.setText("Error in configuration. Press the \"" + this.editConfigurationButton.getText() + "\" button to fix it.");
            this.selectionDetails.setForeground(UI.ERROR_COLOR);
        }
    }

    private void enableAnalysisButton(boolean enabled) {
        this.whylineIt.setEnabled(enabled);
        this.breakpointIt.setEnabled(enabled);
        this.sliceIt.setEnabled(enabled);
    }

    private void showExecutionPanel(boolean show) {
        if (show) {
            this.mainPanel.remove(this.runPanel);
            this.mainPanel.add((Component)this.cancelRunningButton, "South");
            this.executionsAndDataPanel.setEnabled(false);
            this.configurationsList.clearSelection();
            this.savedTraces.clearSelection();
            this.selectionDetails.setText("");
            this.selectionDetails.setRows(16);
        } else {
            this.mainPanel.remove(this.cancelRunningButton);
            this.mainPanel.add((Component)this.runPanel, "South");
            this.executionsAndDataPanel.setEnabled(true);
            this.configurationsList.clearSelection();
            this.savedTraces.clearSelection();
            this.selectionDetails.setRows(8);
        }
        this.selectionDetails.invalidate();
        this.mainPanel.validate();
        this.repaint();
    }

    private void updateAndSaveConfigurations() {
        this.configurationsList.setListData(this.configurations);
        this.saveConfigurations();
        this.configurationsList.setSelectedValue(this.configurationBeingEdited, true);
    }

    private AgentOptions getOptionsFromSelectedConfiguration() {
        if (this.configurationBeingEdited.getProjectPath() == null) {
            return null;
        }
        if (this.configurationBeingEdited.getSourcePaths() == null) {
            return null;
        }
        AgentOptions options = new AgentOptions(this.configurationBeingEdited.getProjectPath(), this.configurationBeingEdited.getClassPaths(), this.configurationBeingEdited.getSourcePaths());
        options.setOption(AgentOptions.Option.SKIP, this.configurationBeingEdited.getClassesToSkip());
        return options;
    }

    public void createConfig() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Choose the folder that contains your program.");
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.addNewConfiguration(chooser.getSelectedFile());
        }
        this.showConfigurationPanel();
    }

    private class ConfigurationsPanel
    extends WhylinePanel {
        public ConfigurationsPanel() {
            this.setLayout(new BorderLayout(UI.getPanelPadding(), UI.getPanelPadding()));
            LauncherUI.this.configurationsList = new WhylineList();
            LauncherUI.this.configurationsList.setBorder(null);
            LauncherUI.this.configurationsList.setListData(LauncherUI.this.configurations);
            LauncherUI.this.configurationsList.setFont(UI.getMediumFont());
            LauncherUI.this.configurationsList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    LauncherUI.this.handleNewConfigurationSelection();
                }
            });
            LauncherUI.this.configurationsList.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (!((ExecutionConfiguration)value).isValid()) {
                        c.setForeground(UI.ERROR_COLOR);
                    }
                    return c;
                }
            });
            WhylineScrollPane scroller = new WhylineScrollPane(LauncherUI.this.configurationsList);
            scroller.setBorder(new WhylineControlBorder());
            WhylinePanel recentExecutionsOperationsPanel = new WhylinePanel(new GridLayout(2, 2, UI.getPanelPadding(), UI.getPanelPadding()));
            recentExecutionsOperationsPanel.add(LauncherUI.this.createConfigurationButton);
            recentExecutionsOperationsPanel.add(LauncherUI.this.editConfigurationButton);
            recentExecutionsOperationsPanel.add(LauncherUI.this.clearConfigurationButton);
            recentExecutionsOperationsPanel.add(LauncherUI.this.clearCache);
            this.add((Component)new WhylineTitleLabel("Choose or create a launch config..."), "North");
            this.add((Component)scroller, "Center");
            this.add((Component)recentExecutionsOperationsPanel, "South");
        }
    }

    private class EditConfigurationPanel
    extends WhylinePanel {
        private final InputField<WhylineScrollPane> classesToSkipField;
        private final WhylineTextArea classesToSkip;

        public EditConfigurationPanel() {
            super(new BorderLayout(0, UI.getPanelPadding()));
            WhylinePanel fields = new WhylinePanel(new GridLayout(11, 1, UI.getPanelPadding(), UI.getPanelPadding()));
            WhylinePanel memory = new WhylinePanel(new GridLayout(1, 2, UI.getPanelPadding(), UI.getPanelPadding()));
            memory.add(LauncherUI.this.startMemory);
            memory.add(LauncherUI.this.maxMemory);
            this.classesToSkip = new WhylineTextArea("", 3, 0);
            this.classesToSkip.setBorder(null);
            WhylineScrollPane skipPane = new WhylineScrollPane(this.classesToSkip);
            skipPane.setBorder(new WhylineControlBorder());
            this.classesToSkipField = new InputField<WhylineScrollPane>(LauncherUI.this, "<html>Don't record classes starting with the following prefixes (<i>one per line</i>)", skipPane){

                @Override
                public String validate(WhylineScrollPane pane) {
                    String list = EditConfigurationPanel.this.classesToSkip.getText();
                    if (!list.equals("") && !list.matches("[a-zA-Z\\$0-9\\[\\]\\.\\n]+")) {
                        return "Must be a list of package or class (e.g., \"java.lang.Object\") names separated by carriage returns.";
                    }
                    return null;
                }
            };
            fields.add(new WhylineLabel("<html>Prepare for launch!<br><font size=\"-2\">(all relative paths are relative to the <b>project path</b> specified below)</font>", UI.getLargeFont()));
            fields.add(LauncherUI.this.configurationName);
            fields.add(LauncherUI.this.projectPath);
            fields.add(LauncherUI.this.classPaths);
            fields.add(LauncherUI.this.sourcePaths);
            fields.add(LauncherUI.this.mainClass);
            fields.add(LauncherUI.this.programArguments);
            fields.add(new WhylineLabel("Advanced options", UI.getLargeFont()));
            fields.add(memory);
            fields.add(this.classesToSkipField);
            this.add((Component)fields, "Center");
            this.add((Component)new WhylineButton(new AbstractAction("All done!"){

                public void actionPerformed(ActionEvent e) {
                    LauncherUI.this.showMainPanel();
                }
            }, "save the configuration changes"), "South");
            this.setOpaque(false);
            this.setBackground(null);
        }

        private void updateSelectedConfiguration() {
            if (LauncherUI.this.configurationBeingEdited != null) {
                LauncherUI.this.configurationBeingEdited.setName(LauncherUI.this.configurationName.getText());
                LauncherUI.this.configurationBeingEdited.setProjectPath(LauncherUI.this.projectPath.getText());
                LauncherUI.this.configurationBeingEdited.setClassPaths(LauncherUI.this.classPaths.getText());
                LauncherUI.this.configurationBeingEdited.setSourcePaths(LauncherUI.this.sourcePaths.getText());
                LauncherUI.this.configurationBeingEdited.setMainClass((String)((WhylineComboBox)LauncherUI.this.mainClass.getValue()).getSelectedItem());
                LauncherUI.this.configurationBeingEdited.setArguments(LauncherUI.this.programArguments.getText());
                LauncherUI.this.configurationBeingEdited.setStartMemory(LauncherUI.this.startMemory.getText());
                LauncherUI.this.configurationBeingEdited.setMaxMemory(LauncherUI.this.maxMemory.getText());
                LauncherUI.this.configurationBeingEdited.setClassesToSkip(this.classesToSkip.getText());
                LauncherUI.this.configurationsList.repaint();
                LauncherUI.this.saveConfigurations();
            }
        }

        private void configureFieldsWith(ExecutionConfiguration config) {
            if (config != null) {
                LauncherUI.this.configurationName.setText(config.getName());
                LauncherUI.this.projectPath.setText(config.getProjectPath());
                LauncherUI.this.classPaths.setText(config.getClassPaths());
                LauncherUI.this.sourcePaths.setText(config.getSourcePaths());
                ((WhylineComboBox)LauncherUI.this.mainClass.getValue()).setSelectedItem(config.getMainClass());
                LauncherUI.this.programArguments.setText(config.getArguments());
                LauncherUI.this.startMemory.setText(config.getStartMemory());
                LauncherUI.this.maxMemory.setText(config.getMaxMemory());
                this.classesToSkip.setText(config.getClassesToSkip());
            } else {
                LauncherUI.this.fieldsPanel.setVisible(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class InputField<T extends JComponent>
    extends WhylinePanel {
        private final LauncherUI launcher;
        protected final String description;
        protected WhylineLabel label;
        protected T value;
        private boolean isValid;

        public InputField(LauncherUI launcher, String description, T value) {
            super(new BorderLayout(UI.getPanelPadding(), UI.getPanelPadding()));
            this.launcher = launcher;
            this.description = description;
            this.value = value;
            this.label = new WhylineLabel(description);
            this.label.setVerticalAlignment(0);
            this.label.setPreferredSize(new Dimension(200, 0));
            this.add((Component)this.label, "West");
            this.add((Component)value, "Center");
        }

        public final void validate(boolean realChange) {
            String message = this.validate(this.value);
            if (message == null) {
                this.label.setText("<html>" + this.description);
                this.label.setForeground(UI.getControlTextColor());
                this.isValid = true;
            } else {
                this.label.setText("<html>" + message);
                this.label.setForeground(UI.ERROR_COLOR);
                this.isValid = false;
            }
            this.revalidate();
            if (realChange) {
                this.launcher.handleTextChange();
            }
            if (this.launcher.fieldsPanel != null) {
                this.launcher.fieldsPanel.updateSelectedConfiguration();
            }
            this.label.repaint();
        }

        public abstract String validate(T var1);

        public JLabel getLabel() {
            return this.label;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }
    }

    private class PreferencesPanel
    extends WhylinePanel {
        private final WhylineButton changeWhylineHome;
        private final WhylineLabel whylineHomeLabel;
        private final WhylineTextField sourcePath;

        public PreferencesPanel() {
            this.setLayout(new BorderLayout());
            this.whylineHomeLabel = new WhylineLabel(Whyline.getHome().getAbsolutePath());
            this.changeWhylineHome = new WhylineButton(new AbstractAction("change"){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(Whyline.getHome().getParent()){

                        public boolean accept(File f) {
                            return f.isDirectory();
                        }
                    };
                    chooser.setFileSelectionMode(1);
                    int result = chooser.showDialog(LauncherUI.this, "Set the home folder for whyline data");
                    switch (result) {
                        case -1: 
                        case 1: {
                            break;
                        }
                        case 0: {
                            File newWhylineHome = chooser.getSelectedFile();
                            Whyline.setHome(newWhylineHome);
                            LauncherUI.this.updateSavedTraceList();
                            LauncherUI.this.loadConfigurations();
                            LauncherUI.this.updateAndSaveConfigurations();
                            PreferencesPanel.this.whylineHomeLabel.setText(Whyline.getHome().getAbsolutePath());
                        }
                    }
                }
            }, "Change the location of the whyline cache and saved traces");
            WhylinePanel whylineHomePanel = new WhylinePanel(new FlowLayout(0, UI.getPanelPadding(), UI.getPanelPadding()));
            whylineHomePanel.add(new WhylineTitleLabel("Whyline folder"));
            whylineHomePanel.add(this.whylineHomeLabel);
            whylineHomePanel.add(this.changeWhylineHome);
            WhylinePanel pathPanel = new WhylinePanel(new FlowLayout(0, UI.getPanelPadding(), UI.getPanelPadding()));
            pathPanel.add(new WhylineTitleLabel("Path to JDK source"));
            this.sourcePath = new WhylineTextField(Whyline.getJDKSourcePath(), 160, "");
            this.sourcePath.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    this.validate();
                }

                public void insertUpdate(DocumentEvent e) {
                    this.validate();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.validate();
                }

                private void validate() {
                    boolean exists = new File(PreferencesPanel.this.sourcePath.getText()).exists();
                    PreferencesPanel.this.sourcePath.setForeground(exists ? UI.getControlTextColor() : UI.ERROR_COLOR);
                    Whyline.setJDKSourcePath(PreferencesPanel.this.sourcePath.getText());
                }
            });
            pathPanel.add(this.sourcePath);
            WhylinePanel fields = new WhylinePanel();
            fields.setLayout(new BoxLayout(fields, 1));
            this.add((Component)fields, "North");
            fields.add(whylineHomePanel);
            fields.add(pathPanel);
            this.add((Component)new WhylineButton(new AbstractAction("All done!"){

                public void actionPerformed(ActionEvent e) {
                    LauncherUI.this.showMainPanel();
                }
            }, "save the configuration changes"), "South");
        }
    }

    private class RecordAction
    extends AbstractAction {
        private final WhylineUI.Mode mode;

        public RecordAction(WhylineUI.Mode mode, Icon icon) {
            super(mode.getReadableName());
            this.mode = mode;
        }

        public void actionPerformed(ActionEvent e) {
            if (LauncherUI.this.currentExecution != null) {
                return;
            }
            if (LauncherUI.this.savedTraces.getSelectedValue() != null) {
                LauncherUI.this.analyzeTrace(new File(Whyline.getSavedTracesFolder(), "" + LauncherUI.this.savedTraces.getSelectedValue()), this.mode);
            } else if (LauncherUI.this.configurationBeingEdited != null) {
                LauncherUI.this.configurations.remove(LauncherUI.this.configurationBeingEdited);
                LauncherUI.this.configurations.insertElementAt(LauncherUI.this.configurationBeingEdited, 0);
                LauncherUI.this.updateAndSaveConfigurations();
                AgentOptions options = LauncherUI.this.getOptionsFromSelectedConfiguration();
                String command = LauncherUI.this.configurationBeingEdited.getJavaCommand(options, true);
                Whyline.debugBreak();
                Whyline.debug("Tracing and analyzing with command");
                Whyline.debug(command);
                Whyline.debugBreak();
                LauncherUI.this.showExecutionPanel(true);
                LauncherUI.this.selectionDetails.setLineWrap(false);
                LauncherUI.this.currentExecution = new Runner(Whyline.WHYLINE_JAR_PATH, LauncherUI.this.configurationBeingEdited, options, new ProcessListener(){

                    public void processDone(String message, int exitValue) {
                        if (message != null) {
                            JOptionPane.showMessageDialog(LauncherUI.this, "I tried executing the program you specified, but it failed. I got this message:\n" + message, "Trouble executing your program...", 0);
                        } else {
                            LauncherUI.this.analyzeTrace(Whyline.getWorkingTraceFolder(), RecordAction.this.mode);
                        }
                        LauncherUI.this.currentExecution = null;
                        LauncherUI.this.showExecutionPanel(false);
                    }

                    public void outputStream(String out) {
                        LauncherUI.this.selectionDetails.append(String.valueOf(out) + "\n");
                        LauncherUI.this.selectionDetails.scrollRectToVisible(new Rectangle(0, LauncherUI.this.selectionDetails.getHeight(), LauncherUI.this.getWidth(), LauncherUI.this.selectionDetails.getHeight()));
                    }

                    public void errorStream(String err) {
                        LauncherUI.this.selectionDetails.append(String.valueOf(err) + "\n");
                        LauncherUI.this.selectionDetails.scrollRectToVisible(new Rectangle(0, LauncherUI.this.selectionDetails.getHeight(), LauncherUI.this.getWidth(), LauncherUI.this.selectionDetails.getHeight()));
                    }
                });
                LauncherUI.this.cancelRunningButton.setText("<html>Stop running <b>" + LauncherUI.this.configurationBeingEdited.getName() + "</b>");
                LauncherUI.this.currentExecution.execute();
                LauncherUI.this.clearCache.setEnabled(true);
            }
        }
    }

    private class RunPanel
    extends WhylinePanel {
        public RunPanel() {
            super(new BorderLayout(UI.getPanelPadding(), UI.getPanelPadding()));
            WhylinePanel runButtons = new WhylinePanel(new GridLayout(1, 3, UI.getRoundedness(), UI.getRoundedness()));
            runButtons.add(LauncherUI.this.whylineIt);
            this.add((Component)runButtons, "Center");
        }
    }

    private class SavedTracesPanel
    extends WhylinePanel {
        public SavedTracesPanel() {
            this.setLayout(new BorderLayout(UI.getPanelPadding(), UI.getPanelPadding()));
            LauncherUI.this.savedTraces = new WhylineList();
            LauncherUI.this.savedTraces.setBorder(null);
            LauncherUI.this.updateSavedTraceList();
            LauncherUI.this.savedTraces.setFont(UI.getMediumFont());
            LauncherUI.this.savedTraces.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    LauncherUI.this.handleNewSavedTraceSelection();
                }
            });
            WhylineScrollPane scroller = new WhylineScrollPane(LauncherUI.this.savedTraces);
            scroller.setBorder(new WhylineControlBorder());
            WhylinePanel savedTraceOperationsPanel = new WhylinePanel(new GridLayout(2, 2, UI.getPanelPadding(), UI.getPanelPadding()));
            savedTraceOperationsPanel.add(LauncherUI.this.deleteTraceButton);
            savedTraceOperationsPanel.add(LauncherUI.this.deleteAllTracesButton);
            savedTraceOperationsPanel.add(new WhylineLabel(""));
            savedTraceOperationsPanel.add(new WhylineLabel(""));
            this.add((Component)new WhylineTitleLabel("<html>or choose a saved recording..."), "North");
            this.add((Component)savedTraceOperationsPanel, "South");
            this.add((Component)scroller, "Center");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TextField
    extends InputField<WhylineTextField> {
        public TextField(LauncherUI launcher, String description, String defaultText) {
            super(launcher, description, new WhylineTextField(defaultText, 20, description));
            ((WhylineTextField)this.value).getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent arg) {
                    TextField.this.validate(true);
                }

                public void insertUpdate(DocumentEvent arg) {
                    TextField.this.validate(true);
                }

                public void removeUpdate(DocumentEvent arg) {
                    TextField.this.validate(true);
                }
            });
            ((WhylineTextField)this.value).setFont(UI.getMediumFont());
            ((WhylineTextField)this.value).setMaximumSize(new Dimension(Short.MAX_VALUE, (int)((WhylineTextField)this.value).getMinimumSize().getHeight()));
            this.validate(false);
        }

        public void setText(String t) {
            ((WhylineTextField)this.value).setText(t);
        }

        public String getText() {
            return ((WhylineTextField)this.value).getText();
        }
    }
}

