/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.io;

import edu.cmu.hcii.whyline.io.TextualOutputEvent;
import edu.cmu.hcii.whyline.qa.QuestionMenu;
import edu.cmu.hcii.whyline.qa.TextMenuFactory;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.io.ConsoleUI;
import edu.cmu.hcii.whyline.ui.views.View;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public final class TextualOutputEventView
extends View {
    private final ConsoleUI consoleUI;
    public final TextualOutputEvent event;
    private final ArrayList<String> lines = new ArrayList(1);
    public int lineHeight;
    public int ascent;
    public boolean hidden = false;

    public TextualOutputEventView(ConsoleUI console, TextualOutputEvent event, int left, int top) {
        this.consoleUI = console;
        this.event = event;
        this.setLocalLeft(left, false);
        this.setLocalTop(top, false);
        Font font = UI.getFixedFont();
        Graphics2D g = (Graphics2D)this.consoleUI.getWhylineUI().getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics metrics = g.getFontMetrics(font);
        this.lineHeight = metrics.getHeight();
        this.ascent = metrics.getAscent();
        String linePrinted = event.getStringPrinted().replace("\t", "    ");
        String[] lineText = linePrinted.split("\n");
        if (linePrinted.equals("\n")) {
            lineText = new String[]{""};
        }
        int width = 0;
        String[] stringArray = lineText;
        int n = lineText.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            GlyphVector glyphs = font.createGlyphVector(g.getFontRenderContext(), line);
            this.lines.add(line);
            Rectangle2D bounds = glyphs.getLogicalBounds();
            int lineWidth = (int)bounds.getWidth();
            if (lineWidth > width) {
                width = lineWidth;
            }
            ++n2;
        }
        this.setLocalWidth(width, false);
        this.setLocalHeight(this.lineHeight * this.lines.size(), false);
        this.lines.trimToSize();
    }

    private boolean isNotInteractive() {
        return this.hidden;
    }

    public boolean handleMouseClick(int x, int y, int mouseButton) {
        if (!this.consoleUI.getWhylineUI().canAskOutputQuestions() || this.consoleUI.getWhylineUI().getVisualizationUIVisible() != null) {
            return false;
        }
        if (this.isNotInteractive()) {
            return false;
        }
        this.consoleUI.setSelection(this, false);
        WhylineUI whylineUI = this.consoleUI.getWhylineUI();
        QuestionMenu menu = TextMenuFactory.getTextualOutputMenu(whylineUI, this.event);
        Point2D point = this.getParent().localToGlobal(new Point2D.Double(x, y));
        return this.getContainer().showPopup(menu.generatePopupMenu(), (int)point.getX(), (int)point.getY());
    }

    public boolean handleMouseMove(int x, int y) {
        if (!this.consoleUI.canUpdateSelection()) {
            return false;
        }
        if (this.isNotInteractive()) {
            return false;
        }
        this.consoleUI.setSelection(this, false);
        return true;
    }

    public TextualOutputEvent getEvent() {
        return this.event;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void paintBelowChildren(Graphics2D g) {
        if (this.hidden) {
            return;
        }
        g.setColor(UI.getConsoleTextColor());
        g.setFont(UI.getFixedFont());
        int y = (int)(this.getLocalTop() + (double)this.ascent);
        for (String gv : this.lines) {
            g.drawString(gv, (int)this.getLocalLeft(), y);
            y += this.lineHeight;
        }
    }

    public void paintAboveChildren(Graphics2D g) {
        if (this.consoleUI.getSelection() == this || this.consoleUI.getWhylineUI().getEventAtInputTime() == this.event) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(UI.SELECTED_STROKE);
            g.setColor(UI.getHighlightColor());
            g.drawRoundRect((int)this.getLocalLeft(), (int)this.getLocalTop(), (int)this.getLocalWidth() - 1, (int)this.getLocalHeight() - 1, 5, 5);
            g.setStroke(oldStroke);
        }
    }
}

