/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.io;

import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineLabel;
import java.util.Hashtable;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphicsScaleSlider
extends JSlider {
    private final WhylineUI whylineUI;
    private boolean fitGraphicsToWindow;
    private final ChangeListener scaleListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            GraphicsScaleSlider.this.whylineUI.getGraphicsUI().updateScale();
        }
    };

    public GraphicsScaleSlider(WhylineUI whylineUI) {
        super(0, 25, 250, 100);
        this.whylineUI = whylineUI;
        int min = 25;
        int max = 250;
        Hashtable<Integer, WhylineLabel> labels = new Hashtable<Integer, WhylineLabel>();
        labels.put(min, new WhylineLabel(min + "%", UI.getSmallFont()));
        labels.put(100, new WhylineLabel("100%", UI.getSmallFont()));
        labels.put(max, new WhylineLabel(max + "%", UI.getSmallFont()));
        this.setLabelTable(labels);
        this.setFocusable(false);
        this.setPaintLabels(true);
        this.setPaintTicks(true);
        this.setToolTipText("controls the zoom level of graphical output");
    }

    public void setFitToWindow(boolean fitToWindow) {
        this.fitGraphicsToWindow = fitToWindow;
        if (this.fitGraphicsToWindow) {
            this.setEnabled(false);
            this.removeChangeListener(this.scaleListener);
            this.setVisible(false);
        } else {
            this.setValue(100);
            this.setEnabled(true);
            this.addChangeListener(this.scaleListener);
            this.setVisible(true);
        }
        this.whylineUI.getGraphicsUI().updateScale();
    }

    public boolean isFitToWindow() {
        return this.fitGraphicsToWindow;
    }
}

