/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.io;

import edu.cmu.hcii.whyline.io.IOEvent;
import edu.cmu.hcii.whyline.io.IOHistory;
import edu.cmu.hcii.whyline.io.TextualOutputEvent;
import edu.cmu.hcii.whyline.qa.QuestionMenu;
import edu.cmu.hcii.whyline.qa.TextMenuFactory;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.UserTimeListener;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.io.TextualOutputEventView;
import edu.cmu.hcii.whyline.ui.views.DynamicComponent;
import edu.cmu.hcii.whyline.ui.views.DynamicComponentWithSelection;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsoleUI
extends DynamicComponentWithSelection<TextualOutputEventView>
implements UserTimeListener {
    private final WhylineUI whylineUI;
    private int margin = 4;
    private final Map<TextualOutputEvent, TextualOutputEventView> viewsByModel = new HashMap<TextualOutputEvent, TextualOutputEventView>();
    private View lines = new View(){

        public boolean handleMouseClick(int x, int y, int mouseButton) {
            if (!ConsoleUI.this.whylineUI.canAskOutputQuestions()) {
                return false;
            }
            if (ConsoleUI.this.whylineUI.getVisualizationUIVisible() != null) {
                ConsoleUI.this.whylineUI.setQuestion(null);
                return true;
            }
            Point2D point = this.localToGlobal(new Point2D.Double(x, y));
            QuestionMenu menu = TextMenuFactory.getTextualOutputMenu(ConsoleUI.this.whylineUI, null);
            return ConsoleUI.this.showPopup(menu.generatePopupMenu(), (int)point.getX(), (int)point.getY());
        }

        public boolean handleMouseMove(int x, int y) {
            if (!ConsoleUI.this.canUpdateSelection()) {
                return false;
            }
            ConsoleUI.this.setSelection(null, false);
            return true;
        }

        public void handleMouseNoLongerDirectlyOver(int x, int y) {
            if (!ConsoleUI.this.canUpdateSelection()) {
                return;
            }
            ConsoleUI.this.setSelection(null, false);
        }

        public void handleMouseExit() {
            if (!ConsoleUI.this.canUpdateSelection()) {
                return;
            }
            ConsoleUI.this.setSelection(null, false);
        }

        public void paintAboveChildren(Graphics2D g) {
            if (!ConsoleUI.this.whylineUI.canAskOutputQuestions()) {
                return;
            }
            if (ConsoleUI.this.whylineUI.getVisualizationUIVisible() == null) {
                TextualOutputEventView view;
                if (ConsoleUI.this.whylineUI.getInputEventID() == 0) {
                    Util.drawCallout(g, null, "after the program started...", 0, 0);
                } else if (ConsoleUI.this.whylineUI.getEventAtInputTime() instanceof TextualOutputEvent && (view = (TextualOutputEventView)ConsoleUI.this.viewsByModel.get(ConsoleUI.this.whylineUI.getEventAtInputTime())) != null) {
                    int left = (int)view.getGlobalRight() + UI.getPanelPadding();
                    int top = (int)view.getGlobalTop() - UI.getPanelPadding();
                    Util.drawCallout(g, UI.CONSOLE_OUT_ICON, "after this was printed...", left, top);
                }
            }
            if (this.getNumberOfChildren() == 0 && ConsoleUI.this.whylineUI.getTrace().isDoneLoading()) {
                g.setFont(UI.getLargeFont());
                g.setColor(UI.getControlTextColor());
                g.drawString("The program didn't produce textual output", 10, g.getFontMetrics(UI.getLargeFont()).getHeight() + 10);
            }
        }
    };
    private int rightEdge;
    private int bottomEdge;
    private int indexOfLastPrintParsed = -1;
    private TextualOutputEventView previousConsoleLine = null;

    public ConsoleUI(WhylineUI whylineUI) {
        super(whylineUI, DynamicComponent.Sizing.SCROLL_OR_FIT_IF_SMALLER, DynamicComponent.Sizing.SCROLL_OR_FIT_IF_SMALLER);
        this.whylineUI = whylineUI;
        this.setView(this.lines);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setToolTipText("Click to ask about <b>text</b> that didn't print");
        this.setBackground(UI.getConsoleBackColor());
    }

    private void parseOutputHistory() {
        Graphics g = this.whylineUI.getGraphics();
        if (g == null) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics(UI.getFixedFont());
        IOHistory<TextualOutputEvent> output = this.whylineUI.getTrace().getPrintHistory();
        int i = this.indexOfLastPrintParsed + 1;
        while (i < output.getNumberOfEvents()) {
            int newLinesTop;
            TextualOutputEvent event = output.getEventAtIndex(i);
            int newLinesLeft = this.previousConsoleLine == null ? UI.getBorderPadding() : (int)this.previousConsoleLine.getLocalRight();
            int n = newLinesTop = this.previousConsoleLine == null ? UI.getBorderPadding() : (int)this.previousConsoleLine.getLocalTop();
            if (this.previousConsoleLine != null && this.previousConsoleLine.getEvent().getStringPrinted().endsWith("\n")) {
                newLinesTop = (int)((double)newLinesTop + this.previousConsoleLine.getLocalHeight());
                newLinesLeft = UI.getBorderPadding();
            }
            TextualOutputEventView newLine = new TextualOutputEventView(this, event, newLinesLeft, newLinesTop);
            this.viewsByModel.put(event, newLine);
            if (newLine.getLocalWidth() > (double)this.rightEdge) {
                this.rightEdge = (int)newLine.getLocalWidth();
            }
            this.lines.addChild(newLine);
            this.previousConsoleLine = newLine;
            ++i;
        }
        int width = (int)this.lines.getRightmostChildsRight();
        int height = (int)this.lines.getBottommostChildsBottom();
        this.lines.setPreferredSize(width, height);
        int characterWidth = metrics.charWidth('e');
        this.indexOfLastPrintParsed = output.getNumberOfEvents() - 1;
    }

    public WhylineUI getWhylineUI() {
        return this.whylineUI;
    }

    public boolean canUpdateSelection() {
        return this.whylineUI.canAskOutputQuestions() && !this.whylineUI.userIsAskingQuestion() && this.whylineUI.getVisualizationUIVisible() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToTime(int time) {
        IOHistory<IOEvent> iOHistory = this.whylineUI.getTrace().getIOHistory();
        synchronized (iOHistory) {
            if (this.indexOfLastPrintParsed < 0 || this.whylineUI.getTrace().getIOHistory().getEventAtIndex(this.indexOfLastPrintParsed).getEventID() < time) {
                this.parseOutputHistory();
            }
        }
        View rightmostVisibleEvent = null;
        View lastVisibleEvent = null;
        for (View event : this.lines.getChildren()) {
            boolean shouldBeHidden = ((TextualOutputEventView)event).getEvent().getEventID() > time;
            ((TextualOutputEventView)event).setHidden(shouldBeHidden);
            if (shouldBeHidden) continue;
            lastVisibleEvent = event;
            if (rightmostVisibleEvent != null && !(rightmostVisibleEvent.getLocalRight() < event.getLocalRight())) continue;
            rightmostVisibleEvent = event;
        }
        this.lines.setPreferredSize(rightmostVisibleEvent == null ? 0.0 : rightmostVisibleEvent.getLocalRight(), lastVisibleEvent == null ? 0.0 : lastVisibleEvent.getLocalBottom());
        if (lastVisibleEvent != null) {
            this.getViewport().scrollRectToVisible(lastVisibleEvent.getGlobalBoundaries());
        }
    }

    @Override
    public int getVerticalScrollIncrement() {
        return this.getGraphics().getFontMetrics(UI.getFixedFont()).getHeight();
    }

    @Override
    public int getHorizontalScrollIncrement() {
        return this.getGraphics().getFontMetrics(UI.getFixedFont()).charWidth(' ');
    }

    @Override
    public void inputTimeChanged(int time) {
        this.updateToTime(time);
    }

    @Override
    public void outputTimeChanged(int time) {
    }

    @Override
    public void handleNewSelection(TextualOutputEventView selection, boolean scroll, String ui) {
        this.repaint();
    }
}

