/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.io;

import edu.cmu.hcii.whyline.bytecode.AbstractReturn;
import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.Definition;
import edu.cmu.hcii.whyline.bytecode.GETFIELD;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.PUTFIELD;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.Use;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.util.IntegerVector;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BreakpointDebugger {
    private final Trace trace;
    private final WhylineUI whylineUI;
    private int currentEventID = -1;
    private Line currentLine;
    private boolean inPauseMode = false;
    private final Map<Line, Instruction> breakpoints = new HashMap<Line, Instruction>();
    private final Map<Token, Print> prints = new HashMap<Token, Print>();
    private final TIntObjectHashMap<Set<Print>> printsByEventID = new TIntObjectHashMap();
    public final List<Output> printStatementOutput = new Vector<Output>();

    public BreakpointDebugger(WhylineUI whylineUI) {
        this.whylineUI = whylineUI;
        this.trace = whylineUI.getTrace();
    }

    public Line getCurrentLine() {
        return this.currentLine;
    }

    public int getCurrentEventID() {
        return this.currentEventID;
    }

    public boolean isRunning() {
        return this.currentEventID >= 0;
    }

    public List<Output> getPrintStatementOutput() {
        return this.printStatementOutput;
    }

    public void setCurrentEventID(int newEventID) {
        this.addPrintsBetween(this.currentEventID, this.currentEventID >= 0 && newEventID < 0 ? this.trace.getNumberOfEvents() - 1 : newEventID);
        this.currentEventID = newEventID;
        if (this.currentEventID < 0) {
            this.stop();
            JOptionPane.showMessageDialog(this.whylineUI, "The program is done executing.");
        } else {
            Instruction inst = this.trace.getInstruction(this.currentEventID);
            this.currentLine = inst == null ? null : inst.getLine();
            this.whylineUI.getActions().runToBreakpoint.setEnabled(true);
            this.setBreakpointButtonsEnabled(true);
            this.whylineUI.arrangeForAsking();
        }
        this.whylineUI.setInputTime(this.currentEventID);
        this.whylineUI.selectEvent(this.currentEventID, true, "into");
    }

    public void stop() {
        this.currentEventID = -1;
        this.whylineUI.getActions().runToBreakpoint.setEnabled(true);
        this.setBreakpointButtonsEnabled(false);
        this.whylineUI.arrangeForAsking();
        this.whylineUI.setInputTime(this.whylineUI.getTrace().getNumberOfEvents() - 1);
        this.whylineUI.getObjectsUI().removeAllObjects();
        this.whylineUI.setBreakpointDebuggerState("stopped", false);
    }

    public void setBreakpointButtonsEnabled(boolean enabled) {
        this.whylineUI.getActions().stepOut.setEnabled(enabled);
        this.whylineUI.getActions().stepInto.setEnabled(enabled);
        this.whylineUI.getActions().stepOver.setEnabled(enabled);
        this.whylineUI.getActions().stop.setEnabled(enabled);
    }

    public void runToBreakpoint() {
        if (this.inPauseMode) {
            this.inPauseMode = false;
            this.setPauseMode(false);
            this.setCurrentEventID(this.whylineUI.getInputEventID());
        } else {
            this.whylineUI.setBreakpointDebuggerState("running", true);
            if (!this.isRunning()) {
                this.whylineUI.setInputTime(0);
                this.setCurrentEventID(0);
                this.printStatementOutput.clear();
            }
            this.whylineUI.arrangeForPlayback();
            this.setBreakpointButtonsEnabled(false);
            int nextEventID = -1;
            for (Instruction inst : this.breakpoints.values()) {
                int eventID = this.currentEventID;
                while ((eventID = this.trace.findExecutionOfInstructionAfter(inst, eventID)) >= 0 && inst instanceof Invoke && (this.trace.getKind((int)eventID).isArtificial || this.trace.getKind((int)eventID).isValueProduced)) {
                }
                if (eventID < 0 || nextEventID >= 0 && eventID >= nextEventID) continue;
                nextEventID = eventID;
            }
            this.setCurrentEventID(nextEventID);
        }
        if (this.currentEventID > 0) {
            this.whylineUI.setBreakpointDebuggerState("paused", true);
        }
    }

    private void addPrintsBetween(int currentID, int nextID) {
        IntegerVector eventIDsToPrint = new IntegerVector(10);
        for (Print print : this.prints.values()) {
            int beginID = currentID;
            while (beginID >= 0 && beginID <= nextID) {
                Instruction inst = print.instruction;
                if (inst == null) continue;
                int eventID = this.trace.findExecutionOfInstructionAfter(inst, beginID);
                if (eventID >= 0 && eventID <= nextID) {
                    beginID = eventID;
                    eventIDsToPrint.append(eventID);
                    continue;
                }
                beginID = -1;
            }
        }
        eventIDsToPrint.sortInAscendingOrder();
        int i = 0;
        while (i < eventIDsToPrint.size()) {
            int eventID = eventIDsToPrint.get(i);
            this.printStatementOutput.add(new Output(eventID));
            ++i;
        }
    }

    public Line getNearestBreakpointLine(Line line) {
        Instruction inst = this.gettInstrumentedInstructionAfter(line);
        return inst == null ? null : inst.getLine();
    }

    public boolean toggleBreakpoint(Line line) {
        boolean on = this.breakpoints.containsKey(line = this.getNearestBreakpointLine(line));
        if (on) {
            this.breakpoints.remove(line);
        } else {
            Instruction inst = this.gettInstrumentedInstructionAfter(line);
            if (inst != null) {
                this.breakpoints.put(line, inst);
            }
        }
        this.whylineUI.getLinesUI().updateBreakpointLines(line);
        return !on;
    }

    public List<Line> getLinesWithBreakpointsOrPrints() {
        HashSet<Line> lines = new HashSet<Line>();
        lines.addAll((Collection)this.breakpoints.keySet());
        for (Token t : this.prints.keySet()) {
            lines.add(t.getLine());
        }
        return new ArrayList<Line>(lines);
    }

    public boolean hasPrint(Token t) {
        return this.prints.containsKey(t);
    }

    public boolean hasBreakpoint(Line i) {
        return this.breakpoints.containsKey(i);
    }

    public void addPrint(Token token, String message) {
        this.prints.put(token, new Print(token, message));
        this.whylineUI.getLinesUI().updateBreakpointLines(token.getLine());
    }

    public void removePrint(Token token) {
        this.prints.remove(token);
    }

    public void clearBreakpointsAndPrints() {
        this.breakpoints.clear();
        this.prints.clear();
    }

    public void stepInto() {
        if (!this.isRunning()) {
            return;
        }
        Line previousLine = this.currentLine;
        do {
            this.setCurrentEventID(this.trace.getNextEventIDInThread(this.currentEventID));
        } while (this.isRunning() && this.currentLine != null && this.currentLine == previousLine && this.trace.getKind(this.currentEventID) != EventKind.START_METHOD);
    }

    public void stepOver() {
        if (!this.isRunning()) {
            return;
        }
        Line previousLine = this.currentLine;
        do {
            int nextMethodID;
            if ((nextMethodID = this.trace.getNextEventIDInMethod(this.currentEventID)) < 0) {
                nextMethodID = this.trace.getNextEventIDInThread(this.currentEventID);
            }
            this.setCurrentEventID(nextMethodID);
        } while (this.isRunning() && this.currentLine != null && this.currentLine == previousLine);
    }

    public void stepOut() {
        if (!this.isRunning()) {
            return;
        }
        Line previousLine = this.currentLine;
        int startID = this.trace.getStartID(this.currentEventID);
        int returnID = startID >= 0 ? this.trace.getStartIDsReturnOrCatchID(startID) : -1;
        int nextID = returnID >= 0 ? this.trace.getNextEventIDInThread(returnID) : -1;
        this.setCurrentEventID(nextID);
        while (this.currentLine != null && this.isRunning() && this.currentLine == previousLine) {
            this.setCurrentEventID(this.trace.getNextEventIDInThread(this.currentEventID));
        }
    }

    private Instruction gettInstrumentedInstructionAfter(Line line) {
        try {
            while (line != null && line.getFirstInstruction() == null) {
                line = line.getLineAfter();
            }
        }
        catch (Exception e) {
            return null;
        }
        if (line == null) {
            return null;
        }
        Instruction inst = line.getFirstInstruction();
        while (!(inst == null || inst instanceof Definition || inst instanceof AbstractReturn || inst instanceof Invoke || inst instanceof Branch)) {
            inst = inst.getNext();
        }
        return inst;
    }

    public boolean canPrint(Token token) {
        Instruction code = token.getFile().getInstructionFor(token);
        if (code == null) {
            return false;
        }
        return code instanceof GetLocal || code instanceof SetLocal || code instanceof GETFIELD || code instanceof PUTFIELD || code instanceof Invoke;
    }

    public void setPauseMode(boolean inPauseMode) {
        this.inPauseMode = inPauseMode;
        this.whylineUI.setBreakpointPauseMode(inPauseMode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Output
    implements Comparable<Output> {
        public final String output;
        public final int eventID;

        public Output(int eventID) {
            this.eventID = eventID;
            Instruction code = BreakpointDebugger.this.trace.getInstruction(eventID);
            this.output = code instanceof Use ? String.valueOf(((Use)code).getAssociatedName()) + " = " + BreakpointDebugger.this.trace.getDescription(eventID) : (code instanceof Definition ? String.valueOf(((Definition)code).getAssociatedName()) + " = " + BreakpointDebugger.this.trace.getDefinitionValueSet(eventID).getDisplayName(false) : (code instanceof Invoke ? (((BreakpointDebugger)BreakpointDebugger.this).trace.getKind((int)eventID).isValueProduced ? String.valueOf(((Invoke)code).getJavaMethodName()) + "() returned " + BreakpointDebugger.this.trace.getDescription(eventID) : null) : null));
        }

        @Override
        public int compareTo(Output o) {
            return this.eventID - o.eventID;
        }
    }

    private class Print {
        private final Token token;
        private final Instruction instruction;
        private final String print;

        public Print(Token token, String print) {
            this.token = token;
            this.print = print;
            this.instruction = token.getFile().getInstructionFor(token);
            assert (this.instruction != null);
        }
    }
}

