/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.io;

import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.UserTimeListener;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineControlBorder;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.ui.components.WhylineScrollPane;
import edu.cmu.hcii.whyline.ui.io.BreakpointDebugger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class BreakpointConsoleUI
extends WhylinePanel
implements UserTimeListener {
    private final WhylineUI whylineUI;
    private final JTextPane console;
    private int lastTimeUpdatedTo;
    private int debuggingPrintIndex;
    private final MutableAttributeSet debugAttributes;
    private final MutableAttributeSet regularAttributes;

    public BreakpointConsoleUI(WhylineUI whylineUI) {
        this.whylineUI = whylineUI;
        this.setBorder(new WhylineControlBorder());
        this.console = new JTextPane(){

            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.console.setBackground(UI.getConsoleBackColor());
        this.console.setForeground(UI.getConsoleTextColor());
        this.console.setFont(UI.getFixedFont());
        this.console.setEditable(false);
        this.console.setBackground(UI.getControlBackColor());
        this.console.setOpaque(true);
        this.debugAttributes = new SimpleAttributeSet();
        StyleConstants.setItalic(this.debugAttributes, false);
        StyleConstants.setForeground(this.debugAttributes, UI.getConsoleTextColor());
        this.regularAttributes = new SimpleAttributeSet();
        StyleConstants.setItalic(this.regularAttributes, false);
        StyleConstants.setForeground(this.regularAttributes, UI.getConsoleTextColor());
        this.setLayout(new BorderLayout(0, UI.getPanelPadding()));
        this.add((Component)new WhylineScrollPane(this.console), "Center");
        this.setPreferredSize(new Dimension(0, UI.getDefaultInfoPaneHeight(whylineUI)));
        this.clear();
    }

    public void clear() {
        this.console.setText("");
        this.lastTimeUpdatedTo = -1;
        this.debuggingPrintIndex = 0;
    }

    public void print(String text, boolean debug) {
        try {
            this.console.getStyledDocument().insertString(this.console.getStyledDocument().getLength(), text, debug ? this.debugAttributes : this.regularAttributes);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void inputTimeChanged(int eventID) {
        if (eventID != 0) {
            this.clear();
        }
        List<BreakpointDebugger.Output> debuggingPrints = this.whylineUI.getBreakpointDebugger().getPrintStatementOutput();
        for (BreakpointDebugger.Output print : debuggingPrints) {
            if (print.eventID >= eventID || print.output == null) continue;
            this.print(String.valueOf(print.output) + "\n", true);
        }
        this.lastTimeUpdatedTo = eventID;
    }

    public void outputTimeChanged(int time) {
    }
}

