/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.events;

import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.events.AbstractUIEvent;
import edu.cmu.hcii.whyline.ui.events.ClassNavigation;
import edu.cmu.hcii.whyline.ui.events.EventNavigation;
import edu.cmu.hcii.whyline.ui.events.ExplanationNavigation;
import edu.cmu.hcii.whyline.ui.events.FileNavigation;
import edu.cmu.hcii.whyline.ui.events.InstructionNavigation;
import edu.cmu.hcii.whyline.ui.events.LineHover;
import edu.cmu.hcii.whyline.ui.events.LineNavigation;
import edu.cmu.hcii.whyline.ui.events.MethodHover;
import edu.cmu.hcii.whyline.ui.events.MethodNavigation;
import edu.cmu.hcii.whyline.ui.events.ModeSet;
import edu.cmu.hcii.whyline.ui.events.NoLineHover;
import edu.cmu.hcii.whyline.ui.events.Note;
import edu.cmu.hcii.whyline.ui.events.QuestionSelected;
import edu.cmu.hcii.whyline.ui.events.UnexecutedInstructionNavigation;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UIEventKind {
    NOTE("note"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new Note(trace, args);
        }
    }
    ,
    MODE("mode"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new ModeSet(trace, args);
        }
    }
    ,
    CLASS_NAVIGATION("class"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new ClassNavigation(trace, args);
        }
    }
    ,
    EVENT_NAVIGATION("event"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new EventNavigation(trace, args);
        }
    }
    ,
    EXPLANATION_NAVIGATION("explanation"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new ExplanationNavigation(trace, args);
        }
    }
    ,
    FILE_NAVIGATION("file"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new FileNavigation(trace, args);
        }
    }
    ,
    INSTRUCTION_NAVIGATION("instruction"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new InstructionNavigation(trace, args);
        }
    }
    ,
    UNEXECUTED_NAVIGATION("unexecuted"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new UnexecutedInstructionNavigation(trace, args);
        }
    }
    ,
    LINE_NAVIGATION("line"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new LineNavigation(trace, args);
        }
    }
    ,
    METHOD_NAVIGATION("method"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new MethodNavigation(trace, args);
        }
    }
    ,
    LINE_HOVER("linehover"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new LineHover(trace, args);
        }
    }
    ,
    NO_LINE_HOVER("nolinehover"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new NoLineHover(trace, args);
        }
    }
    ,
    METHOD_HOVER("methodhover"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new MethodHover(trace, args);
        }
    }
    ,
    QUESTION_SELECTED("questionselected"){

        @Override
        public AbstractUIEvent<?> create(Trace trace, String[] args) {
            return new QuestionSelected(trace, args);
        }
    };

    private final String name;
    private static HashMap<String, UIEventKind> kindsByShortName;

    static {
        kindsByShortName = null;
    }

    private UIEventKind(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.name;
    }

    public abstract AbstractUIEvent<?> create(Trace var1, String[] var2);

    public static UIEventKind fromType(String type) {
        if (kindsByShortName == null) {
            kindsByShortName = new HashMap();
            UIEventKind[] uIEventKindArray = UIEventKind.values();
            int n = uIEventKindArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIEventKind kind = uIEventKindArray[n2];
                kindsByShortName.put(kind.getShortName(), kind);
                ++n2;
            }
        }
        return kindsByShortName.get(type);
    }

    /* synthetic */ UIEventKind(String string, int n, String string2, UIEventKind uIEventKind) {
        this(string2);
    }
}

