/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.events;

import edu.cmu.hcii.whyline.trace.Serializer;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.events.UIEventKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUIEvent<T> {
    protected static final int FIRST_ARGUMENT_INDEX = 3;
    protected final Trace trace;
    protected final long time;
    protected final T entity;
    protected final String ui;
    protected final boolean userInitiated;

    public AbstractUIEvent(T entity, String ui, boolean userInitiated) {
        this.trace = null;
        this.entity = entity;
        this.time = System.currentTimeMillis();
        this.ui = ui;
        this.userInitiated = userInitiated;
    }

    public AbstractUIEvent(Trace trace, String[] args) {
        this.trace = trace;
        this.time = Long.parseLong(args[1]);
        this.ui = args[2];
        this.entity = this.parseEntity(args);
        this.userInitiated = false;
    }

    protected abstract T parseEntity(String[] var1);

    public long getTime() {
        return this.time;
    }

    public T getEntity() {
        return this.entity;
    }

    public boolean wasUserInitiated() {
        return this.userInitiated;
    }

    protected abstract String getParsableStringArguments();

    protected abstract UIEventKind getParsableStringKind();

    public final String getParsableString() {
        return Serializer.listToString(this.getParsableStringKind().getShortName(), Long.toString(this.time), this.ui, this.getParsableStringArguments());
    }

    public String getUI() {
        return this.ui;
    }
}

