/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.components;

import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.components.WhylineLabel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;

public class WhylineProgressBar
extends WhylineLabel {
    private double value = 1.0;

    public WhylineProgressBar() {
        super("");
    }

    public void setValue(double value) {
        this.value = value;
        this.repaint();
    }

    public void setNote(String note) {
        this.setText("<html>" + note);
    }

    public void removeNote() {
        this.setText("");
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean showingProgress = this.value != 0.0;
        int round = UI.getRoundedness();
        Insets insets = this.getInsets();
        int left = 0;
        int top = 0;
        int width = this.getWidth() - 1;
        int height = this.getHeight() - 1;
        g2.setColor(UI.getControlCenterColor());
        g2.fillRoundRect(left, top, width, height, round, round);
        g2.setColor(UI.getHighlightColor());
        int filledWidth = (int)((double)width * this.value);
        g2.fillRoundRect(left, top + 1, filledWidth, height, round, round);
        int widthOfRect = round / 3 + 1;
        int leftOfRect = Math.max(0, filledWidth - widthOfRect);
        if (leftOfRect > widthOfRect) {
            g2.fillRect(leftOfRect, top + 1, widthOfRect, height - 2);
        }
        g2.setColor(UI.getControlBorderColor());
        g2.drawRoundRect(left, top, width, height, round, round);
        super.paintComponent(g);
    }
}

