/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.components;

import edu.cmu.hcii.whyline.ui.UI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class WhylineButton
extends JButton {
    public WhylineButton(Icon icon, Action action, String tooltip) {
        this(action, tooltip);
        this.setIcon(icon);
        this.setText(null);
    }

    public WhylineButton(String text, Action action, String tooltip) {
        this(action, tooltip);
        this.setText(text);
    }

    public WhylineButton(String text, Action action, Dimension fixedSize, Font font, String tooltip) {
        this(action, tooltip);
        this.setText(text);
        this.setMaximumSize(fixedSize);
        this.setFont(font);
    }

    public WhylineButton(Action action, Dimension fixedSize, Font font, String tooltip) {
        this(action, tooltip);
        this.setMaximumSize(fixedSize);
        this.setFont(font);
    }

    public WhylineButton(String text, float fontsize, Action action, String tooltip) {
        this(action, tooltip);
        this.setFont(UI.getMediumFont().deriveFont(fontsize));
        this.setText(text);
    }

    public WhylineButton(Action action, Font font, String tooltip) {
        this(action, tooltip);
        this.setFont(font);
    }

    public WhylineButton(Action abstractAction, String tooltip) {
        super(abstractAction);
        this.setFont(UI.getMediumFont());
        this.setFocusable(false);
        this.setOpaque(false);
        this.setToolTipText(tooltip);
        this.setContentAreaFilled(true);
        this.setRolloverEnabled(true);
        this.setModel(new DefaultButtonModel(){

            public boolean isRollover() {
                return true;
            }
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setForeground((Color)UIManager.get(enabled ? "Button.foreground" : "Button.disabledText"));
    }
}

