/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.components;

import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.ui.components.WhylineSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;

public class MultipleSplitPane
extends WhylinePanel {
    private final int orientation;
    private JComponent first;
    private JComponent[] rest;
    private WhylineSplitPane[] splits;
    private JComponent componentToGiveResizeWeight = null;

    public MultipleSplitPane(int orientation, JComponent first, JComponent ... rest) {
        super(new BorderLayout());
        this.orientation = orientation;
        this.reset(first, rest);
    }

    public void resetWith(JComponent first, JComponent ... rest) {
        this.reset(first, rest);
    }

    private void reset(JComponent first, JComponent[] rest) {
        this.removeAll();
        this.first = first;
        this.rest = rest;
        this.splits = new WhylineSplitPane[rest.length];
        if (rest.length == 0) {
            this.add((Component)first, "Center");
        } else {
            this.splits[0] = this.make(first, this.make(0));
            this.add((Component)this.splits[0], "Center");
        }
        this.revalidate();
    }

    public void giveResizeWeightTo(JComponent c) {
        this.componentToGiveResizeWeight = c;
        this.updateResizeWeights();
    }

    private void updateResizeWeights() {
        WhylineSplitPane[] whylineSplitPaneArray = this.splits;
        int n = this.splits.length;
        int n2 = 0;
        while (n2 < n) {
            WhylineSplitPane split = whylineSplitPaneArray[n2];
            if (this.componentToGiveResizeWeight == null) {
                split.setResizeWeight(0.5);
            } else if (split.getLeftComponent() == this.componentToGiveResizeWeight) {
                split.setResizeWeight(1.0);
            } else {
                split.setResizeWeight(0.0);
            }
            ++n2;
        }
    }

    private JComponent make(int index) {
        if (index == this.rest.length - 1) {
            return this.rest[index];
        }
        this.splits[index + 1] = this.make(this.rest[index], index + 1 == this.rest.length - 1 ? this.rest[index + 1] : this.make(index + 1));
        return this.splits[index + 1];
    }

    private WhylineSplitPane make(JComponent one, JComponent two) {
        WhylineSplitPane split = new WhylineSplitPane(this.orientation, one, two);
        split.setResizeWeight(0.5);
        split.setDividerLocation(0.5);
        return split;
    }

    public void setDividers() {
        WhylineSplitPane[] whylineSplitPaneArray = this.splits;
        int n = this.splits.length;
        int n2 = 0;
        while (n2 < n) {
            WhylineSplitPane split = whylineSplitPaneArray[n2];
            split.setDividerLocation(0.5);
            ++n2;
        }
        this.revalidate();
    }
}

