/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.arrows;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.arrows.ArrowView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import java.awt.Color;
import java.awt.Stroke;

public abstract class CausalArrowView
extends ArrowView {
    protected final Explanation value;
    protected final Explanation from;
    protected final Explanation to;
    protected final Relationship relationship;
    protected static final int END_POINT_RADIUS = 3;
    protected static final int SELECTION_THRESHOLD = 5;
    protected final int fromEventID;
    final int toEventID;
    protected final Instruction fromInstruction;
    protected final Instruction toInstruction;
    protected final String label;

    public CausalArrowView(WhylineUI whylineUI, Explanation value, Explanation from, Explanation to, Relationship relationship, int number) {
        super(whylineUI, number);
        String note;
        String event;
        char shortcut;
        this.value = value;
        this.from = from;
        this.to = to;
        this.relationship = relationship;
        int fromID = from.getEventID();
        int toID = to.getEventID();
        this.fromInstruction = whylineUI.getTrace().getInstruction(fromID);
        this.toInstruction = whylineUI.getTrace().getInstruction(toID);
        this.fromEventID = fromID;
        this.toEventID = toID;
        Trace trace = whylineUI.getTrace();
        StringBuilder builder = new StringBuilder();
        if (relationship == Relationship.CONTROL) {
            shortcut = '\u21e7';
            event = "this execute";
            note = null;
        } else {
            String valueDescription;
            Value val;
            String action;
            EventKind kind = trace.getKind(value.getEventID());
            int valueID = value.getEventID();
            shortcut = Visualization.getCharacterShortcutForNumber(this.dependencyNumber);
            String name = trace.getNameAssociatedWithEvent(valueID);
            if (name == null) {
                name = "this expression";
            }
            if (kind == EventKind.SETLOCAL) {
                action = "=";
                val = trace.getDefinitionValueSet(valueID);
                valueDescription = val.getDisplayName(false);
            } else if (kind == EventKind.RETURN) {
                action = "return";
                valueDescription = trace.getReturnValueReturned(valueID).getDisplayName(false);
            } else if (kind.isArgument) {
                action = "=";
                valueDescription = trace.getArgumentValueDescription(valueID);
            } else if (kind.isValueProduced) {
                action = "=";
                valueDescription = trace.getDescription(valueID);
            } else if (kind.isDefinition) {
                action = "=";
                val = trace.getDefinitionValueSet(valueID);
                valueDescription = val == null ? "?" : val.getDisplayName(false);
            } else if (kind == EventKind.INVOKE_SPECIAL) {
                action = "instantiate";
                valueDescription = "";
            } else if (kind.isInvocation) {
                action = "return";
                valueDescription = "";
            } else {
                action = "";
                valueDescription = "-";
            }
            boolean toSource = value != from;
            event = String.valueOf(name) + " " + action + " " + valueDescription;
            note = toSource ? "(source)" : "(producer)";
        }
        builder.append("(");
        builder.append(shortcut);
        builder.append(") ");
        builder.append("why did ");
        builder.append(event);
        builder.append("?");
        if (note != null) {
            builder.append(" ");
            builder.append(note);
        }
        this.label = builder.toString();
    }

    protected void clicked() {
        if (this.dependencyNumber == 0) {
            this.whylineUI.getActions().goToPreviousBlock.execute();
        } else {
            Visualization viz;
            viz.goToDataDependencyNumber(this.dependencyNumber, !(viz = this.whylineUI.getVisualizationUIVisible().getVisualization()).isMetaDown());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Relationship {
        CONTROL{

            public Color getColor(boolean selected) {
                return UI.CONTROL_COLOR;
            }

            public Stroke getStroke(boolean selected) {
                return selected ? UI.SELECTED_STROKE : UI.UNSELECTED_STROKE;
            }
        }
        ,
        DATA{

            public Color getColor(boolean selected) {
                return UI.DATA_COLOR;
            }

            public Stroke getStroke(boolean selected) {
                return selected ? UI.SELECTED_DASHED_STROKE : UI.UNSELECTED_DASHED_STROKE;
            }
        };


        public abstract Color getColor(boolean var1);

        public abstract Stroke getStroke(boolean var1);
    }
}

