/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.annotations;

import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.annotations.AnnotatedEventExplanationUI;
import edu.cmu.hcii.whyline.ui.annotations.NarrationTextArea;
import edu.cmu.hcii.whyline.ui.components.WhylineControlBorder;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.ui.components.WhylineScrollPane;
import edu.cmu.hcii.whyline.ui.components.WhylineTitleLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.BoxLayout;

public final class NarrativeUI
extends WhylinePanel {
    private final WhylineUI whylineUI;
    private final WhylinePanel entries;
    private final Hashtable<Explanation, AnnotatedEventExplanationUI> viewsByExplanation = new Hashtable();

    public NarrativeUI(WhylineUI whylineUI) {
        super(new BorderLayout());
        this.whylineUI = whylineUI;
        this.setPreferredSize(new Dimension(UI.getDefaultInfoPaneWidth(whylineUI), UI.getDefaultInfoPaneHeight(whylineUI)));
        this.entries = new WhylinePanel();
        this.entries.setLayout(new BoxLayout(this.entries, 1));
        this.entries.setBackground(UI.getControlBackColor());
        WhylineScrollPane scroller = new WhylineScrollPane(this.entries, 20, 31);
        this.setBorder(new WhylineControlBorder());
        this.setBackground(UI.getControlBackColor());
        this.setOpaque(true);
        this.add((Component)new WhylineTitleLabel("notes"), "North");
        this.add((Component)scroller, "Center");
        if (whylineUI.getMode() == WhylineUI.Mode.BREAKPOINT) {
            this.entries.add(new NarrationTextArea(whylineUI){

                public String getDescriptionOfContext() {
                    int event = NarrativeUI.this.whylineUI.getBreakpointDebugger().getCurrentEventID();
                    if (event < 0) {
                        return "none";
                    }
                    return "" + event;
                }
            });
        }
    }

    public void addEntry(Explanation explanation) {
        AnnotatedEventExplanationUI viewToShow = null;
        if (this.whylineUI.getTrace().addNarrativeExplanation(explanation)) {
            viewToShow = new AnnotatedEventExplanationUI(this, explanation);
            this.entries.add(viewToShow);
            this.viewsByExplanation.put(explanation, viewToShow);
            this.validate();
            this.repaint();
        } else {
            viewToShow = this.viewsByExplanation.get(explanation);
        }
        viewToShow.makeVisible();
    }

    public WhylineUI getWhylineUI() {
        return this.whylineUI;
    }
}

