/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.annotations;

import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.annotations.NarrationTextArea;
import edu.cmu.hcii.whyline.ui.annotations.NarrativeUI;
import edu.cmu.hcii.whyline.ui.components.WhylineLabel;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class AnnotatedEventExplanationUI
extends WhylinePanel {
    private final Explanation explanation;
    private final NarrativeUI narrativeUI;
    private final JTextArea text;

    public AnnotatedEventExplanationUI(NarrativeUI narrativeUI, Explanation explanation) {
        this.narrativeUI = narrativeUI;
        this.explanation = explanation;
        this.setLayout(new FlowLayout(0));
        this.setBackground(UI.getControlBackColor());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.text = new NarrationTextArea(narrativeUI.getWhylineUI()){

            public String getDescriptionOfContext() {
                return Integer.toString(AnnotatedEventExplanationUI.this.explanation.getEventID());
            }
        };
        WhylineLabel label = new WhylineLabel(narrativeUI.getWhylineUI().getTrace().getDescription(explanation.getEventID()));
        label.setPreferredSize(new Dimension(UI.getDefaultInfoPaneWidth(narrativeUI.getWhylineUI()) / 3, 25));
        this.add(label);
        this.add(this.text);
    }

    public void makeVisible() {
        this.scrollRectToVisible(this.getBounds());
        this.text.requestFocusInWindow();
    }
}

