/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.trace.nodes.ClassNode;
import edu.cmu.hcii.whyline.trace.nodes.FileNode;
import edu.cmu.hcii.whyline.trace.nodes.MethodNode;
import edu.cmu.hcii.whyline.trace.nodes.Node;
import edu.cmu.hcii.whyline.trace.nodes.PackageNode;
import edu.cmu.hcii.whyline.ui.SearchFieldUI;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.HeadlinedTreePanel;
import edu.cmu.hcii.whyline.ui.components.WhylineToolbar;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineUI
extends HeadlinedTreePanel<PackageNode> {
    private final Map<String, PackageNode> packages = new HashMap<String, PackageNode>();
    private final Map<JavaSourceFile, FileNode> source = new HashMap<JavaSourceFile, FileNode>();
    private final Map<MethodInfo, MethodNode> methods = new HashMap<MethodInfo, MethodNode>();
    private final Map<Classfile, ClassNode> classes = new HashMap<Classfile, ClassNode>();

    public OutlineUI(WhylineUI whylineUI) {
        super("source", whylineUI);
        WhylineToolbar searchToolbar = new WhylineToolbar(0);
        searchToolbar.add(new SearchFieldUI(whylineUI));
        this.add((Component)searchToolbar, "South");
        this.setMinimumSize(new Dimension(UI.getDefaultInfoPaneWidth(whylineUI), 0));
    }

    public void showFile(FileInterface file) {
        if (!(file instanceof JavaSourceFile)) {
            return;
        }
        PackageNode p = this.packages.get(((JavaSourceFile)file).getPackageName());
        FileNode f = this.source.get(file);
        if (p == null || f == null) {
            this.clearSelection();
            return;
        }
        this.show(new TreePath(new Object[]{this.getRoot(), p, f}), true);
    }

    public void showMethod(MethodInfo method) {
        if (method.getClassfile().getSourceFile() == null) {
            return;
        }
        PackageNode p = this.packages.get(method.getClassfile().getSourceFile().getPackageName());
        FileNode f = this.source.get(method.getClassfile().getSourceFile());
        ClassNode c = this.classes.get(method.getClassfile());
        MethodNode m = this.methods.get(method);
        if (p == null || f == null || c == null || m == null) {
            this.clearSelection();
            return;
        }
        this.show(new TreePath(new Object[]{this.getRoot(), p, f, c, m}), true);
    }

    public void addFamiliarSource() {
        for (JavaSourceFile file : this.whylineUI.getTrace().getAllSourceFiles()) {
            this.addSourceWithoutUpdating(file);
        }
        this.updateTree();
    }

    public void addSource(JavaSourceFile file) {
        this.addSourceWithoutUpdating(file);
        this.updateTree();
    }

    private void addSourceWithoutUpdating(JavaSourceFile file) {
        if (file == null) {
            return;
        }
        if (this.source.containsKey(file)) {
            return;
        }
        String packageName = file.getPackageName();
        PackageNode pack = this.packages.get(packageName);
        if (pack == null) {
            pack = new PackageNode(packageName);
            this.packages.put(packageName, pack);
            this.getRoot().addChild(pack);
        }
        FileNode f = new FileNode(file);
        this.source.put(file, f);
        pack.addChild(f);
        for (Classfile c : file.getClassfiles()) {
            ClassNode clazz = new ClassNode(c);
            this.classes.put(c, clazz);
            f.addChild(clazz);
            for (MethodInfo method : c.getDeclaredMethods()) {
                MethodNode m = new MethodNode(method);
                clazz.addChild(m);
                this.methods.put(method, m);
            }
        }
    }

    @Override
    protected void handleSelection() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return;
        }
        Object selection = path.getLastPathComponent();
        if (selection instanceof FileNode) {
            this.whylineUI.selectFile(((FileNode)selection).file, true, "outline");
        } else if (selection instanceof ClassNode) {
            this.whylineUI.selectClass(((ClassNode)selection).classfile, true, "outline");
        } else if (selection instanceof MethodNode) {
            this.whylineUI.selectMethod(((MethodNode)selection).method, true, "outline");
        }
    }

    @Override
    protected void handleExpansion() {
    }

    protected boolean isLeaf(Node<?> node) {
        return node instanceof MethodNode;
    }
}

