/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineTableUI
extends JTable {
    private final WhylineUI whylineUI;
    private List<Line> lines;
    private final String uiString;
    private final boolean addSelectionsToNavigationHistory;
    private boolean programmaticSelection = false;
    private Line lastSelection;
    private final AbstractTableModel model = new DefaultTableModel(){

        public int getColumnCount() {
            return Column.values().length;
        }

        public int getRowCount() {
            return LineTableUI.this.lines == null ? 0 : LineTableUI.this.lines.size();
        }

        public Object getValueAt(int row, int column) {
            if (LineTableUI.this.lines == null) {
                return null;
            }
            Line line = (Line)LineTableUI.this.lines.get(row);
            if (column == Column.NUMBER.ordinal()) {
                return line.getLineNumber().getNumber();
            }
            if (column == Column.FILE.ordinal()) {
                return line.getFile().getShortFileName();
            }
            if (column == Column.TEXT.ordinal()) {
                return "<html><b>" + line.getLineText() + "</b>";
            }
            return null;
        }

        public String getColumnName(int col) {
            return Column.values()[col].name().toLowerCase();
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    };

    public LineTableUI(WhylineUI whylineUI, List<Line> lines, String uiString, boolean addSelectionsToNavigationHistory) {
        this.uiString = uiString;
        this.addSelectionsToNavigationHistory = addSelectionsToNavigationHistory;
        this.setModel(this.model);
        this.setBackground(null);
        this.setOpaque(false);
        this.setSelectionMode(0);
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setShowGrid(false);
        JTableHeader header = this.getTableHeader();
        header.setFont(UI.getMediumFont().deriveFont(1));
        header.setBackground(UI.getPanelDarkColor());
        header.setBorder(new LineBorder(UI.getControlBorderColor()));
        int i = 0;
        while (i < Column.values().length) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setHeaderRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setHorizontalAlignment(2);
                    this.setFont(UI.getMediumFont().deriveFont(1));
                    this.setBackground(UI.getPanelDarkColor());
                    return c;
                }
            });
            ++i;
        }
        this.whylineUI = whylineUI;
        this.lines = lines;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int row = LineTableUI.this.getSelectedRow();
                LineTableUI.this.clearSelection();
                LineTableUI.this.addRowSelectionInterval(row, row);
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                LineTableUI.this.lastSelection = null;
                if (LineTableUI.this.programmaticSelection) {
                    LineTableUI.this.programmaticSelection = false;
                } else {
                    int row = LineTableUI.this.getSelectedRow();
                    if (row >= 0 && row < LineTableUI.this.lines.size()) {
                        LineTableUI.this.lastSelection = (Line)LineTableUI.this.lines.get(row);
                        LineTableUI.this.whylineUI.selectLine(LineTableUI.this.lastSelection, LineTableUI.this.addSelectionsToNavigationHistory, LineTableUI.this.uiString);
                    }
                }
            }
        });
        final Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){
            int count = 0;

            public void run() {
                Container parent = LineTableUI.this.getParent();
                if (parent != null) {
                    LineTableUI.this.getParent().setBackground(LineTableUI.this.getBackground() == UI.getHighlightColor() ? UI.getControlBackColor() : UI.getHighlightColor());
                    ++this.count;
                    if (this.count > 5) {
                        timer.cancel();
                        parent.setBackground(UI.getControlBackColor());
                    }
                }
            }
        }, 100L, 200L);
    }

    public void updateLines(List<Line> lines) {
        this.lines = lines;
        this.model.fireTableDataChanged();
    }

    public void select(Line line) {
        if (line == null) {
            return;
        }
        int index = this.lines.indexOf(line);
        this.select(index);
    }

    public Line getSelection() {
        int row = this.getSelectedRow();
        if (row >= 0 && row < this.lines.size()) {
            return this.lines.get(row);
        }
        return null;
    }

    public void select(int index) {
        if (index >= 0 && index < this.lines.size()) {
            this.programmaticSelection = true;
            this.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public boolean contains(Line line) {
        return this.lines.contains(line);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Column {
        FILE,
        NUMBER,
        TEXT;

    }
}

