/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;

public class JVMMemoryUI
extends JComponent {
    private String label = "";
    private int descent;
    private double usedPercent;
    private Timer timer = new Timer();
    private long lastFree = 0L;

    public JVMMemoryUI() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                long free = Runtime.getRuntime().freeMemory();
                long total = Runtime.getRuntime().totalMemory();
                long max = Runtime.getRuntime().maxMemory();
                JVMMemoryUI.this.usedPercent = (double)(total - free) / (double)max;
                Graphics2D g = (Graphics2D)JVMMemoryUI.this.getGraphics();
                if (g != null) {
                    int usedMB = (int)((total - free) / 1024L / 1024L);
                    int totalMB = (int)(max / 1024L / 1024L);
                    JVMMemoryUI.this.label = Util.commas(usedMB) + " / " + Util.commas(totalMB) + " MB";
                    JVMMemoryUI.this.repaint();
                }
            }
        }, 250L, 2500L);
        Dimension size = new Dimension(80, (int)((double)UI.getToolbarHeight() * 0.6));
        this.setPreferredSize(size);
        this.setMaximumSize(size);
    }

    public void paintComponent(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(UI.getControlCenterColor());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
        g2d.setColor(UI.getControlFrontColor());
        g2d.fillRect(0, 0, (int)((double)this.getWidth() * this.usedPercent), this.getHeight() - 1);
        g2d.setColor(UI.getControlBorderColor());
        g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        Font font = UI.getMediumFont().deriveFont(10.0f);
        g.setColor(UI.getControlTextColor());
        g.setFont(font);
        FontMetrics metrics = g.getFontMetrics(font);
        Rectangle2D bounds = metrics.getStringBounds(this.label, g);
        int x = (int)(((double)this.getWidth() - bounds.getWidth()) / 2.0);
        int y = this.getHeight() - (int)(((double)this.getHeight() - bounds.getHeight()) / 2.0) - metrics.getDescent();
        g.drawString(this.label, x, y);
    }

    public void dispose() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }
}

