/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.tracing;

import edu.cmu.hcii.whyline.Whyline;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.ImmutableKind;
import edu.cmu.hcii.whyline.tracing.Agent;
import edu.cmu.hcii.whyline.tracing.ClassInstrumenter;
import edu.cmu.hcii.whyline.util.Util;
import edu.cmu.hcii.whyline.util.WeakLongHashMap;
import gnu.trove.TLongHashSet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tracer {
    public static boolean DEBUG_CLASSES_INSTRUMENTED = false;
    private static String mainName = "(unknown)";
    private static String[] mainArgs = new String[0];
    private static long mainTime = -1L;
    private static DataOutputStream immutables;
    private static DataOutputStream objectTypes;
    private static FileWriter debug;
    private static WeakLongHashMap<Object> objectIDs;
    private static TLongHashSet immutablesWritten;
    private static int nextThreadID;
    private static long nextObjectID;
    private static int nextEventID;
    public static int numberOfClassfiles;
    private static boolean shutdown;
    private static boolean shuttingDown;
    private static Set<ThreadTracer> tracerSet;
    private static final ThreadLocal<ThreadTracer> tracers;
    public static final ArrayList<ClassesToCache> classesToCache;

    static {
        objectIDs = new WeakLongHashMap(10000);
        immutablesWritten = new TLongHashSet(10000);
        nextThreadID = 0;
        nextObjectID = 1L;
        nextEventID = 0;
        numberOfClassfiles = 0;
        shutdown = false;
        shuttingDown = false;
        tracerSet = new HashSet<ThreadTracer>();
        try {
            if (!Whyline.getWorkingSerialHistoryFolder().exists()) {
                Whyline.getWorkingSerialHistoryFolder().mkdir();
            }
            immutables = Util.getWriterFor(Whyline.getWorkingImmutablesFile());
            objectTypes = Util.getWriterFor(Whyline.getWorkingObjectTypesFile());
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Tracer.shutdown();
                }
            });
            File debugFile = new File("debug.log");
            if (debugFile.exists()) {
                debugFile.delete();
            }
            debugFile.createNewFile();
            debug = new FileWriter(debugFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(711);
        }
        tracers = new ThreadLocal<ThreadTracer>(){

            @Override
            protected synchronized ThreadTracer initialValue() {
                try {
                    return new ThreadTracer(Thread.currentThread());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(0);
                    return null;
                }
            }
        };
        classesToCache = new ArrayList();
    }

    public static void addClassesToCacheOnExit(Set<QualifiedClassName> classes, ClassLoader loader) {
        classesToCache.add(new ClassesToCache(classes, loader));
    }

    public static boolean isShutdown() {
        return shutdown;
    }

    public static boolean isShuttingDown() {
        return shuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown() {
        if (shutdown) {
            return;
        }
        shuttingDown = true;
        try {
            for (ThreadTracer threadTracer : tracerSet) {
                threadTracer.stop();
            }
            shutdown = true;
            Whyline.debugBreak();
            Whyline.debug("\tSaving thread recordings...");
            Tracer.flush();
            for (ThreadTracer threadTracer : tracerSet) {
                threadTracer.trace.close();
            }
            tracerSet.clear();
            immutables.close();
            Whyline.debug("\tClosed immutables file...");
            objectTypes.close();
            Whyline.debug("\tClosed types file...");
            Agent.classIDs.write();
            Util.copyFile(new File(Whyline.getWorkingTraceFolder(), Whyline.CLASSIDS_PATH), Whyline.getWorkingClassIDsFile());
            Whyline.debug("\tDumped class IDs...");
            Whyline.debugBreak();
            Whyline.debug("Done writing instrumentation files.");
            Whyline.debugBreak();
            if (DEBUG_CLASSES_INSTRUMENTED) {
                ClassInstrumenter.printInstrumentationStatistics();
            }
            debug.flush();
            debug.close();
            DataOutputStream dataOutputStream = Agent.classes;
            synchronized (dataOutputStream) {
                Agent.classes.flush();
                Agent.classes.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(0);
        }
    }

    private static void flush() throws IOException {
        try {
            Whyline.getWorkingMetaFile().delete();
            DataOutputStream meta = Util.getWriterFor(Whyline.getWorkingMetaFile());
            meta.writeUTF(mainName);
            meta.writeInt(mainArgs.length);
            String[] stringArray = mainArgs;
            int n = mainArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                meta.writeUTF(arg);
                ++n2;
            }
            meta.writeLong(System.currentTimeMillis());
            meta.writeInt(nextEventID);
            meta.writeLong(nextObjectID);
            meta.writeInt(numberOfClassfiles);
            HashSet<ThreadTracer> tracers = new HashSet<ThreadTracer>(tracerSet);
            meta.writeInt(tracers.size());
            for (ThreadTracer tracer : tracers) {
                meta.writeUTF(tracer.name);
                meta.writeInt(tracer.threadID);
                meta.writeLong(tracer.objectID);
                meta.writeInt(tracer.numberOfEvents);
                meta.writeInt(tracer.firstEventID);
                meta.writeInt(tracer.lastEventID);
                tracer.trace.flush();
            }
            meta.close();
            immutables.flush();
            objectTypes.flush();
            debug.flush();
            Agent.classes.flush();
            Agent.classIDs.write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getUniqueObjectID(Object o) throws IOException {
        if (o == null) {
            return 0L;
        }
        long id = objectIDs.get(o);
        if (id != 0L) {
            return id;
        }
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            id = nextObjectID++;
            objectIDs.put(o, id);
            String classname = o.getClass().getName();
            int classID = classname == null ? 0 : Agent.classIDs.getIDOfClassname(QualifiedClassName.get(classname));
            objectTypes.writeLong(id);
            objectTypes.writeInt(classID);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return id;
        }
    }

    private static ThreadTracer getActiveThreadTracer() throws FileNotFoundException {
        ThreadTracer tracer = tracers.get();
        if (tracer.trace == null) {
            tracer.init();
        }
        if (tracer.stopRequests > 0) {
            return null;
        }
        return tracer;
    }

    public static void recordMain(String classname, String[] args) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer != null) {
            tracer.stop();
        }
        mainName = classname;
        mainArgs = new String[args.length];
        System.arraycopy(args, 0, mainArgs, 0, args.length);
        mainTime = System.currentTimeMillis();
        if (tracer != null) {
            tracer.start();
        }
    }

    public static void IINC(int value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeInt(value);
    }

    public static void PUTFIELD(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void PUTSTATIC(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void SETARRAY(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void SETLOCAL(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void COMPINTS(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void COMPZERO(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void COMPREFS(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void COMPNULL(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void TABLEBRANCH(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void INVOKE_VIRTUAL(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void INVOKE_SPECIAL(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void INVOKE_STATIC(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void INVOKE_INTERFACE(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void RETURN(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void START_METHOD(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void EXCEPTION_THROWN(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void EXCEPTION_CAUGHT(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void MONITOR(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void INTEGER_PRODUCED(int value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeInt(value);
    }

    public static void SHORT_PRODUCED(short value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeShort(value);
    }

    public static void BYTE_PRODUCED(byte value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeByte(value);
    }

    public static void FLOAT_PRODUCED(float value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeFloat(value);
    }

    public static void BOOLEAN_PRODUCED(boolean value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeBoolean(value);
    }

    public static void CHARACTER_PRODUCED(char value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeChar(value);
    }

    public static void DOUBLE_PRODUCED(double value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeDouble(value);
    }

    public static void LONG_PRODUCED(long value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeLong(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void OBJECT_PRODUCED(Object value, boolean inInit, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        long id = Tracer.getUniqueObjectID(value);
        tracer.trace.writeLong(id);
        ImmutableKind kind = null;
        if (inInit) return;
        if (value == null || immutablesWritten.contains(id) || (kind = ImmutableKind.classToType(value)) == null) return;
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            immutablesWritten.add(id);
            immutables.writeByte(kind.ordinal());
            immutables.writeLong(id);
            tracer.stop();
            kind.writeObject(value, immutables);
            tracer.start();
            // ** MonitorExit[var8_6] (shouldn't be in output)
            return;
        }
    }

    public static void CONSTANT_INTEGER_PRODUCED(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void CONSTANT_SHORT_PRODUCED(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void CONSTANT_BYTE_PRODUCED(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void CONSTANT_FLOAT_PRODUCED(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void CONSTANT_BOOLEAN_PRODUCED(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void CONSTANT_CHARACTER_PRODUCED(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void CONSTANT_DOUBLE_PRODUCED(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void CONSTANT_LONG_PRODUCED(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void CONSTANT_OBJECT_PRODUCED(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void THIS_PRODUCED(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void INITIALIZER(long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
    }

    public static void NEW_OBJECT(Object value, boolean inInit, long iid) throws IOException {
        Tracer.OBJECT_PRODUCED(value, inInit, iid);
    }

    public static void NEW_ARRAY(Object value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        DataOutputStream trace = tracer.trace;
        trace.writeLong(Tracer.getUniqueObjectID(value));
    }

    public static void INTEGER_ARG(int value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeInt(value);
    }

    public static void SHORT_ARG(short value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeShort(value);
    }

    public static void BYTE_ARG(byte value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeByte(value);
    }

    public static void FLOAT_ARG(float value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeFloat(value);
    }

    public static void BOOLEAN_ARG(boolean value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeBoolean(value);
    }

    public static void CHARACTER_ARG(char value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeChar(value);
    }

    public static void DOUBLE_ARG(double value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeDouble(value);
    }

    public static void LONG_ARG(long value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeLong(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void OBJECT_ARG(Object value, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        long id = Tracer.getUniqueObjectID(value);
        tracer.trace.writeLong(id);
        if (!(value instanceof String) || immutablesWritten.contains(id)) return;
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            immutablesWritten.add(id);
            immutables.writeByte(ImmutableKind.STRING.ordinal());
            immutables.writeLong(id);
            tracer.stop();
            ImmutableKind.STRING.writeObject(value, immutables);
            tracer.start();
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    public static Graphics2D GETGRAPHICS(Object c, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer != null) {
            tracer.stop();
        }
        Graphics2D g = (Graphics2D)(c instanceof Component ? ((Component)c).getGraphics() : (c instanceof VolatileImage ? ((VolatileImage)c).createGraphics() : (c instanceof BufferedImage ? ((BufferedImage)c).createGraphics() : (c instanceof Image ? ((Image)c).getGraphics() : null))));
        if (tracer != null) {
            tracer.start();
        }
        if (tracer == null) {
            return g;
        }
        tracer.stop();
        int translateX = 0;
        int translateY = 0;
        int width = 0;
        int height = 0;
        Window window = null;
        int windowX = 0;
        int windowY = 0;
        long windowID = 0L;
        if (c instanceof Component) {
            Component comp = (Component)c;
            if (c instanceof Window) {
                window = (Window)c;
            } else {
                window = SwingUtilities.getWindowAncestor(comp);
                if (window != null) {
                    Point p = SwingUtilities.convertPoint(((Component)c).getParent(), comp.getX(), comp.getY(), window.getComponent(0));
                    translateX = (int)p.getX();
                    translateY = (int)p.getY();
                } else {
                    translateX = comp.getX();
                    translateY = comp.getY();
                }
            }
        }
        tracer.header(iid);
        DataOutputStream trace = tracer.trace;
        long id = 0L;
        boolean representsWindow = false;
        if (c instanceof Component) {
            if (window == null) {
                id = Tracer.getUniqueObjectID(c);
                width = 0;
                height = 0;
            } else {
                representsWindow = true;
                id = Tracer.getUniqueObjectID(window);
                width = window.getComponent(0).getWidth();
                height = window.getComponent(0).getHeight();
            }
        } else if (c instanceof Image) {
            id = Tracer.getUniqueObjectID(c);
            width = ((Image)c).getWidth(null);
            height = ((Image)c).getHeight(null);
        } else if (c instanceof ComponentPeer) {
            id = Tracer.getUniqueObjectID(c);
            width = ((ComponentPeer)c).getBounds().width;
            height = ((ComponentPeer)c).getBounds().height;
        } else {
            debug.write("Not handling " + c + "\n");
            debug.write("Class is " + c.getClass() + "\n");
            debug.write("Instanceof java.awt.Component? " + (c instanceof Component) + "\n");
            id = Tracer.getUniqueObjectID(c);
        }
        if (window != null) {
            windowX = window.getX();
            windowY = window.getY();
            windowID = Tracer.getUniqueObjectID(window);
        }
        trace.writeBoolean(representsWindow);
        trace.writeLong(id);
        trace.writeLong(Tracer.getUniqueObjectID(g));
        trace.writeShort(width);
        trace.writeShort(height);
        trace.writeShort(translateX);
        trace.writeShort(translateY);
        trace.writeLong(windowID);
        trace.writeShort(windowX);
        trace.writeShort(windowY);
        tracer.start();
        return g;
    }

    public static Graphics2D CREATEGRAPHICS(Object g, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer != null) {
            tracer.stop();
        }
        Graphics2D newG = (Graphics2D)((Graphics)g).create();
        if (tracer != null) {
            tracer.start();
        }
        if (tracer == null) {
            return newG;
        }
        tracer.header(iid);
        DataOutputStream trace = tracer.trace;
        trace.writeLong(Tracer.getUniqueObjectID(g));
        trace.writeLong(Tracer.getUniqueObjectID(newG));
        return newG;
    }

    public static void MOUSE_EVENT(Object source, int id, int x, int y, int button, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        DataOutputStream trace = tracer.trace;
        trace.writeLong(Tracer.getUniqueObjectID(source));
        trace.writeInt(id);
        trace.writeInt(x);
        trace.writeInt(y);
        trace.writeInt(button);
    }

    public static void KEY_EVENT(Object source, int id, int modifiers, int keyCode, char keyChar, int keyLocation, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        DataOutputStream trace = tracer.trace;
        trace.writeLong(Tracer.getUniqueObjectID(source));
        trace.writeInt(id);
        trace.writeInt(modifiers);
        trace.writeInt(keyCode);
        trace.writeChar(keyChar);
        trace.writeInt(keyLocation);
    }

    public static void WINDOW(Object window, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        tracer.header(iid);
        tracer.trace.writeLong(Tracer.getUniqueObjectID(window));
    }

    public static void IMAGE_SIZE(Object image, long iid) throws IOException {
        ThreadTracer tracer = Tracer.getActiveThreadTracer();
        if (tracer == null) {
            return;
        }
        if (image == null) {
            return;
        }
        tracer.stop();
        tracer.header(iid);
        tracer.trace.writeLong(Tracer.getUniqueObjectID(image));
        tracer.trace.writeInt(((Image)image).getWidth(null));
        tracer.trace.writeInt(((Image)image).getHeight(null));
        tracer.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassesToCache {
        public final Set<QualifiedClassName> classes;
        public final ClassLoader loader;

        public ClassesToCache(Set<QualifiedClassName> classes, ClassLoader loader) {
            this.classes = classes;
            this.loader = loader;
        }
    }

    private static class ThreadTracer {
        public Thread thread;
        public String name;
        public int threadID;
        public long objectID;
        public int numberOfEvents = 0;
        public int firstEventID;
        public int lastEventID = -2;
        public int stopRequests = 0;
        public DataOutputStream trace;

        public ThreadTracer(Thread thread) throws IOException {
            this.thread = thread;
            int n = nextThreadID;
            nextThreadID = n + 1;
            this.threadID = n;
            this.objectID = Tracer.getUniqueObjectID(thread);
            this.firstEventID = nextEventID;
        }

        private void init() throws FileNotFoundException {
            this.stop();
            StringBuilder nameBuilder = new StringBuilder();
            String threadName = this.thread.getName();
            int i = 0;
            while (i < threadName.length()) {
                char c = threadName.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    nameBuilder.append(c);
                }
                ++i;
            }
            nameBuilder.append("-");
            nameBuilder.append(this.threadID);
            this.name = nameBuilder.toString();
            this.trace = Util.getWriterFor(new File(Whyline.getWorkingSerialHistoryFolder(), String.valueOf(this.name) + ".history"));
            tracerSet.add(this);
            this.start();
        }

        public void stop() {
            ++this.stopRequests;
        }

        public void start() {
            --this.stopRequests;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void header(long iid) throws IOException {
            Class<Tracer> clazz = Tracer.class;
            synchronized (Tracer.class) {
                int n = nextEventID;
                nextEventID = n + 1;
                int eventID = n;
                if (eventID % 65536 == 0) {
                    this.stop();
                    Tracer.flush();
                    this.start();
                }
                // ** MonitorExit[var4_2] (shouldn't be in output)
                ++this.numberOfEvents;
                boolean switchedBack = this.lastEventID + 1 != eventID;
                this.lastEventID = eventID;
                byte kindFlags = (byte)(iid >>> 32 << 1);
                if (switchedBack) {
                    kindFlags = (byte)(kindFlags | 1);
                }
                this.trace.writeByte(kindFlags);
                if (switchedBack) {
                    this.trace.writeInt(eventID);
                }
                this.trace.writeInt((int)(iid << 32 >>> 32));
                return;
            }
        }
    }
}

