/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.tracing;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.ALOAD;
import edu.cmu.hcii.whyline.bytecode.ALOAD_0;
import edu.cmu.hcii.whyline.bytecode.ALOAD_1;
import edu.cmu.hcii.whyline.bytecode.ALOAD_3;
import edu.cmu.hcii.whyline.bytecode.ATHROW;
import edu.cmu.hcii.whyline.bytecode.AbstractReturn;
import edu.cmu.hcii.whyline.bytecode.ArrayAllocation;
import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.CompareIntegerToZeroBranch;
import edu.cmu.hcii.whyline.bytecode.CompareIntegersBranch;
import edu.cmu.hcii.whyline.bytecode.CompareReferencesBranch;
import edu.cmu.hcii.whyline.bytecode.CompareToNullBranch;
import edu.cmu.hcii.whyline.bytecode.ConditionalBranch;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.DLOAD;
import edu.cmu.hcii.whyline.bytecode.DUP;
import edu.cmu.hcii.whyline.bytecode.DUP2;
import edu.cmu.hcii.whyline.bytecode.DUP_X1;
import edu.cmu.hcii.whyline.bytecode.Definition;
import edu.cmu.hcii.whyline.bytecode.Duplication;
import edu.cmu.hcii.whyline.bytecode.ExceptionHandler;
import edu.cmu.hcii.whyline.bytecode.FLOAD;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.ICONST_0;
import edu.cmu.hcii.whyline.bytecode.ICONST_1;
import edu.cmu.hcii.whyline.bytecode.IINC;
import edu.cmu.hcii.whyline.bytecode.ILOAD;
import edu.cmu.hcii.whyline.bytecode.ILOAD_2;
import edu.cmu.hcii.whyline.bytecode.INVOKEINTERFACE;
import edu.cmu.hcii.whyline.bytecode.INVOKESPECIAL;
import edu.cmu.hcii.whyline.bytecode.INVOKESTATIC;
import edu.cmu.hcii.whyline.bytecode.INVOKEVIRTUAL;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.JSR;
import edu.cmu.hcii.whyline.bytecode.JSR_W;
import edu.cmu.hcii.whyline.bytecode.JavaSpecificationViolation;
import edu.cmu.hcii.whyline.bytecode.LDC2_W;
import edu.cmu.hcii.whyline.bytecode.LDC_W;
import edu.cmu.hcii.whyline.bytecode.LLOAD;
import edu.cmu.hcii.whyline.bytecode.MONITORENTER;
import edu.cmu.hcii.whyline.bytecode.MONITOREXIT;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.NEW;
import edu.cmu.hcii.whyline.bytecode.PUTFIELD;
import edu.cmu.hcii.whyline.bytecode.PUTSTATIC;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.SetArrayValue;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.bytecode.TableBranch;
import edu.cmu.hcii.whyline.io.CreateGraphicsParser;
import edu.cmu.hcii.whyline.io.GetGraphicsParser;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.tracing.Agent;
import edu.cmu.hcii.whyline.tracing.ClassInstrumenter;
import gnu.trove.TIntStack;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class MethodInstrumenter {
    public static final int IS_OUTPUT_SHIFT = 7;
    public static final int EVENT_TYPE_BIT_SIZE = 8;
    public static final int CLASS_ID_BIT_SIZE = 14;
    public static final int INSTRUCTION_ID_BIT_SIZE = 18;
    public static final int MAXIMUM_INSTRUCTIONS = (int)Math.pow(2.0, 18.0);
    public static final int MAXIMUM_CLASS_IDS = (int)Math.pow(2.0, 14.0);
    private final ClassInstrumenter.ClassInstrumentationInfo instrumentationData;
    private final long classID;
    private final MethodInfo method;
    private final boolean isVirtual;
    private final Classfile classfile;
    private final QualifiedClassName classname;
    private final CodeAttribute code;
    private final ConstantPool pool;
    private final TIntStack newIDsToInstrument = new TIntStack(2);
    private int nextInstructionID;
    private int numberOfInstructionsInstrumented = 0;
    private ArrayList<Instruction> instructions;

    public MethodInstrumenter(ClassInstrumenter.ClassInstrumentationInfo instrumentationData, MethodInfo method, int nextInstructionID) throws AnalysisException {
        this.method = method;
        this.classfile = method.getClassfile();
        this.classname = this.classfile.getInternalName();
        this.instrumentationData = instrumentationData;
        this.classID = Agent.classIDs.getIDOfClassname(this.classname);
        if (this.classID == 0L) {
            throw new RuntimeException("The classID of " + this.classname + " cannot be zero. Why is it zero?");
        }
        this.code = method.getCode();
        this.pool = this.classfile.getConstantPool();
        this.nextInstructionID = nextInstructionID;
        this.isVirtual = method.isVirtual();
        this.instructions = new ArrayList(this.code.getNumberOfInstructions() * 2);
    }

    public int getNumberOfInstructionsInstrumented() {
        return this.numberOfInstructionsInstrumented;
    }

    private Instruction addLoadAndTraceInstructions(EventKind event, boolean isOutput) throws JavaSpecificationViolation {
        return this.addLoadAndTraceInstructions(event, isOutput, this.nextInstructionID);
    }

    private Instruction addLoadAndTraceInstructions(EventKind event, boolean isIO, int instructionID) throws JavaSpecificationViolation {
        long ciid = this.classID << 18 | (long)instructionID;
        long kind = event.id << 1 | (isIO ? 1 : 0);
        long kind_ciid = kind << 32 | ciid;
        LDC2_W firstInserted = new LDC2_W(this.code, this.pool.addLongInfo(kind_ciid));
        this.instructions.add(firstInserted);
        this.instructions.add(new INVOKESTATIC(this.code, this.instrumentationData.getMethodFor(event)));
        ++this.numberOfInstructionsInstrumented;
        return firstInserted;
    }

    public int instrument() throws AnalysisException, JavaSpecificationViolation {
        if (this.method.isMain()) {
            this.instructions.add(new LDC_W(this.code, this.pool.addStringInfo(this.classname.getText())));
            this.instructions.add(new ALOAD_0(this.code));
            this.instructions.add(new INVOKESTATIC(this.code, this.pool.addMethodrefInfo(this.instrumentationData.tracerClassInfo, "recordMain", "(Ljava/lang/String;[Ljava/lang/String;)V")));
        }
        this.insertMethodArgumentRecording();
        this.instrumentInstructions();
        Instruction[] newInstructionArray = new Instruction[this.instructions.size()];
        this.instructions.toArray(newInstructionArray);
        this.code.setInstructions(newInstructionArray);
        return this.nextInstructionID;
    }

    private void insertMethodArgumentRecording() throws JavaSpecificationViolation {
        String name;
        this.addLoadAndTraceInstructions(EventKind.START_METHOD, false);
        if (this.classname == QualifiedClassName.get("java/awt/LightweightDispatcher") && this.method.getInternalName().equals("retargetMouseEvent")) {
            ClassInfo mouseEventClassInfo = this.pool.addClassInfo(MouseEvent.class);
            this.instructions.add(new ALOAD_3(this.code));
            this.instructions.add(new INVOKEVIRTUAL(this.code, this.pool.addMethodrefInfo(mouseEventClassInfo, "getComponent", "()Ljava/awt/Component;")));
            this.instructions.add(new ALOAD_3(this.code));
            this.instructions.add(new INVOKEVIRTUAL(this.code, this.pool.addMethodrefInfo(mouseEventClassInfo, "getID", "()I")));
            this.instructions.add(new ALOAD_3(this.code));
            this.instructions.add(new INVOKEVIRTUAL(this.code, this.pool.addMethodrefInfo(mouseEventClassInfo, "getX", "()I")));
            this.instructions.add(new ALOAD_3(this.code));
            this.instructions.add(new INVOKEVIRTUAL(this.code, this.pool.addMethodrefInfo(mouseEventClassInfo, "getY", "()I")));
            this.instructions.add(new ALOAD_3(this.code));
            this.instructions.add(new INVOKEVIRTUAL(this.code, this.pool.addMethodrefInfo(mouseEventClassInfo, "getButton", "()I")));
            this.addLoadAndTraceInstructions(EventKind.MOUSE_EVENT, true);
        } else if (this.classname == QualifiedClassName.get("java/awt/event/KeyEvent") && this.method.isInstanceInitializer() && this.method.getDescriptor().equals("(Ljava/awt/Component;IJIICI)V")) {
            this.instructions.add(new ALOAD_1(this.code));
            this.instructions.add(new ILOAD_2(this.code));
            this.instructions.add(new ILOAD(this.code, 5));
            this.instructions.add(new ILOAD(this.code, 6));
            this.instructions.add(new ILOAD(this.code, 7));
            this.instructions.add(new ILOAD(this.code, 8));
            this.addLoadAndTraceInstructions(EventKind.KEY_EVENT, true);
        } else if (this.classname == QualifiedClassName.get("java/awt/Window") && this.method.getDescriptor().equals("()V") && ((name = this.method.getInternalName()).equals("show") || name.equals("hide"))) {
            this.instructions.add(new ALOAD_0(this.code));
            this.addLoadAndTraceInstructions(EventKind.WINDOW, true);
        }
        if (!this.method.isStatic() && !this.method.isInstanceInitializer()) {
            this.instructions.add(new ALOAD(this.code, 0));
            this.addLoadAndTraceInstructions(EventKind.OBJECT_ARG, false);
        }
        int localID = this.method.isStatic() ? 0 : 1;
        for (String type : this.method.getParsedDescriptor()) {
            EventKind typeProduced = null;
            if (type.equals("I")) {
                typeProduced = EventKind.INTEGER_ARG;
                this.instructions.add(new ILOAD(this.code, localID));
            } else if (type.startsWith("[")) {
                typeProduced = EventKind.OBJECT_ARG;
                this.instructions.add(new ALOAD(this.code, localID));
            } else if (type.startsWith("L")) {
                typeProduced = EventKind.OBJECT_ARG;
                this.instructions.add(new ALOAD(this.code, localID));
            } else if (type.equals("C")) {
                typeProduced = EventKind.CHARACTER_ARG;
                this.instructions.add(new ILOAD(this.code, localID));
            } else if (type.equals("F")) {
                typeProduced = EventKind.FLOAT_ARG;
                this.instructions.add(new FLOAD(this.code, localID));
            } else if (type.equals("J")) {
                typeProduced = EventKind.LONG_ARG;
                this.instructions.add(new LLOAD(this.code, localID));
            } else if (type.equals("D")) {
                typeProduced = EventKind.DOUBLE_ARG;
                this.instructions.add(new DLOAD(this.code, localID));
            } else if (type.equals("S")) {
                typeProduced = EventKind.SHORT_ARG;
                this.instructions.add(new ILOAD(this.code, localID));
            } else if (type.equals("Z")) {
                typeProduced = EventKind.BOOLEAN_ARG;
                this.instructions.add(new ILOAD(this.code, localID));
            } else if (type.equals("B")) {
                typeProduced = EventKind.BYTE_ARG;
                this.instructions.add(new ILOAD(this.code, localID));
            }
            if (typeProduced == null) continue;
            this.addLoadAndTraceInstructions(typeProduced, false);
            if (typeProduced.isDoubleOrLong()) {
                localID += 2;
                continue;
            }
            ++localID;
        }
    }

    private void instrumentInstructions() throws JavaSpecificationViolation, AnalysisException {
        Instruction[] instructionArray = this.code.getInstructions();
        int n = instructionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Instruction instruction = instructionArray[n2];
            int sizeBefore = this.instructions.size();
            this.insertBeforeInstruction(instruction);
            int sizeAfter = this.instructions.size();
            Instruction firstInstructionInsertedBefore = sizeBefore == sizeAfter ? null : this.instructions.get(sizeBefore);
            Instruction firstReplacementInstruction = this.insertOrReplaceInstruction(instruction);
            sizeBefore = this.instructions.size();
            this.insertAfterInstruction(instruction);
            sizeAfter = this.instructions.size();
            Instruction firstInstructionInsertedAfter = sizeBefore == sizeAfter ? null : this.instructions.get(sizeBefore);
            Instruction newTarget = firstReplacementInstruction;
            if (firstInstructionInsertedBefore != null) {
                newTarget = firstInstructionInsertedBefore;
            }
            if (newTarget != null) {
                for (Branch b : instruction.getIncomingBranches()) {
                    b.replaceTarget(instruction, newTarget);
                }
            }
            if (newTarget != null) {
                for (ExceptionHandler exInfo : this.code.getExceptionTable()) {
                    if (instruction == exInfo.getHandlerPC()) {
                        exInfo.updateHandlerPC(newTarget);
                    }
                    if (instruction == exInfo.getStartPC()) {
                        exInfo.updateStartPC(newTarget);
                    }
                    if (instruction != exInfo.getEndPC()) continue;
                    exInfo.updateEndPC(newTarget);
                }
            }
            ++this.nextInstructionID;
            ++n2;
        }
        if (this.numberOfInstructionsInstrumented >= MAXIMUM_INSTRUCTIONS) {
            throw new RuntimeException("Reached the maximum number of instructions: " + MAXIMUM_INSTRUCTIONS + ". Whyline doesn't yet support programs with more code than that.");
        }
    }

    private void insertBeforeInstruction(Instruction instruction) throws JavaSpecificationViolation {
        for (ExceptionHandler exInfo : this.code.getExceptionTable()) {
            if (instruction != exInfo.getHandlerPC()) continue;
            this.addLoadAndTraceInstructions(EventKind.EXCEPTION_CAUGHT, instruction.isIO());
            break;
        }
        if (instruction instanceof Invoke) {
            if (instruction instanceof INVOKEVIRTUAL) {
                this.addLoadAndTraceInstructions(EventKind.INVOKE_VIRTUAL, instruction.isIO());
            } else if (instruction instanceof INVOKEINTERFACE) {
                this.addLoadAndTraceInstructions(EventKind.INVOKE_INTERFACE, instruction.isIO());
            } else if (instruction instanceof INVOKESTATIC) {
                this.addLoadAndTraceInstructions(EventKind.INVOKE_STATIC, instruction.isIO());
            } else if (instruction instanceof INVOKESPECIAL) {
                this.addLoadAndTraceInstructions(EventKind.INVOKE_SPECIAL, instruction.isIO());
            }
        } else if (instruction instanceof ConditionalBranch || instruction instanceof TableBranch) {
            EventKind kind;
            EventKind eventKind = instruction instanceof CompareIntegersBranch ? EventKind.COMPINTS : (instruction instanceof CompareIntegerToZeroBranch ? EventKind.COMPZERO : (instruction instanceof CompareToNullBranch ? EventKind.COMPNULL : (instruction instanceof CompareReferencesBranch ? EventKind.COMPREFS : (kind = instruction instanceof TableBranch ? EventKind.TABLEBRANCH : null))));
            assert (kind != null) : "Don't know how to instrument a " + instruction.getClass();
            this.addLoadAndTraceInstructions(kind, instruction.isIO());
        } else if (instruction instanceof AbstractReturn) {
            this.addLoadAndTraceInstructions(EventKind.RETURN, instruction.isIO());
        } else if (instruction instanceof ATHROW) {
            this.addLoadAndTraceInstructions(EventKind.EXCEPTION_THROWN, instruction.isIO());
        } else if (instruction instanceof MONITORENTER || instruction instanceof MONITOREXIT) {
            this.addLoadAndTraceInstructions(EventKind.MONITOR, instruction.isIO());
        }
    }

    private Instruction insertOrReplaceInstruction(Instruction instruction) throws JavaSpecificationViolation {
        if (GetGraphicsParser.handles(instruction)) {
            return this.addLoadAndTraceInstructions(EventKind.GETGRAPHICS, true);
        }
        if (CreateGraphicsParser.handles(instruction)) {
            return this.addLoadAndTraceInstructions(EventKind.CREATEGRAPHICS, true);
        }
        this.instructions.add(instruction);
        return null;
    }

    private void insertAfterInstruction(Instruction instruction) throws JavaSpecificationViolation, AnalysisException {
        if (instruction instanceof Definition) {
            if (instruction instanceof IINC) {
                this.instructions.add(new ILOAD(this.code, ((IINC)instruction).getLocalID()));
                this.addLoadAndTraceInstructions(EventKind.IINC, instruction.isIO());
            } else {
                EventKind kind;
                EventKind eventKind = instruction instanceof SetLocal ? EventKind.SETLOCAL : (instruction instanceof PUTFIELD ? EventKind.PUTFIELD : (instruction instanceof PUTSTATIC ? EventKind.PUTSTATIC : (kind = instruction instanceof SetArrayValue ? EventKind.SETARRAY : null)));
                if (kind == null) {
                    throw new AnalysisException("Don't know how to instrument a " + instruction.getClass());
                }
                this.addLoadAndTraceInstructions(kind, instruction.isIO());
            }
        } else if (instruction instanceof INVOKESPECIAL && ((INVOKESPECIAL)instruction).getMethodInvoked().callsInstanceInitializer() && this.newIDsToInstrument.size() > 0) {
            int instanceProducerID = this.newIDsToInstrument.pop();
            boolean inInit = this.method.isInstanceInitializer() || this.method.isClassInitializer();
            this.instructions.add(inInit ? new ICONST_1(this.code) : new ICONST_0(this.code));
            this.addLoadAndTraceInstructions(EventKind.NEW_OBJECT, false, instanceProducerID);
        } else {
            EventKind typeProduced = instruction.getTypeProduced();
            StackDependencies.Consumers consumers = instruction.getConsumers();
            int numberOfPotentialConsumers = consumers.getNumberOfConsumers();
            if (numberOfPotentialConsumers > 0 && !instruction.duplicatesMultipleOperands() && !instruction.insertsDuplicatedOperandBelow()) {
                if (typeProduced == null) {
                    throw new AnalysisException(this.classname + "'s " + instruction + " must produce some type.\n" + this.code.toString());
                }
                Instruction consumer = consumers.getFirstConsumer();
                boolean producesExclusively = numberOfPotentialConsumers == 1 && consumer.getProducersOfArgument(consumer.getArgumentNumberOfProducer(instruction)).getNumberOfProducers() == 1;
                boolean isIO = instruction.isIO();
                boolean referencesUninitializedObject = instruction.referencesUninitializedObject();
                if (instruction instanceof NEW) {
                    this.newIDsToInstrument.push(this.nextInstructionID);
                    this.instructions.add(instruction.getNext() instanceof DUP_X1 ? new DUP_X1(this.code) : new DUP(this.code));
                } else if (instruction instanceof ArrayAllocation) {
                    this.instructions.add(new DUP(this.code));
                    this.addLoadAndTraceInstructions(EventKind.NEW_ARRAY, false);
                } else if (!(referencesUninitializedObject || this.isVirtual && instruction instanceof ALOAD_0 && producesExclusively || !isIO && instruction instanceof GetLocal && producesExclusively && !referencesUninitializedObject || instruction instanceof JSR || instruction instanceof JSR_W)) {
                    if (typeProduced.isConstantProduced) {
                        Instruction upstreamProducerIfDuplication = instruction;
                        while (upstreamProducerIfDuplication instanceof Duplication) {
                            upstreamProducerIfDuplication = upstreamProducerIfDuplication.getProducersOfArgument(0).getFirstProducer();
                        }
                        int argNumber = consumer.getArgumentNumberOfProducer(instruction);
                        if (upstreamProducerIfDuplication instanceof GetLocal || isIO || argNumber >= 0 && consumer.getProducersOfArgument(argNumber).getNumberOfProducers() > 1) {
                            this.addLoadAndTraceInstructions(typeProduced, isIO);
                        }
                    } else {
                        this.instructions.add(typeProduced.isDoubleOrLong() ? new DUP2(this.code) : new DUP(this.code));
                        if (typeProduced == EventKind.OBJECT_PRODUCED || typeProduced == EventKind.NEW_OBJECT) {
                            boolean inInit = this.method.isInstanceInitializer() || this.method.isClassInitializer();
                            this.instructions.add(inInit ? new ICONST_1(this.code) : new ICONST_0(this.code));
                        }
                        this.addLoadAndTraceInstructions(typeProduced, isIO);
                    }
                }
                if (consumer instanceof INVOKEVIRTUAL && ((INVOKEVIRTUAL)consumer).getMethodInvoked().getMethodName().startsWith("drawImage") && consumer.getArgumentNumberOfProducer(instruction) == 1) {
                    this.instructions.add(new DUP(this.code));
                    this.addLoadAndTraceInstructions(EventKind.IMAGE_SIZE, true);
                }
            }
        }
    }
}

