/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.tracing;

import edu.cmu.hcii.whyline.Whyline;
import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.JavaSpecificationViolation;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.MethodrefInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.tracing.Agent;
import edu.cmu.hcii.whyline.tracing.InstrumentationProfile;
import edu.cmu.hcii.whyline.tracing.MethodInstrumenter;
import edu.cmu.hcii.whyline.tracing.Tracer;
import edu.cmu.hcii.whyline.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInstrumenter
implements ClassFileTransformer {
    public static boolean DEBUG_INSTRUMENTATION = false;
    public static boolean DEBUG_BEFORE_AND_AFTER = false;
    public static String DEBUG_PRINT_INSTRUMENTED_BYTECODE = "fjsdlfkjdkf";
    private static Vector<String> classnamePrefixesToSkip = new Vector(20);
    public static final String bootClassPath;
    public static final List<InstrumentationProfile> profiles;
    public static double totalInstrumentationTime;
    public static double totalReadingTime;
    public static double totalWritingTime;
    public static double totalConversionTime;
    public static double totalNumberOfInstrumentedClasses;

    static {
        classnamePrefixesToSkip.add("sun/misc/");
        classnamePrefixesToSkip.add("sun/reflect/");
        classnamePrefixesToSkip.add("sun/nio/");
        classnamePrefixesToSkip.add("sun/net/");
        classnamePrefixesToSkip.add("sun/security/");
        classnamePrefixesToSkip.add("java/lang/");
        classnamePrefixesToSkip.add("java/io/");
        classnamePrefixesToSkip.add("java/nio/");
        classnamePrefixesToSkip.add("java/util/");
        classnamePrefixesToSkip.add("java/net/");
        classnamePrefixesToSkip.add("java/text/");
        classnamePrefixesToSkip.add("java/security/");
        classnamePrefixesToSkip.add("gnu/trove/");
        classnamePrefixesToSkip.add("edu/cmu/hcii/whyline/");
        classnamePrefixesToSkip.add("java/awt/Toolkit$SelectiveAWTEventListener");
        classnamePrefixesToSkip.add("apple/awt/CRenderer");
        classnamePrefixesToSkip.add("apple/awt/CTextPipe");
        classnamePrefixesToSkip.add("apple/awt/CPeerSurfaceData");
        classnamePrefixesToSkip.add("sun/awt/AWTAutoShutdown");
        classnamePrefixesToSkip.add("sun/awt/FontConfiguration");
        classnamePrefixesToSkip.add("apple/awt/OSXSurfaceData");
        classnamePrefixesToSkip.add("sun/java2d/loops/");
        classnamePrefixesToSkip.add("sun/java2d/pipe/");
        bootClassPath = System.getProperty("sun.boot.class.path");
        profiles = new ArrayList<InstrumentationProfile>(100);
        totalInstrumentationTime = 0.0;
        totalReadingTime = 0.0;
        totalWritingTime = 0.0;
        totalConversionTime = 0.0;
        totalNumberOfInstrumentedClasses = 0.0;
    }

    public ClassInstrumenter() {
        Whyline.getClassCacheFolder().mkdir();
        Whyline.getInstrumentedClassCacheFolder().mkdir();
        Whyline.getUninstrumentedClassCacheFolder().mkdir();
    }

    public static void addPrefixToSkip(String prefix) {
        if (prefix.length() > 0) {
            classnamePrefixesToSkip.add(prefix);
        }
    }

    private static void debug(String message) {
        Whyline.debug(message);
    }

    public static byte[] getCachedVersionOf(QualifiedClassName classname) throws IOException {
        String pathString = ClassInstrumenter.getPathToInstrumentedClass(classname);
        File file = new File(pathString);
        if (!file.exists()) {
            return null;
        }
        FileInputStream reader = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        reader.read(bytes);
        return bytes;
    }

    private static String getPathToInstrumentedClass(QualifiedClassName classname) {
        return String.valueOf(Whyline.getInstrumentedClassCacheFolder().getAbsolutePath()) + File.separatorChar + classname.getCorrespondingClassfileName();
    }

    private static void cache(QualifiedClassName classname, byte[] classfile) {
        String pathString = ClassInstrumenter.getPathToInstrumentedClass(classname);
        String directory = pathString.substring(0, pathString.lastIndexOf(File.separatorChar) + 1);
        new File(directory).mkdirs();
        try {
            File path = new File(pathString);
            if (path.exists()) {
                path.delete();
            }
            FileOutputStream writer = new FileOutputStream(path);
            writer.write(classfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean shouldTrace(String className) {
        for (String prefix : classnamePrefixesToSkip) {
            if (!className.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] transform(ClassLoader loader, String classnameString, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        Classfile classfile;
        long beforeTime;
        ClassInfo superclassInfo;
        QualifiedClassName classname;
        block14: {
            URL url;
            if (Tracer.isShutdown()) {
                return null;
            }
            classname = QualifiedClassName.get(classnameString);
            superclassInfo = null;
            Agent.classIDs.includeClassName(classname);
            beforeTime = System.currentTimeMillis();
            classfile = new Classfile(classfileBuffer);
            String path = loader == null ? bootClassPath : (loader instanceof URLClassLoader ? ((url = ((URLClassLoader)loader).getResource(classnameString)) == null ? null : url.getPath()) : null);
            Agent.addClassToTrace(classname, path == null ? classfile.toByteArray() : null, 0L, path);
            boolean shouldTrace = this.shouldTrace(classname.getText());
            if (Tracer.isShuttingDown()) {
                shouldTrace = false;
            }
            if (shouldTrace) break block14;
            return null;
        }
        try {
            byte[] preinstrumentedClassfile;
            Tracer.addClassesToCacheOnExit(classfile.getConstantPool().getClassNamesReferenced(), loader);
            superclassInfo = classfile.getSuperclassInfo();
            if (superclassInfo != null) {
                Agent.classIDs.markSuperclass(classname, superclassInfo.getName());
            }
            Agent.classIDs.markClassnameAsInstrumented(classname);
            if (!Agent.classIDs.classHasBeenUpdated(classname) && (preinstrumentedClassfile = ClassInstrumenter.getCachedVersionOf(classname)) != null) {
                ClassInstrumenter.debug("Recording " + classname);
                return preinstrumentedClassfile;
            }
            System.err.print("whyline >\tInstrumenting " + classname + "...");
            long beforeWriting = System.currentTimeMillis();
            if (DEBUG_INSTRUMENTATION) {
                ClassInstrumenter.debug("Done parsing " + classname);
            }
            int nextInstructionID = 0;
            int instructionsInstrumented = 0;
            int totalInstructions = 0;
            int methodCount = 0;
            long beforeMethods = System.currentTimeMillis();
            ClassInstrumentationInfo instrumentationData = new ClassInstrumentationInfo(classfile.getConstantPool());
            for (MethodInfo method : classfile.getDeclaredMethods()) {
                if (DEBUG_BEFORE_AND_AFTER) {
                    ClassInstrumenter.debug("Before\n" + method.getCode());
                }
                if (DEBUG_INSTRUMENTATION) {
                    ClassInstrumenter.debug("\tAnalyzing " + method.getClassfile().getInternalName() + " " + method.getInternalName() + method.getDescriptor());
                }
                if (method.getCode() != null) {
                    int numberOfInstructionsBeforeInstrumentation = method.getCode().getNumberOfInstructions();
                    MethodInstrumenter methodRefs = new MethodInstrumenter(instrumentationData, method, nextInstructionID);
                    try {
                        methodRefs.instrument();
                    }
                    catch (JavaSpecificationViolation e) {
                        e.printStackTrace();
                        Agent.classIDs.markMethodAsNotInstrumented(classname, method.getMethodNameAndDescriptor());
                    }
                    instructionsInstrumented += methodRefs.getNumberOfInstructionsInstrumented();
                    ++methodCount;
                    totalInstructions += method.getCode().getNumberOfInstructions();
                    nextInstructionID += numberOfInstructionsBeforeInstrumentation;
                }
                if (!DEBUG_BEFORE_AND_AFTER) continue;
                ClassInstrumenter.debug("After\n" + method.getCode());
            }
            long afterMethods = System.currentTimeMillis();
            long beforeToArray = System.currentTimeMillis();
            byte[] code = classfile.toByteArray();
            ClassInstrumenter.cache(classname, code);
            System.err.println("cached");
            long afterToArray = System.currentTimeMillis();
            long afterTime = System.currentTimeMillis();
            profiles.add(new InstrumentationProfile(classname, (double)(afterTime - beforeTime) / 1000.0, (double)(beforeWriting - beforeTime) / 1000.0, (double)(beforeMethods - beforeWriting) / 1000.0, (double)(afterMethods - beforeMethods) / 1000.0, (double)(afterToArray - beforeToArray) / 1000.0, totalInstructions, instructionsInstrumented, methodCount));
            return code;
        }
        catch (Exception e) {
            ClassInstrumenter.debug("Can't finish instrumenting " + classname + " because an exception was raised during instrumentation:\n\n");
            e.printStackTrace();
            Tracer.shutdown();
            System.exit(711);
            return null;
        }
    }

    public static void printInstrumentationStatistics() {
        ClassInstrumenter.debug("Instrumentation statistics, in the order that classes were loaded . . .");
        String header = InstrumentationProfile.getHeader();
        ClassInstrumenter.debug(header);
        ClassInstrumenter.debug(Util.fillString('-', header.length()));
        double totalTime = 0.0;
        int totalInstructionsInstrumented = 0;
        int totalMethods = 0;
        int totalInstructions = 0;
        for (InstrumentationProfile profile : profiles) {
            ClassInstrumenter.debug("" + profile);
            if (profile.skipped()) continue;
            totalTime += profile.totalSeconds;
            totalInstructionsInstrumented += profile.numberOfInstructionsInstrumented;
            totalMethods += profile.numberOfMethodsInstrumented;
            totalInstructions += profile.totalInstructions;
        }
        ClassInstrumenter.debug(Util.fillString('-', header.length()));
        ClassInstrumenter.debug(String.valueOf(Util.fillOrTruncateString("Instrumented " + totalNumberOfInstrumentedClasses + " classes", 40)) + "   " + Util.fillOrTruncateString("" + totalTime, 10) + "   " + Util.fillOrTruncateString("", 10) + "   " + Util.fillOrTruncateString("", 10) + "   " + Util.fillOrTruncateString("" + totalMethods, 10) + "   " + Util.fillOrTruncateString("" + totalInstructionsInstrumented, 10) + "   " + Util.fillOrTruncateString((int)(100.0 * (double)totalInstructionsInstrumented / (double)totalInstructions) + "% instrumented", 10));
        ClassInstrumenter.debug(Util.fillString('-', header.length()));
        ClassInstrumenter.debug("Instructions per second = " + (double)totalInstructionsInstrumented / totalTime);
        ClassInstrumenter.debug("Reading time = " + totalReadingTime);
        ClassInstrumenter.debug("Instrumentation time = " + totalInstrumentationTime);
        ClassInstrumenter.debug("Writing time = " + totalWritingTime);
        ClassInstrumenter.debug("To array time = " + totalConversionTime);
        ClassInstrumenter.debug("");
    }

    public class ClassInstrumentationInfo {
        private final ConstantPool pool;
        public final MethodrefInfo tracerDebugIn;
        public final MethodrefInfo tracerDebugOut;
        public final ClassInfo tracerClassInfo;
        private final EnumMap<EventKind, MethodrefInfo> methodRefsAdded = new EnumMap(EventKind.class);

        public ClassInstrumentationInfo(ConstantPool pool) throws JavaSpecificationViolation {
            this.pool = pool;
            this.tracerClassInfo = pool.addClassInfo(Tracer.class);
            this.tracerDebugIn = pool.addMethodrefInfo(this.tracerClassInfo, "debugIn", "()V");
            this.tracerDebugOut = pool.addMethodrefInfo(this.tracerClassInfo, "debugOut", "()V");
        }

        public MethodrefInfo getMethodFor(EventKind event) throws JavaSpecificationViolation {
            MethodrefInfo methodref = this.methodRefsAdded.get((Object)event);
            if (methodref == null) {
                methodref = this.pool.addMethodrefInfo(this.tracerClassInfo, event.name, event.descriptor);
                this.methodRefsAdded.put(event, methodref);
            }
            return methodref;
        }
    }
}

