/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace.nodes;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.trace.nodes.ReferenceState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalState
extends ReferenceState
implements Comparable<LocalState> {
    private String name;
    private String value;
    private int definitionID = -1;
    private final int localID;

    public LocalState(Trace trace, int localID) {
        super(trace, -1L);
        this.localID = localID;
        this.name = "-";
    }

    @Override
    public String toString() {
        this.update();
        return "<html><b>" + this.name + "</b> = " + this.value + "</html>";
    }

    @Override
    public int compareTo(LocalState object) {
        return this.localID - object.localID;
    }

    @Override
    public boolean isLeaf() {
        return this.objectID <= 0L;
    }

    @Override
    public long getObjectIDForChildren() {
        return this.objectID;
    }

    @Override
    protected boolean performUpdate() {
        int startID = this.trace.getStartID(this.currentEventID);
        int nextEventIDInThread = this.trace.getNextEventIDInThread(this.currentEventID);
        int eventIDToShow = this.trace.getStartID(nextEventIDInThread) == startID ? nextEventIDInThread : this.currentEventID;
        Instruction instruction = this.trace.getInstruction(eventIDToShow);
        this.name = instruction.getCode().getLocalIDNameRelativeToInstruction(this.localID, instruction);
        this.objectID = 0L;
        this.definitionID = this.trace.eventDefinesLocalID(this.currentEventID, this.localID) ? this.currentEventID : this.trace.findLocalIDAssignmentBefore(this.localID, this.currentEventID);
        if (this.definitionID < 0) {
            this.value = "<i>unknown</i>";
        } else {
            EventKind kind = this.trace.getKind(this.definitionID);
            if (kind.isArgument) {
                this.value = this.trace.getArgumentValueDescription(this.definitionID);
                if (kind == EventKind.OBJECT_ARG) {
                    this.objectID = this.trace.getObjectIDProduced(this.definitionID);
                }
            } else {
                Value valueSet = this.trace.getDefinitionValueSet(this.definitionID);
                if (valueSet == null) {
                    this.value = "<i>unknown</i>";
                } else {
                    this.value = valueSet.getDisplayName(true);
                    if (valueSet.isObject()) {
                        this.objectID = valueSet.getLong();
                    }
                }
            }
        }
        this.resetChildren();
        return true;
    }

    public int getDefinitionID() {
        this.update();
        return this.definitionID;
    }

    @Override
    public int getAssociatedEventID() {
        this.update();
        return this.definitionID;
    }

    @Override
    public String getAssociatedEventIDDescription() {
        return "value";
    }
}

