/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace.nodes;

import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.nodes.ArrayElementState;
import edu.cmu.hcii.whyline.trace.nodes.ReferenceState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayElementSeriesState
extends ReferenceState
implements Comparable<ArrayElementSeriesState> {
    private final Trace trace;
    private final int first;
    private final int last;
    private final long arrayID;
    private final QualifiedClassName type;

    public ArrayElementSeriesState(Trace trace, QualifiedClassName type, long arrayID, int startIndex, int endIndex) {
        super(trace, arrayID);
        this.arrayID = arrayID;
        this.trace = trace;
        this.type = type;
        this.first = startIndex;
        this.last = endIndex;
    }

    @Override
    public long getObjectIDForChildren() {
        return 0L;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    protected boolean performUpdate() {
        return false;
    }

    @Override
    public int getAssociatedEventID() {
        return -1;
    }

    @Override
    public String getAssociatedEventIDDescription() {
        return "value";
    }

    @Override
    protected void determineChildren() {
        int i = this.first;
        while (i <= this.last) {
            this.addChild(new ArrayElementState(this, i));
            ++i;
        }
    }

    @Override
    public String toString() {
        return "[" + this.first + " - " + this.last + "]";
    }

    @Override
    public int compareTo(ArrayElementSeriesState o) {
        return this.first - o.first;
    }

    public long getArrayID() {
        return this.arrayID;
    }

    public QualifiedClassName getType() {
        return this.type;
    }
}

