/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.trace.Trace;

public class Serializer {
    public static String lineToString(Line line) {
        return Serializer.listToString(Serializer.fileToString(line.getFile()), Integer.toString(line.getLineNumber().getNumber()));
    }

    public static Line stringToLine(Trace trace, String text) {
        String[] strings = Serializer.stringToList(text);
        return Serializer.stringToLine(trace, strings[0], strings[1]);
    }

    public static Line stringToLine(Trace trace, String sourcename, String lineNumber) {
        JavaSourceFile source = trace.getSourceByQualifiedName(sourcename);
        Integer number = Integer.parseInt(lineNumber);
        if (source == null) {
            return null;
        }
        try {
            return source.getLine(number);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String classfileToString(Classfile classfile) {
        return classfile.getInternalName().getText();
    }

    public static String methodToString(MethodInfo method) {
        return Serializer.listToString(Serializer.classfileToString(method.getClassfile()), method.getMethodNameAndDescriptor());
    }

    public static String fileToString(FileInterface entity) {
        return entity.getFileName();
    }

    public static String[] stringToList(String string) {
        return string.split(":");
    }

    public static String listToString(String ... args) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            builder.append(args[i]);
            if (i != args.length - 1) {
                builder.append(':');
            }
            ++i;
        }
        return builder.toString();
    }

    public static String instructionToString(Instruction entity) {
        return Serializer.listToString(Serializer.methodToString(entity.getMethod()), Integer.toString(entity.getIndex()));
    }

    public static MethodInfo stringToMethod(Trace trace, String classname, String methodname) {
        return Serializer.stringToClassfile(trace, classname).getDeclaredMethodByNameAndDescriptor(methodname);
    }

    public static Instruction stringtoInstruction(Trace trace, String classname, String methodname, String instructionIndex) {
        MethodInfo method = Serializer.stringToMethod(trace, classname, methodname);
        if (method == null) {
            System.err.println("Couldn't find " + classname + " " + methodname);
        }
        CodeAttribute code = method.getCode();
        return code.getInstruction(Integer.parseInt(instructionIndex));
    }

    public static Classfile stringToClassfile(Trace trace, String string) {
        return trace.getClassfileByName(QualifiedClassName.get(string));
    }
}

