/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.NEW;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.IntegerVector;
import edu.cmu.hcii.whyline.util.Saveable;
import gnu.trove.TLongIntHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class InstantiationHistory
implements Saveable {
    private final Trace trace;
    private final IntegerVector instantiationIDs;
    private final TLongIntHashMap instantiationsByObjectID = new TLongIntHashMap();

    public InstantiationHistory(Trace trace, long numberOfObjectsCreated) {
        this.trace = trace;
        this.instantiationIDs = new IntegerVector((int)((double)numberOfObjectsCreated * 0.8));
    }

    public void addArrayInstantiationID(int eventID, long arrayID) {
        this.instantiationsByObjectID.put(arrayID, eventID);
    }

    public void addObjectInstantiationID(int eventID, long objectID) {
        this.instantiationIDs.append(eventID);
        this.instantiationsByObjectID.put(objectID, eventID);
    }

    public IntegerVector getInstantiationsOf(Classfile classfile) {
        IntegerVector instantiations = new IntegerVector(10);
        int i = 0;
        while (i < this.instantiationIDs.size()) {
            QualifiedClassName classname;
            Classfile c;
            int eventID = this.instantiationIDs.get(i);
            Instruction allocation = this.trace.getInstruction(eventID);
            if (allocation instanceof NEW && (c = this.trace.getClassfileByName(classname = ((NEW)allocation).getClassInstantiated().getName())) != null && (c == classfile || c.isSubclassOf(classfile.getInternalName()))) {
                instantiations.append(eventID);
            }
            ++i;
        }
        return instantiations;
    }

    public int getInstantiationIDOf(long objectID) {
        int eventID = this.instantiationsByObjectID.get(objectID);
        return eventID == 0 ? -1 : eventID;
    }

    public void trimToSize() {
        this.instantiationsByObjectID.trimToSize();
        this.instantiationIDs.trimToSize();
    }

    public void write(DataOutputStream out) throws IOException {
        this.instantiationIDs.write(out);
        out.writeInt(this.instantiationsByObjectID.size());
        long[] lArray = this.instantiationsByObjectID.keys();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long objectID = lArray[n2];
            out.writeLong(objectID);
            out.writeInt(this.instantiationsByObjectID.get(objectID));
            ++n2;
        }
    }

    public void read(DataInputStream in) throws IOException {
        this.instantiationIDs.read(in);
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            this.instantiationsByObjectID.put(in.readLong(), in.readInt());
            ++i;
        }
        this.instantiationsByObjectID.trimToSize();
    }
}

